/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.HtmlUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public class HtmlResponseWriter
extends ResponseWriter {
    private String contentType = "text/html";
    private String encoding = null;
    private Writer writer = null;
    private boolean closeStart;
    private boolean dontEscape;
    private char[] buffer = new char[1028];
    private char[] charHolder = new char[1];
    static /* synthetic */ Class class$java$lang$Boolean;

    public HtmlResponseWriter(Writer writer, String contentType, String encoding) throws FacesException {
        this.writer = writer;
        if (null != contentType) {
            this.contentType = contentType;
        }
        this.encoding = encoding;
        try {
            HtmlUtils.validateEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(Util.getExceptionMessageString("com.sun.faces.ENCODING_ERROR"));
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
        this.writer.flush();
    }

    public void flush() throws IOException {
        this.closeStartIfNecessary();
    }

    public void startElement(String name, UIComponent componentForElement) throws IOException {
        if (name == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.closeStartIfNecessary();
        char firstChar = name.charAt(0);
        if ((firstChar == 's' || firstChar == 'S') && ("script".equalsIgnoreCase(name) || "style".equalsIgnoreCase(name))) {
            this.dontEscape = true;
        }
        this.writer.write("<");
        this.writer.write(name);
        this.closeStart = true;
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.dontEscape = false;
        if (this.closeStart) {
            boolean isEmptyElement = HtmlUtils.isEmptyElement(name);
            if (isEmptyElement) {
                this.writer.write(" />");
                this.closeStart = false;
                return;
            }
            this.writer.write(">");
            this.closeStart = false;
        }
        this.writer.write("</");
        this.writer.write(name);
        this.writer.write(">");
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null || value == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = HtmlResponseWriter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            if (Boolean.TRUE.equals(value)) {
                this.writer.write(" ");
                this.writer.write(name);
            }
        } else {
            this.writer.write(" ");
            this.writer.write(name);
            this.writer.write("=\"");
            HtmlUtils.writeAttribute(this.writer, this.buffer, value.toString());
            this.writer.write("\"");
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null || value == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write("=\"");
        String stringValue = value.toString();
        if (stringValue.startsWith("javascript:")) {
            HtmlUtils.writeAttribute(this.writer, this.buffer, stringValue);
        } else {
            HtmlUtils.writeURL(this.writer, stringValue, this.encoding);
        }
        this.writer.write("\"");
    }

    public void writeComment(Object comment) throws IOException {
        if (comment == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.closeStartIfNecessary();
        this.writer.write("<!-- ");
        this.writer.write(comment.toString());
        this.writer.write(" -->");
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        if (text == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text.toString());
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, text.toString());
        }
    }

    public void writeText(char text) throws IOException {
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text);
        } else {
            this.charHolder[0] = text;
            HtmlUtils.writeText(this.writer, this.buffer, this.charHolder);
        }
    }

    public void writeText(char[] text) throws IOException {
        if (text == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text);
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, text);
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (text == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (off < 0 || off > text.length || len < 0 || len > text.length) {
            throw new IndexOutOfBoundsException();
        }
        this.closeStartIfNecessary();
        if (this.dontEscape) {
            this.writer.write(text, off, len);
        } else {
            HtmlUtils.writeText(this.writer, this.buffer, text, off, len);
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        try {
            return new HtmlResponseWriter(writer, this.getContentType(), this.getCharacterEncoding());
        }
        catch (FacesException e) {
            throw new IllegalStateException();
        }
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.closeStart) {
            this.writer.write(">");
            this.closeStart = false;
        }
    }

    public void close() throws IOException {
        this.closeStartIfNecessary();
        this.writer.close();
    }

    public void write(char cbuf) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(cbuf);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(cbuf, off, len);
    }

    public void write(int c) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(c);
    }

    public void write(String str) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.writer.write(str, off, len);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

