/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.PositionConsumer;
import gnu.lists.PositionContainer;
import gnu.lists.Sequence;
import gnu.lists.TreePosition;

public class TreePositionList
extends AbstractSequence
implements Sequence,
PositionConsumer,
PositionContainer {
    int[] offsets;
    int size;
    AbstractSequence[] sposes = new AbstractSequence[20];
    int[] iposes = new int[20];
    Object[] xposes = new Object[20];
    int used;

    public TreePositionList() {
        this.offsets = new int[10];
    }

    public int size() {
        return this.size;
    }

    protected void makePosition(int n, boolean bl, PositionContainer positionContainer, int n2) {
        positionContainer.setPosition(n2, n << 1 | (bl ? 1 : 0), null);
        positionContainer.setSequence(n2, this);
    }

    public Object get(int n) {
        TreePosition treePosition = new TreePosition();
        this.get(n, treePosition);
        return treePosition;
    }

    public void get(int n, TreePosition treePosition) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        treePosition.clear();
        int n2 = this.offsets[n];
        int n3 = this.offsets[n + 1];
        int n4 = n3 - n2;
        if (n4 == 1 && this.sposes[n2] == null) {
            treePosition.xpos = this.xposes[n2];
        } else {
            int n5 = n2;
            while (n5 < n3) {
                treePosition.push(this.sposes[n5], this.iposes[n5], this.xposes[n5]);
                ++n5;
            }
        }
    }

    public boolean consume(TreePosition treePosition) {
        int[] nArray;
        int n = treePosition.getDepth();
        if (this.used + n >= this.xposes.length) {
            int n2 = 2 * this.xposes.length;
            if (this.used + n > n2) {
                n2 = this.used + n;
            }
            AbstractSequence[] abstractSequenceArray = new AbstractSequence[n2];
            nArray = new int[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.sposes, 0, abstractSequenceArray, 0, this.used);
            System.arraycopy(this.iposes, 0, nArray, 0, this.used);
            System.arraycopy(this.xposes, 0, objectArray, 0, this.used);
            this.sposes = abstractSequenceArray;
            this.iposes = nArray;
            this.xposes = objectArray;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            AbstractSequence abstractSequence = treePosition.sstack[n3];
            abstractSequence.copyPosition(treePosition.istack[n3], treePosition.xstack[n3], this, this.used);
            ++this.used;
            ++n3;
        }
        AbstractSequence abstractSequence = treePosition.sequence;
        if (n == 0) {
            this.xposes[this.used] = treePosition.xpos;
        } else {
            abstractSequence.copyPosition(treePosition.ipos, treePosition.xpos, this, this.used);
        }
        ++this.used;
        ++this.size;
        if (this.size >= this.offsets.length) {
            nArray = new int[2 * this.size];
            System.arraycopy(this.offsets, 0, nArray, 0, this.size);
            this.offsets = nArray;
        }
        this.offsets[this.size] = this.used;
        return true;
    }

    public boolean add(Object object2) {
        this.consume((TreePosition)object2);
        return true;
    }

    public void getPosition(int n, boolean bl, PositionContainer positionContainer, int n2) {
        positionContainer.setPosition(n2, n, null);
    }

    protected int nextIndex(int n, Object object2) {
        return n;
    }

    public int getPositionInt(int n) {
        return this.iposes[n];
    }

    public Object getPositionPtr(int n) {
        return this.xposes[n];
    }

    public void setPosition(int n, int n2, Object object2) {
        this.iposes[n] = n2;
        this.xposes[n] = object2;
    }

    public void setSequence(int n, AbstractSequence abstractSequence) {
        this.sposes[n] = abstractSequence;
    }

    public int countPositions() {
        return this.used;
    }

    public void finalize() {
        int n = this.used;
        while (--n >= 0) {
            AbstractSequence abstractSequence = this.sposes[n];
            if (abstractSequence == null) continue;
            abstractSequence.releasePosition(this.iposes[n], this.xposes[n]);
        }
        this.sposes = null;
        this.iposes = null;
        this.xposes = null;
        this.offsets = null;
        this.used = 0;
        this.size = 0;
    }
}

