/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Symbol;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Stack;
import java.util.Vector;
import kawa.lang.Pattern;
import kawa.lang.Translator;

public class SyntaxRule
implements Externalizable {
    Pattern pattern;
    String template_program;
    int num_variables;
    String pattern_nesting;
    int max_nesting;
    Object[] literal_values;
    String[] template_identifiers;
    Object[] captured_decls;
    static final String dots3 = "...";
    static final int RCONS = 1;
    static final int LIST1 = 2;
    static final int START_REPEAT = 3;
    static final int END_REPEAT = 4;
    static final int FIRST_VARS = 5;
    static final int FIRST_LITERALS = 6;
    static int counter;

    public SyntaxRule() {
    }

    public SyntaxRule(Pattern pattern, String string, String string2, String[] stringArray, Object[] objectArray, int n) {
        this.pattern = pattern;
        this.pattern_nesting = string;
        this.template_program = string2;
        this.template_identifiers = stringArray;
        this.literal_values = objectArray;
        this.max_nesting = n;
        this.num_variables = string.length();
    }

    public SyntaxRule(Pattern pattern, String string, Vector vector, Object object2, Translator translator) {
        this.pattern = pattern;
        this.pattern_nesting = string;
        this.num_variables = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        this.translate_template(object2, stringBuffer, vector, 0, vector2, vector3, 0, translator);
        this.template_program = stringBuffer.toString();
        this.literal_values = new Object[vector2.size()];
        vector2.copyInto(this.literal_values);
        int n = vector3.size();
        this.template_identifiers = new String[n];
        vector3.copyInto(this.template_identifiers);
        this.captured_decls = new Object[n];
        int n2 = n;
        while (--n2 >= 0) {
            this.captured_decls[n2] = translator.environ.get(this.template_identifiers[n2]);
        }
    }

    public void translate_template(Object object2, StringBuffer stringBuffer, Vector vector, int n, Vector vector2, Vector vector3, int n2, Translator translator) {
        int n3;
        if (object2 instanceof Pair) {
            int n4;
            Pair pair = (Pair)object2;
            if (pair.cdr instanceof Pair) {
                Pair pair2 = (Pair)pair.cdr;
                if (pair2.car == dots3) {
                    this.translate_template(pair2.cdr, stringBuffer, vector, n, vector2, vector3, n2, translator);
                    stringBuffer.append('\u0003');
                    if (n >= this.max_nesting) {
                        this.max_nesting = n + 1;
                    }
                    this.translate_template(pair.car, stringBuffer, vector, n + 1, vector2, vector3, n2, translator);
                    stringBuffer.append('\u0004');
                    return;
                }
            }
            if (pair.cdr == LList.Empty) {
                n4 = 2;
            } else {
                n4 = 1;
                int n5 = n2;
                if (pair.car == "quote") {
                    n5 = -1;
                } else if (pair.car == "quasiquote" && n5 >= 0) {
                    ++n5;
                } else if ((pair.car == "unquote" || pair.car == "unquote-splicing") && n5 > 0) {
                    --n5;
                }
                this.translate_template(pair.cdr, stringBuffer, vector, n, vector2, vector3, n5, translator);
            }
            this.translate_template(pair.car, stringBuffer, vector, n, vector2, vector3, n2, translator);
            stringBuffer.append((char)n4);
            return;
        }
        if (object2 instanceof String) {
            n3 = SyntaxRule.indexOf(vector, object2);
            if (n3 >= 0) {
                if (this.pattern_nesting.charAt(n3) > n) {
                    translator.syntaxError("inconsistent ... nesting of " + object2);
                }
                stringBuffer.append((char)(5 + 2 * n3));
                return;
            }
            if (n2 == 0 && object2 != "quote" && object2 != "quasiquote" && object2 != "unquote" && object2 != "unquote-splicing") {
                int n6 = SyntaxRule.indexOf(vector3, object2);
                if (n6 < 0) {
                    n6 = vector3.size();
                    vector3.addElement(object2);
                }
                n3 = n6 + this.num_variables;
                stringBuffer.append((char)(5 + 2 * n3));
                return;
            }
        }
        if ((n3 = SyntaxRule.indexOf(vector2, object2)) < 0) {
            n3 = vector2.size();
            vector2.addElement(object2);
        }
        stringBuffer.append((char)(6 + 2 * n3));
    }

    private static int indexOf(Vector vector, Object object2) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) == object2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Object execute_template(Object[] objectArray, Translator translator, Pair pair) {
        int[] nArray = new int[this.max_nesting];
        int n = this.template_identifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String string = this.template_identifiers[n2];
            String string2 = Symbol.makeUninterned(string);
            objectArray[this.num_variables + n2] = string2;
            Object object2 = this.captured_decls == null ? null : this.captured_decls[n2];
            translator.environ.put(string2, object2 == null ? string : object2);
            ++n2;
        }
        return this.execute_template(0, objectArray, 0, nArray, translator, pair);
    }

    private Object execute_template(int n, Object[] objectArray, int n2, int[] nArray, Translator translator, Pair pair) {
        Stack<Object> stack = new Stack<Object>();
        int n3 = this.template_program.length();
        int n4 = n;
        while (n4 < n3) {
            char c = this.template_program.charAt(n4);
            if (c == '\u0001') {
                Object e = stack.pop();
                Object object2 = stack.pop();
                object2 = n4 + 1 == n3 && pair instanceof PairWithPosition ? new PairWithPosition((PairWithPosition)pair, e, object2) : new Pair(e, object2);
                stack.push(object2);
            } else if (c == '\u0002') {
                Object e = stack.pop();
                stack.push(new Pair(e, LList.Empty));
            } else if (c == '\u0003') {
                Object[] objectArray2;
                int n5;
                Object object3;
                int n6 = -1;
                n = n4 + 1;
                int n7 = 0;
                n4 = n;
                while (true) {
                    int n8;
                    if ((c = this.template_program.charAt(n4)) == '\u0003') {
                        ++n7;
                    } else if (c == '\u0004') {
                        if (n7 == 0) break;
                        --n7;
                    } else if (c >= '\u0005' && (c & '\u0001') == 1 && (n8 = c - 5 >> 1) < this.num_variables) {
                        object3 = objectArray[n8];
                        char c2 = this.pattern_nesting.charAt(n8);
                        if (c2 > n2) {
                            n5 = 0;
                            while (n5 < n2) {
                                object3 = ((Object[])object3)[nArray[n5]];
                                ++n5;
                            }
                            objectArray2 = (Object[])object3;
                            if (n6 == -1) {
                                n6 = objectArray2.length;
                            } else if (n6 != objectArray2.length) {
                                translator.syntaxError("inconsistent lengths of repeated variables");
                                n6 = 0;
                            }
                        }
                    }
                    ++n4;
                }
                if (n6 < 0) {
                    translator.syntaxError("... follows template with no suitably-nested pattern variable");
                    n6 = 0;
                }
                Pair pair2 = null;
                object3 = stack.pop();
                LList lList = LList.Empty;
                n5 = 0;
                while (n5 < n6) {
                    nArray[n2] = n5;
                    objectArray2 = this.execute_template(n, objectArray, n2 + 1, nArray, translator, pair);
                    Pair pair3 = new Pair(objectArray2, LList.Empty);
                    if (pair2 == null) {
                        lList = pair3;
                    } else {
                        pair2.cdr = pair3;
                    }
                    pair2 = pair3;
                    ++n5;
                }
                if (pair2 == null) {
                    lList = object3;
                } else {
                    pair2.cdr = object3;
                }
                stack.push(lList);
            } else {
                if (c == '\u0004') break;
                if ((c & '\u0001') == 0) {
                    stack.push(this.literal_values[c - 6 >> 1]);
                } else {
                    int n9 = c - 5 >> 1;
                    Object object4 = objectArray[n9];
                    if (n9 < this.pattern_nesting.length()) {
                        int n10 = this.pattern_nesting.charAt(n9);
                        int n11 = 0;
                        while (n11 < n10) {
                            object4 = ((Object[])object4)[nArray[n11]];
                            ++n11;
                        }
                    }
                    stack.push(object4);
                }
            }
            ++n4;
        }
        return stack.pop();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.pattern);
        objectOutput.writeObject(this.pattern_nesting);
        objectOutput.writeObject(this.template_program);
        objectOutput.writeObject(this.template_identifiers);
        objectOutput.writeObject(this.literal_values);
        objectOutput.writeInt(this.max_nesting);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.pattern = (Pattern)objectInput.readObject();
        this.pattern_nesting = (String)objectInput.readObject();
        this.template_program = (String)objectInput.readObject();
        this.template_identifiers = (String[])objectInput.readObject();
        this.literal_values = (Object[])objectInput.readObject();
        this.max_nesting = objectInput.readInt();
    }
}

