/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Barcode39
extends Barcode {
    static byte[][] BARS;
    static String CHARS;
    static String EXTENDED;

    static {
        byte[][] byArrayArray = new byte[44][];
        byte[] byArray = new byte[9];
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[6] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[9];
        byArray2[0] = 1;
        byArray2[3] = 1;
        byArray2[8] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[9];
        byArray3[2] = 1;
        byArray3[3] = 1;
        byArray3[8] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[9];
        byArray4[0] = 1;
        byArray4[2] = 1;
        byArray4[3] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[9];
        byArray5[3] = 1;
        byArray5[4] = 1;
        byArray5[8] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[9];
        byArray6[0] = 1;
        byArray6[3] = 1;
        byArray6[4] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[9];
        byArray7[2] = 1;
        byArray7[3] = 1;
        byArray7[4] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[9];
        byArray8[3] = 1;
        byArray8[6] = 1;
        byArray8[8] = 1;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[9];
        byArray9[0] = 1;
        byArray9[3] = 1;
        byArray9[6] = 1;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[9];
        byArray10[2] = 1;
        byArray10[3] = 1;
        byArray10[6] = 1;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[9];
        byArray11[0] = 1;
        byArray11[5] = 1;
        byArray11[8] = 1;
        byArrayArray[10] = byArray11;
        byte[] byArray12 = new byte[9];
        byArray12[2] = 1;
        byArray12[5] = 1;
        byArray12[8] = 1;
        byArrayArray[11] = byArray12;
        byte[] byArray13 = new byte[9];
        byArray13[0] = 1;
        byArray13[2] = 1;
        byArray13[5] = 1;
        byArrayArray[12] = byArray13;
        byte[] byArray14 = new byte[9];
        byArray14[4] = 1;
        byArray14[5] = 1;
        byArray14[8] = 1;
        byArrayArray[13] = byArray14;
        byte[] byArray15 = new byte[9];
        byArray15[0] = 1;
        byArray15[4] = 1;
        byArray15[5] = 1;
        byArrayArray[14] = byArray15;
        byte[] byArray16 = new byte[9];
        byArray16[2] = 1;
        byArray16[4] = 1;
        byArray16[5] = 1;
        byArrayArray[15] = byArray16;
        byte[] byArray17 = new byte[9];
        byArray17[5] = 1;
        byArray17[6] = 1;
        byArray17[8] = 1;
        byArrayArray[16] = byArray17;
        byte[] byArray18 = new byte[9];
        byArray18[0] = 1;
        byArray18[5] = 1;
        byArray18[6] = 1;
        byArrayArray[17] = byArray18;
        byte[] byArray19 = new byte[9];
        byArray19[2] = 1;
        byArray19[5] = 1;
        byArray19[6] = 1;
        byArrayArray[18] = byArray19;
        byte[] byArray20 = new byte[9];
        byArray20[4] = 1;
        byArray20[5] = 1;
        byArray20[6] = 1;
        byArrayArray[19] = byArray20;
        byte[] byArray21 = new byte[9];
        byArray21[0] = 1;
        byArray21[7] = 1;
        byArray21[8] = 1;
        byArrayArray[20] = byArray21;
        byte[] byArray22 = new byte[9];
        byArray22[2] = 1;
        byArray22[7] = 1;
        byArray22[8] = 1;
        byArrayArray[21] = byArray22;
        byte[] byArray23 = new byte[9];
        byArray23[0] = 1;
        byArray23[2] = 1;
        byArray23[7] = 1;
        byArrayArray[22] = byArray23;
        byte[] byArray24 = new byte[9];
        byArray24[4] = 1;
        byArray24[7] = 1;
        byArray24[8] = 1;
        byArrayArray[23] = byArray24;
        byte[] byArray25 = new byte[9];
        byArray25[0] = 1;
        byArray25[4] = 1;
        byArray25[7] = 1;
        byArrayArray[24] = byArray25;
        byte[] byArray26 = new byte[9];
        byArray26[2] = 1;
        byArray26[4] = 1;
        byArray26[7] = 1;
        byArrayArray[25] = byArray26;
        byte[] byArray27 = new byte[9];
        byArray27[6] = 1;
        byArray27[7] = 1;
        byArray27[8] = 1;
        byArrayArray[26] = byArray27;
        byte[] byArray28 = new byte[9];
        byArray28[0] = 1;
        byArray28[6] = 1;
        byArray28[7] = 1;
        byArrayArray[27] = byArray28;
        byte[] byArray29 = new byte[9];
        byArray29[2] = 1;
        byArray29[6] = 1;
        byArray29[7] = 1;
        byArrayArray[28] = byArray29;
        byte[] byArray30 = new byte[9];
        byArray30[4] = 1;
        byArray30[6] = 1;
        byArray30[7] = 1;
        byArrayArray[29] = byArray30;
        byte[] byArray31 = new byte[9];
        byArray31[0] = 1;
        byArray31[1] = 1;
        byArray31[8] = 1;
        byArrayArray[30] = byArray31;
        byte[] byArray32 = new byte[9];
        byArray32[1] = 1;
        byArray32[2] = 1;
        byArray32[8] = 1;
        byArrayArray[31] = byArray32;
        byte[] byArray33 = new byte[9];
        byArray33[0] = 1;
        byArray33[1] = 1;
        byArray33[2] = 1;
        byArrayArray[32] = byArray33;
        byte[] byArray34 = new byte[9];
        byArray34[1] = 1;
        byArray34[4] = 1;
        byArray34[8] = 1;
        byArrayArray[33] = byArray34;
        byte[] byArray35 = new byte[9];
        byArray35[0] = 1;
        byArray35[1] = 1;
        byArray35[4] = 1;
        byArrayArray[34] = byArray35;
        byte[] byArray36 = new byte[9];
        byArray36[1] = 1;
        byArray36[2] = 1;
        byArray36[4] = 1;
        byArrayArray[35] = byArray36;
        byte[] byArray37 = new byte[9];
        byArray37[1] = 1;
        byArray37[6] = 1;
        byArray37[8] = 1;
        byArrayArray[36] = byArray37;
        byte[] byArray38 = new byte[9];
        byArray38[0] = 1;
        byArray38[1] = 1;
        byArray38[6] = 1;
        byArrayArray[37] = byArray38;
        byte[] byArray39 = new byte[9];
        byArray39[1] = 1;
        byArray39[2] = 1;
        byArray39[6] = 1;
        byArrayArray[38] = byArray39;
        byte[] byArray40 = new byte[9];
        byArray40[1] = 1;
        byArray40[3] = 1;
        byArray40[5] = 1;
        byArrayArray[39] = byArray40;
        byte[] byArray41 = new byte[9];
        byArray41[1] = 1;
        byArray41[3] = 1;
        byArray41[7] = 1;
        byArrayArray[40] = byArray41;
        byte[] byArray42 = new byte[9];
        byArray42[1] = 1;
        byArray42[5] = 1;
        byArray42[7] = 1;
        byArrayArray[41] = byArray42;
        byte[] byArray43 = new byte[9];
        byArray43[3] = 1;
        byArray43[5] = 1;
        byArray43[7] = 1;
        byArrayArray[42] = byArray43;
        byte[] byArray44 = new byte[9];
        byArray44[1] = 1;
        byArray44[4] = 1;
        byArray44[6] = 1;
        byArrayArray[43] = byArray44;
        BARS = byArrayArray;
        CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*";
        EXTENDED = "%U$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O$P$Q$R$S$T$U$V$W$X$Y$Z%A%B%C%D%E  /A/B/C/D/E/F/G/H/I/J/K/L - ./O 0 1 2 3 4 5 6 7 8 9/Z%F%G%H%I%J%V A B C D E F G H I J K L M N O P Q R S T U V W X Y Z%K%L%M%N%O%W+A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+X+Y+Z%P%Q%R%S%T";
    }

    public Barcode39() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            this.startStopText = true;
            this.extended = false;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static byte[] getBarsCode39(String string) {
        string = "*" + string + "*";
        byte[] byArray = new byte[string.length() * 10 - 1];
        int n = 0;
        while (n < string.length()) {
            int n2 = CHARS.indexOf(string.charAt(n));
            if (n2 < 0) {
                throw new IllegalArgumentException("The character '" + string.charAt(n) + "' is illegal in code 39.");
            }
            System.arraycopy(BARS[n2], 0, byArray, n * 10, 9);
            ++n;
        }
        return byArray;
    }

    public static String getCode39Ex(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > '\u007f') {
                throw new IllegalArgumentException("The character '" + c + "' is illegal in code 39 extended.");
            }
            char c2 = EXTENDED.charAt(c * 2);
            char c3 = EXTENDED.charAt(c * 2 + 1);
            if (c2 != ' ') {
                string2 = String.valueOf(string2) + c2;
            }
            string2 = String.valueOf(string2) + c3;
            ++n;
        }
        return string2;
    }

    static char getChecksum(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = CHARS.indexOf(string.charAt(n2));
            if (n3 < 0) {
                throw new IllegalArgumentException("The character '" + string.charAt(n2) + "' is illegal in code 39.");
            }
            n += n3;
            ++n2;
        }
        return CHARS.charAt(n % 43);
    }

    public Rectangle getBarcodeSize() {
        String string;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.font != null) {
            f2 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.generateChecksum && this.checksumText) {
                string = String.valueOf(string) + Barcode39.getChecksum(string);
            }
            if (this.startStopText) {
                string = "*" + string + "*";
            }
            f = this.font.getWidthPoint(string, this.size);
        }
        string = this.code;
        if (this.extended) {
            string = Barcode39.getCode39Ex(this.code);
        }
        int n = string.length() + 2;
        if (this.generateChecksum) {
            ++n;
        }
        float f3 = (float)n * (6.0f * this.x + 3.0f * this.x * this.n) + (float)(n - 1) * this.x;
        f3 = Math.max(f3, f);
        float f4 = this.barHeight + f2;
        return new Rectangle(f3, f4);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        float f = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                string = String.valueOf(string) + Barcode39.getChecksum(string);
            }
            if (this.startStopText) {
                string = "*" + string + "*";
            }
            f = this.font.getWidthPoint(string, this.size);
        }
        String string2 = this.code;
        if (this.extended) {
            string2 = Barcode39.getCode39Ex(this.code);
        }
        if (this.generateChecksum) {
            string2 = String.valueOf(string2) + Barcode39.getChecksum(string2);
        }
        int n = string2.length() + 2;
        float f2 = (float)n * (6.0f * this.x + 3.0f * this.x * this.n) + (float)(n - 1) * this.x;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f > f2) {
                    f3 = f - f2;
                    break;
                }
                f4 = f2 - f;
                break;
            }
            default: {
                if (f > f2) {
                    f3 = (f - f2) / 2.0f;
                    break;
                }
                f4 = (f2 - f) / 2.0f;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f6 = this.barHeight - this.baseline;
            } else {
                f6 = -this.font.getFontDescriptor(3, this.size);
                f5 = f6 + this.baseline;
            }
        }
        byte[] byArray = Barcode39.getBarsCode39(string2);
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            float f7;
            float f8 = f7 = byArray[n2] == 0 ? this.x : this.x * this.n;
            if (bl) {
                pdfContentByte.rectangle(f3, f5, f7 - this.inkSpreading, this.barHeight);
            }
            bl = !bl;
            f3 += f7;
            ++n2;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f4, f6);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n = color.getRGB();
        int n2 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = this.code;
        if (this.extended) {
            string = Barcode39.getCode39Ex(this.code);
        }
        if (this.generateChecksum) {
            string = String.valueOf(string) + Barcode39.getChecksum(string);
        }
        int n3 = string.length() + 2;
        int n4 = (int)this.n;
        int n5 = n3 * (6 + 3 * n4) + (n3 - 1);
        byte[] byArray = Barcode39.getBarsCode39(string);
        boolean bl = true;
        int n6 = 0;
        int n7 = (int)this.barHeight;
        int[] nArray = new int[n5 * n7];
        int n8 = 0;
        while (n8 < byArray.length) {
            int n9 = byArray[n8] == 0 ? 1 : n4;
            int n10 = n2;
            if (bl) {
                n10 = n;
            }
            bl = !bl;
            int n11 = 0;
            while (n11 < n9) {
                nArray[n6++] = n10;
                ++n11;
            }
            ++n8;
        }
        n8 = n5;
        while (n8 < nArray.length) {
            System.arraycopy(nArray, 0, nArray, n8, n5);
            n8 += n5;
        }
        Image image = canvas.createImage(new MemoryImageSource(n5, n7, nArray, 0, n5));
        return image;
    }
}

