/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;

public class DefaultFontMapper
implements FontMapper {
    private HashMap aliases = new HashMap();
    private HashMap mapper = new HashMap();

    public BaseFont awtToPdf(Font font) {
        try {
            BaseFontParameters baseFontParameters = this.getBaseFontParameters(font.getFontName());
            if (baseFontParameters != null) {
                return BaseFont.createFont(baseFontParameters.fontName, baseFontParameters.encoding, baseFontParameters.embedded, baseFontParameters.cached, baseFontParameters.ttfAfm, baseFontParameters.pfb);
            }
            String string = null;
            String string2 = font.getName();
            string = string2.equalsIgnoreCase("DialogInput") || string2.equalsIgnoreCase("Monospaced") || string2.equalsIgnoreCase("Courier") ? (font.isItalic() ? (font.isBold() ? "Courier-BoldOblique" : "Courier-Oblique") : (font.isBold() ? "Courier-Bold" : "Courier")) : (string2.equalsIgnoreCase("Serif") || string2.equalsIgnoreCase("TimesRoman") ? (font.isItalic() ? (font.isBold() ? "Times-BoldItalic" : "Times-Italic") : (font.isBold() ? "Times-Bold" : "Times-Roman")) : (font.isItalic() ? (font.isBold() ? "Helvetica-BoldOblique" : "Helvetica-Oblique") : (font.isBold() ? "Helvetica-Bold" : "Helvetica")));
            return BaseFont.createFont(string, "Cp1252", false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public Font pdfToAwt(BaseFont baseFont, int n) {
        String[][] stringArray = baseFont.getFullFontName();
        if (stringArray.length == 1) {
            return new Font(stringArray[0][3], 0, n);
        }
        String string = null;
        String string2 = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String[] stringArray2 = stringArray[n2];
            if (stringArray2[0].equals("1") && stringArray2[1].equals("0")) {
                string = stringArray2[3];
            } else if (stringArray2[2].equals("1033")) {
                string2 = stringArray2[3];
                break;
            }
            ++n2;
        }
        String string3 = string2;
        if (string3 == null) {
            string3 = string;
        }
        if (string3 == null) {
            string3 = stringArray[0][3];
        }
        return new Font(string3, 0, n);
    }

    public void putName(String string, BaseFontParameters baseFontParameters) {
        this.mapper.put(string, baseFontParameters);
    }

    public void putAlias(String string, String string2) {
        this.aliases.put(string, string2);
    }

    public BaseFontParameters getBaseFontParameters(String string) {
        String string2 = (String)this.aliases.get(string);
        if (string2 == null) {
            return (BaseFontParameters)this.mapper.get(string);
        }
        BaseFontParameters baseFontParameters = (BaseFontParameters)this.mapper.get(string2);
        if (baseFontParameters == null) {
            return (BaseFontParameters)this.mapper.get(string);
        }
        return baseFontParameters;
    }

    public void insertNames(Object[] objectArray, String string) {
        String[][] stringArray = (String[][])objectArray[2];
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            if (stringArray2[2].equals("1033")) {
                string2 = stringArray2[3];
                break;
            }
            ++n;
        }
        if (string2 == null) {
            string2 = stringArray[0][3];
        }
        BaseFontParameters baseFontParameters = new BaseFontParameters(string);
        this.mapper.put(string2, baseFontParameters);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.aliases.put(stringArray[n2][3], string2);
            ++n2;
        }
        this.aliases.put((String)objectArray[0], string2);
    }

    public int insertDirectory(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            file = fileArray[n2];
            String string2 = file.getPath().toLowerCase();
            try {
                Object[] objectArray;
                if (string2.endsWith(".ttf") || string2.endsWith(".otf") || string2.endsWith(".afm")) {
                    objectArray = BaseFont.getAllFontNames(file.getPath(), "Cp1252", null);
                    this.insertNames(objectArray, file.getPath());
                    ++n;
                } else if (string2.endsWith(".ttc")) {
                    objectArray = BaseFont.enumerateTTCNames(file.getPath());
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        String string3 = String.valueOf(file.getPath()) + "," + n3;
                        Object[] objectArray2 = BaseFont.getAllFontNames(string3, "Cp1252", null);
                        this.insertNames(objectArray2, string3);
                        ++n3;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return n;
    }

    public HashMap getMapper() {
        return this.mapper;
    }

    public HashMap getAliases() {
        return this.aliases;
    }

    public static class BaseFontParameters {
        public String fontName;
        public String encoding;
        public boolean embedded;
        public boolean cached;
        public byte[] ttfAfm;
        public byte[] pfb;

        public BaseFontParameters(String string) {
            this.fontName = string;
            this.encoding = "Cp1252";
            this.embedded = true;
            this.cached = true;
        }
    }
}

