/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.StringCompare;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNameTree {
    private static final int leafSize = 64;
    private static final StringCompare stringCompare = new StringCompare();

    public static PdfDictionary writeTree(HashMap hashMap, PdfWriter pdfWriter) throws IOException {
        int n;
        int n2;
        if (hashMap.size() == 0) {
            return null;
        }
        String[] stringArray = new String[hashMap.size()];
        stringArray = hashMap.keySet().toArray(stringArray);
        Arrays.sort(stringArray, stringCompare);
        if (stringArray.length <= 64) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            int n3 = 0;
            while (n3 < stringArray.length) {
                pdfArray.add(new PdfString(stringArray[n3], null));
                pdfArray.add((PdfIndirectReference)hashMap.get(stringArray[n3]));
                ++n3;
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            return pdfDictionary;
        }
        int n4 = 64;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[(stringArray.length + 64 - 1) / 64];
        int n5 = 0;
        while (n5 < pdfIndirectReferenceArray.length) {
            n2 = n5 * 64;
            n = Math.min(n2 + 64, stringArray.length);
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            pdfArray.add(new PdfString(stringArray[n2], null));
            pdfArray.add(new PdfString(stringArray[n - 1], null));
            pdfDictionary.put(PdfName.LIMITS, pdfArray);
            pdfArray = new PdfArray();
            while (n2 < n) {
                pdfArray.add(new PdfString(stringArray[n2], null));
                pdfArray.add((PdfIndirectReference)hashMap.get(stringArray[n2]));
                ++n2;
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            pdfIndirectReferenceArray[n5] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
            ++n5;
        }
        n5 = pdfIndirectReferenceArray.length;
        while (true) {
            if (n5 <= 64) {
                PdfArray pdfArray = new PdfArray();
                n = 0;
                while (n < n5) {
                    pdfArray.add(pdfIndirectReferenceArray[n]);
                    ++n;
                }
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                return pdfDictionary;
            }
            n2 = (stringArray.length + (n4 *= 64) - 1) / n4;
            n = 0;
            while (n < n2) {
                int n6 = n * 64;
                int n7 = Math.min(n6 + 64, n5);
                PdfDictionary pdfDictionary = new PdfDictionary();
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfString(stringArray[n * n4], null));
                pdfArray.add(new PdfString(stringArray[Math.min((n + 1) * n4, stringArray.length) - 1], null));
                pdfDictionary.put(PdfName.LIMITS, pdfArray);
                pdfArray = new PdfArray();
                while (n6 < n7) {
                    pdfArray.add(pdfIndirectReferenceArray[n6]);
                    ++n6;
                }
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                pdfIndirectReferenceArray[n] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
                ++n;
            }
            n5 = n2;
        }
    }

    private static void iterateItems(PdfDictionary pdfDictionary, HashMap hashMap) {
        block3: {
            PdfArray pdfArray;
            block2: {
                pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES));
                if (pdfArray == null) break block2;
                ArrayList arrayList = pdfArray.getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    PdfString pdfString = (PdfString)PdfReader.getPdfObject((PdfObject)arrayList.get(n++));
                    hashMap.put(pdfString.toString(), arrayList.get(n));
                    ++n;
                }
                break block3;
            }
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) break block3;
            ArrayList arrayList = pdfArray.getArrayList();
            int n = 0;
            while (n < arrayList.size()) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                PdfNameTree.iterateItems(pdfDictionary2, hashMap);
                ++n;
            }
        }
    }

    public static HashMap readTree(PdfDictionary pdfDictionary) {
        HashMap hashMap = new HashMap();
        if (pdfDictionary != null) {
            PdfNameTree.iterateItems(pdfDictionary, hashMap);
        }
        return hashMap;
    }
}

