/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.text.pdf.StampContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class PdfStamperImp
extends PdfWriter {
    HashMap readers2intrefs = new HashMap();
    HashMap readers2file = new HashMap();
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected int[] namePtr = new int[1];
    protected boolean namedAsNames;
    protected List newBookmarks;
    protected HashSet partialFlattening = new HashSet();
    protected boolean useVp = false;
    protected int vp = 0;
    protected HashMap fieldTemplates = new HashMap();
    protected boolean fieldsAdded = false;
    protected int sigFlags = 0;
    protected boolean append;
    protected IntHashtable marked;

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c, boolean bl) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        this.append = bl;
        if (bl) {
            int n;
            if (pdfReader.isRebuilt()) {
                throw new DocumentException("Append mode requires a document without errors even if recovery was possible.");
            }
            if (pdfReader.isEncrypted()) {
                throw new DocumentException("Append mode requires a document without encryption.");
            }
            this.HEADER = PdfStamperImp.getISOBytes("\n");
            this.file.reOpen();
            byte[] byArray = new byte[8192];
            while ((n = this.file.read(byArray)) > 0) {
                this.os.write(byArray, 0, n);
            }
            this.file.close();
            this.prevxref = pdfReader.getLastXref();
            pdfReader.setAppendable(true);
        } else if (c == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        } else {
            super.setPdfVersion(c);
        }
        super.open();
        this.pdf.addWriter(this);
        if (bl) {
            this.body.setRefnum(pdfReader.getXrefSize());
            this.marked = new IntHashtable();
            if (pdfReader.isNewXrefType()) {
                this.setFullCompression();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(HashMap var1_1) throws DocumentException, IOException {
        if (this.closed) {
            return;
        }
        if (this.useVp) {
            this.reader.setViewerPreferences(this.vp);
            this.markUsed(this.reader.getTrailer().get(PdfName.ROOT));
        }
        if (this.flat) {
            this.flatFields();
        }
        this.addFieldResources();
        if (this.sigFlags != 0 && (var2_2 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog())) != null) {
            var2_2.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
            this.markUsed(var2_2);
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        this.setJavaScript();
        var2_2 = null;
        try {
            block26: {
                this.file.reOpen();
                this.alterContents();
                var3_3 /* !! */  = this.reader.xrefObj;
                var2_2 = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
                var4_4 = -1;
                if (var2_2 != null) {
                    var4_4 = var2_2.getNumber();
                }
                var5_6 = ((PRIndirectReference)this.reader.trailer.get(PdfName.ROOT)).getNumber();
                if (!this.append) break block26;
                var6_9 /* !! */  = this.marked.getKeys();
                var7_11 = 0;
                if (true) ** GOTO lbl39
            }
            var6_10 = 1;
            if (true) ** GOTO lbl46
            do {
                if (var3_3 /* !! */ [var8_13 = var6_9 /* !! */ [var7_11]] != null && var4_4 != var8_13) {
                    this.addToBody(var3_3 /* !! */ [var8_13], var8_13, var8_13 != var5_6);
                }
                ++var7_11;
lbl39:
                // 2 sources

            } while (var7_11 < var6_9 /* !! */ .length);
            ** GOTO lbl-1000
            do {
                if (var3_3 /* !! */ [var6_10] != null && var4_4 != var6_10) {
                    this.addToBody(var3_3 /* !! */ [var6_10], this.getNewObjectNumber(this.reader, var6_10, 0), var6_10 != var5_6);
                }
                ++var6_10;
lbl46:
                // 2 sources

            } while (var6_10 < var3_3 /* !! */ .length);
        }
        catch (Throwable var10_15) {
            var9_17 = null;
            try {
                this.file.close();
                throw var10_15;
            }
            catch (Exception v0) {}
            throw var10_15;
        }
lbl-1000:
        // 2 sources

        {
            var9_18 = null;
        }
        try {}
        catch (Exception v1) {}
        this.file.close();
        var3_3 /* !! */  = null;
        var4_5 = null;
        if (this.crypto != null) {
            var5_7 = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
            var3_3 /* !! */  = var5_7.getIndirectReference();
            var4_5 = this.crypto.getFileID();
        }
        var5_8 = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        var6_9 /* !! */  = (int[])new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, var5_8.getNumber(), 0));
        var7_12 = null;
        var8_14 = (PdfDictionary)PdfReader.getPdfObject(var2_2);
        var9_18 = new PdfDictionary();
        if (var8_14 != null) {
            var10_16 = var8_14.getKeys().iterator();
            while (var10_16.hasNext()) {
                var11_19 = (PdfName)var10_16.next();
                var12_20 = PdfReader.getPdfObject(var8_14.get((PdfName)var11_19));
                var9_18.put((PdfName)var11_19, var12_20);
            }
        }
        if (var1_1 != null) {
            var10_16 = var1_1.keySet().iterator();
            while (var10_16.hasNext()) {
                var11_19 = (String)var10_16.next();
                var12_20 = new PdfName((String)var11_19);
                var13_21 = (String)var1_1.get(var11_19);
                if (var13_21 == null) {
                    var9_18.remove((PdfName)var12_20);
                    continue;
                }
                var9_18.put((PdfName)var12_20, new PdfString(var13_21, "UnicodeBig"));
            }
        }
        if (this.append) {
            var7_12 = var2_2 == null ? this.addToBody((PdfObject)var9_18, false).getIndirectReference() : this.addToBody((PdfObject)var9_18, var2_2.getNumber(), false).getIndirectReference();
        } else if (!var9_18.getKeys().isEmpty()) {
            var7_12 = this.addToBody((PdfObject)var9_18, false).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os, (PdfIndirectReference)var6_9 /* !! */ , var7_12, (PdfIndirectReference)var3_3 /* !! */ , var4_5, this.prevxref);
        if (this.fullCompression) {
            this.os.write(PdfStamperImp.getISOBytes("startxref\n"));
            this.os.write(PdfStamperImp.getISOBytes(String.valueOf(this.body.offset())));
            this.os.write(PdfStamperImp.getISOBytes("\n%%EOF\n"));
        } else {
            var10_16 = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), (PdfIndirectReference)var6_9 /* !! */ , var7_12, (PdfIndirectReference)var3_3 /* !! */ , var4_5, this.prevxref);
            var10_16.toPdf(this, this.os);
        }
        this.os.flush();
        if (this.isCloseStream() == false) return;
        this.os.close();
    }

    void applyRotation(int n, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(n);
        int n2 = rectangle.getRotation();
        switch (n2) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.top());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.right());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.top());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.right());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        Iterator iterator = this.pagesToContent.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            PageStamp pageStamp = (PageStamp)this.pagesToContent.get(n);
            PdfDictionary pdfDictionary = this.reader.getPageN(n);
            this.markUsed(pdfDictionary);
            PdfArray pdfArray = null;
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS), pdfDictionary);
            if (pdfObject == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
                this.markUsed(pdfArray);
            } else if (pdfObject.isStream()) {
                pdfArray = new PdfArray();
                pdfArray.add(pdfDictionary.get(PdfName.CONTENTS));
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            } else {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.CONTENTS, pdfArray);
            }
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(n, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
            try {
                pdfStream.flateCompress();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            pdfArray.addFirst(this.addToBody(pdfStream).getIndirectReference());
            byteBuffer.reset();
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(n, byteBuffer);
                byteBuffer.append(pageStamp.over.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
                pdfStream = new PdfStream(byteBuffer.toByteArray());
                try {
                    pdfStream.flateCompress();
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                pdfArray.add(this.addToBody(pdfStream).getIndirectReference());
            }
            this.alterResources(pageStamp);
        }
    }

    void alterResources(PageStamp pageStamp) {
        PdfDictionary pdfDictionary = this.reader.getPageN(pageStamp.pageNumber);
        pdfDictionary.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        IntHashtable intHashtable = (IntHashtable)this.readers2intrefs.get(pdfReader);
        if (intHashtable != null) {
            int n3 = intHashtable.get(n);
            if (n3 == 0) {
                n3 = this.getIndirectReferenceNumber();
                intHashtable.put(n, n3);
            }
            return n3;
        }
        if (this.currentPdfReaderInstance == null) {
            if (this.append) {
                return n;
            }
            int n4 = this.myXref.get(n);
            if (n4 == 0) {
                n4 = this.getIndirectReferenceNumber();
                this.myXref.put(n, n4);
            }
            return n4;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
            if (randomAccessFileOrArray != null) {
                return randomAccessFileOrArray;
            }
            return pdfReader.getSafeFile();
        }
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    public void registerReader(PdfReader pdfReader, boolean bl) throws IOException {
        if (this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.put(pdfReader, new IntHashtable());
        if (bl) {
            RandomAccessFileOrArray randomAccessFileOrArray = pdfReader.getSafeFile();
            this.readers2file.put(pdfReader, randomAccessFileOrArray);
            randomAccessFileOrArray.reOpen();
        }
    }

    public void unRegisterReader(PdfReader pdfReader) {
        if (!this.readers2intrefs.containsKey(pdfReader)) {
            return;
        }
        this.readers2intrefs.remove(pdfReader);
        RandomAccessFileOrArray randomAccessFileOrArray = (RandomAccessFileOrArray)this.readers2file.get(pdfReader);
        if (randomAccessFileOrArray == null) {
            return;
        }
        this.readers2file.remove(pdfReader);
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
    }

    static void findAllObjects(PdfReader pdfReader, PdfObject pdfObject, IntHashtable intHashtable) {
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                if (pdfReader != pRIndirectReference.getReader()) {
                    return;
                }
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    return;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
                PdfStamperImp.findAllObjects(pdfReader, PdfReader.getPdfObject(pdfObject), intHashtable);
                return;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    PdfStamperImp.findAllObjects(pdfReader, (PdfObject)arrayList.get(n), intHashtable);
                    ++n;
                }
                return;
            }
            case 6: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfName pdfName = (PdfName)iterator.next();
                    PdfStamperImp.findAllObjects(pdfReader, pdfDictionary.get(pdfName), intHashtable);
                }
                return;
            }
        }
    }

    public void addComments(FdfReader fdfReader) throws IOException {
        PdfObject pdfObject;
        PdfObject pdfObject2;
        if (this.readers2intrefs.containsKey(fdfReader)) {
            return;
        }
        PdfDictionary pdfDictionary = fdfReader.getCatalog();
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FDF))) == null) {
            return;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        this.registerReader(fdfReader, false);
        IntHashtable intHashtable = new IntHashtable();
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList arrayList2 = pdfArray.getArrayList();
        int n = 0;
        while (n < arrayList2.size()) {
            PdfObject pdfObject3 = (PdfObject)arrayList2.get(n);
            pdfObject2 = (PdfDictionary)PdfReader.getPdfObject(pdfObject3);
            pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfObject2.get(PdfName.PAGE));
            if (pdfObject != null && ((PdfNumber)pdfObject).intValue() < this.reader.getNumberOfPages()) {
                PdfStamperImp.findAllObjects(fdfReader, pdfObject3, intHashtable);
                arrayList.add(pdfObject3);
            }
            ++n;
        }
        int[] nArray = intHashtable.getKeys();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            this.addToBody(fdfReader.xrefObj[n3], this.getNewObjectNumber(fdfReader, n3, 0));
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            pdfObject2 = (PdfObject)arrayList.get(n2);
            pdfObject = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.PAGE));
            PdfDictionary pdfDictionary2 = this.reader.getPageN(pdfNumber.intValue() + 1);
            PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ANNOTS), pdfDictionary2);
            if (pdfArray2 == null) {
                pdfArray2 = new PdfArray();
                pdfDictionary2.put(PdfName.ANNOTS, pdfArray2);
                this.markUsed(pdfDictionary2);
            }
            this.markUsed(pdfArray2);
            pdfArray2.add(pdfObject2);
            ++n2;
        }
    }

    PageStamp getPageStamp(int n) {
        Integer n2 = new Integer(n);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(n2);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, n);
            this.pagesToContent.put(n2, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getUnderContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.under == null) {
            pageStamp.under = new StampContent(this, n);
        }
        return pageStamp.under;
    }

    PdfContentByte getOverContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, n);
        }
        return pageStamp.over;
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    boolean partialFormFlattening(String string) {
        this.getAcroFields();
        if (!this.acroFields.getFields().containsKey(string)) {
            return false;
        }
        this.partialFlattening.add(string);
        return true;
    }

    void flatFields() {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.append) {
            throw new IllegalArgumentException("Field flattening is not supported in append mode.");
        }
        this.getAcroFields();
        HashMap hashMap = this.acroFields.getFields();
        if (this.fieldsAdded && this.partialFlattening.isEmpty()) {
            object4 = hashMap.keySet().iterator();
            while (object4.hasNext()) {
                this.partialFlattening.add(object4.next());
            }
        }
        object4 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        ArrayList arrayList = null;
        if (object4 != null && (object3 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.FIELDS), (PdfObject)object4)) != null) {
            arrayList = ((PdfArray)object3).getArrayList();
        }
        object3 = hashMap.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(object2)) continue;
            object = (AcroFields.Item)hashMap.get(object2);
            int n = 0;
            while (n < ((AcroFields.Item)object).merged.size()) {
                Object object5;
                Object object6;
                Object object7;
                PdfObject pdfObject2;
                PdfDictionary pdfDictionary = (PdfDictionary)((AcroFields.Item)object).merged.get(n);
                pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
                int n2 = 0;
                if (pdfObject != null) {
                    n2 = ((PdfNumber)pdfObject).intValue();
                }
                int n3 = (Integer)((AcroFields.Item)object).page.get(n);
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
                if (pdfDictionary2 != null && (n2 & 4) != 0 && (n2 & 2) == 0) {
                    Object object8;
                    pdfObject2 = pdfDictionary2.get(PdfName.N);
                    object7 = null;
                    object6 = PdfReader.getPdfObject(pdfObject2);
                    if (pdfObject2 instanceof PdfIndirectReference && !pdfObject2.isIndirect()) {
                        object7 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                    } else if (object6 instanceof PdfStream) {
                        ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                        object7 = new PdfAppearance((PdfIndirectReference)pdfObject2);
                    } else if (((PdfObject)object6).isDictionary() && (object8 = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AS))) != null && (object5 = (PdfIndirectReference)((PdfDictionary)object6).get((PdfName)object8)) != null) {
                        object7 = new PdfAppearance((PdfIndirectReference)object5);
                        if (((PdfObject)object5).isIndirect()) {
                            object6 = PdfReader.getPdfObject((PdfObject)object5);
                            ((PdfDictionary)object6).put(PdfName.SUBTYPE, PdfName.FORM);
                        }
                    }
                    if (object7 != null) {
                        object8 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT)));
                        object5 = this.getOverContent(n3);
                        ((PdfContentByte)object5).setLiteral("Q ");
                        ((PdfContentByte)object5).addTemplate((PdfTemplate)object7, ((Rectangle)object8).left(), ((Rectangle)object8).bottom());
                        ((PdfContentByte)object5).setLiteral("q ");
                    }
                }
                if (!this.partialFlattening.isEmpty() && (object7 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)(pdfObject2 = this.reader.getPageN(n3))).get(PdfName.ANNOTS))) != null) {
                    object6 = ((PdfArray)object7).getArrayList();
                    int n4 = 0;
                    while (n4 < ((ArrayList)object6).size()) {
                        PdfObject pdfObject3;
                        object5 = (PdfObject)((ArrayList)object6).get(n4);
                        if (((PdfObject)object5).isIndirect() && (pdfObject3 = (PdfObject)((AcroFields.Item)object).widget_refs.get(n)).isIndirect() && ((PRIndirectReference)object5).getNumber() == ((PRIndirectReference)pdfObject3).getNumber()) {
                            ((ArrayList)object6).remove(n4--);
                            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject3;
                            while (true) {
                                PdfObject pdfObject4;
                                PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                                PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary3.get(PdfName.PARENT);
                                PdfReader.killIndirect(pRIndirectReference);
                                if (pRIndirectReference2 == null) {
                                    int n5 = 0;
                                    while (n5 < arrayList.size()) {
                                        pdfObject4 = (PdfObject)arrayList.get(n5);
                                        if (pdfObject4.isIndirect() && ((PRIndirectReference)pdfObject4).getNumber() == pRIndirectReference.getNumber()) {
                                            arrayList.remove(n5);
                                            --n5;
                                        }
                                        ++n5;
                                    }
                                    break;
                                }
                                PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
                                pdfObject4 = (PdfArray)PdfReader.getPdfObject(pdfDictionary4.get(PdfName.KIDS));
                                ArrayList arrayList2 = ((PdfArray)pdfObject4).getArrayList();
                                int n6 = 0;
                                while (n6 < arrayList2.size()) {
                                    PdfObject pdfObject5 = (PdfObject)arrayList2.get(n6);
                                    if (pdfObject5.isIndirect() && ((PRIndirectReference)pdfObject5).getNumber() == pRIndirectReference.getNumber()) {
                                        arrayList2.remove(n6);
                                        --n6;
                                    }
                                    ++n6;
                                }
                                if (!arrayList2.isEmpty()) break;
                                pRIndirectReference = pRIndirectReference2;
                            }
                        }
                        ++n4;
                    }
                    if (((ArrayList)object6).size() == 0) {
                        PdfReader.killIndirect(((PdfDictionary)pdfObject2).get(PdfName.ANNOTS));
                        ((PdfDictionary)pdfObject2).remove(PdfName.ANNOTS);
                    }
                }
                ++n;
            }
        }
        if (!this.fieldsAdded && this.partialFlattening.isEmpty()) {
            int n = 1;
            while (n <= this.reader.getNumberOfPages()) {
                object2 = this.reader.getPageN(n);
                object = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.ANNOTS));
                if (object != null) {
                    ArrayList arrayList3 = ((PdfArray)object).getArrayList();
                    int n7 = 0;
                    while (n7 < arrayList3.size()) {
                        PdfDictionary pdfDictionary;
                        pdfObject = PdfReader.getPdfObject((PdfObject)arrayList3.get(n7));
                        if ((!(pdfObject instanceof PdfIndirectReference) || pdfObject.isIndirect()) && PdfName.WIDGET.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) {
                            arrayList3.remove(n7);
                            --n7;
                        }
                        ++n7;
                    }
                    if (arrayList3.size() == 0) {
                        PdfReader.killIndirect(((PdfDictionary)object2).get(PdfName.ANNOTS));
                        ((PdfDictionary)object2).remove(PdfName.ANNOTS);
                    }
                }
                ++n;
            }
            this.eliminateAcroformObjects();
        }
    }

    void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
        }
    }

    void sweepKids(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.killIndirect(pdfObject);
        if (!pdfObject2.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            this.sweepKids((PdfObject)arrayList.get(n));
            ++n;
        }
    }

    public PdfIndirectReference getPageReference(int n) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return pRIndirectReference;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        PdfArray pdfArray;
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ACROFORM), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.ACROFORM, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FIELDS), pdfDictionary2)) == null) {
            pdfArray = new PdfArray();
            pdfDictionary2.put(PdfName.FIELDS, pdfArray);
            this.markUsed(pdfDictionary2);
        }
        pdfArray.add(pdfIndirectReference);
        this.markUsed(pdfArray);
    }

    void addFieldResources() {
        PdfDictionary pdfDictionary;
        if (this.fieldTemplates.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary2 = this.reader.getCatalog();
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ACROFORM), pdfDictionary2);
        if (pdfDictionary3 == null) {
            pdfDictionary3 = new PdfDictionary();
            pdfDictionary2.put(PdfName.ACROFORM, pdfDictionary3);
            this.markUsed(pdfDictionary2);
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR), pdfDictionary3)) == null) {
            pdfDictionary = new PdfDictionary();
            pdfDictionary3.put(PdfName.DR, pdfDictionary);
            this.markUsed(pdfDictionary3);
        }
        this.markUsed(pdfDictionary);
        Object object = this.fieldTemplates.keySet().iterator();
        while (object.hasNext()) {
            PdfTemplate pdfTemplate = (PdfTemplate)object.next();
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)pdfTemplate.getResources(), this);
        }
        object = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONT));
        if (object != null && pdfDictionary3.get(PdfName.DA) == null) {
            pdfDictionary3.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(pdfDictionary3);
        }
    }

    void expandFields(PdfFormField pdfFormField, ArrayList arrayList) {
        arrayList.add(pdfFormField);
        ArrayList arrayList2 = pdfFormField.getKids();
        if (arrayList2 != null) {
            int n = 0;
            while (n < arrayList2.size()) {
                this.expandFields((PdfFormField)arrayList2.get(n), arrayList);
                ++n;
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        try {
            ArrayList<PdfAnnotation> arrayList = new ArrayList<PdfAnnotation>();
            if (pdfAnnotation.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
                if (pdfFormField.getParent() != null) {
                    return;
                }
                this.expandFields(pdfFormField, arrayList);
            } else {
                arrayList.add(pdfAnnotation);
            }
            int n2 = 0;
            while (n2 < arrayList.size()) {
                Object object;
                pdfAnnotation = (PdfAnnotation)arrayList.get(n2);
                int n3 = n;
                if (pdfAnnotation.getPlaceInPage() > 0) {
                    n3 = pdfAnnotation.getPlaceInPage();
                }
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.fieldTemplates.putAll(object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    PdfRectangle pdfRectangle;
                    object = this.reader.getPageN(n3);
                    PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.ANNOTS), (PdfObject)object);
                    if (pdfArray == null) {
                        pdfArray = new PdfArray();
                        ((PdfDictionary)object).put(PdfName.ANNOTS, pdfArray);
                        this.markUsed((PdfObject)object);
                    }
                    pdfArray.add(pdfAnnotation.getIndirectReference());
                    this.markUsed(pdfArray);
                    if (!(pdfAnnotation.isUsed() || (pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT)).left() == 0.0f && pdfRectangle.right() == 0.0f && pdfRectangle.top() == 0.0f && pdfRectangle.bottom() == 0.0f)) {
                        int n4 = this.reader.getPageRotation(n3);
                        Rectangle rectangle = this.reader.getPageSizeWithRotation(n3);
                        switch (n4) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.top() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.top() - pdfRectangle.top(), pdfRectangle.right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.right() - pdfRectangle.left(), rectangle.top() - pdfRectangle.bottom(), rectangle.right() - pdfRectangle.right(), rectangle.top() - pdfRectangle.top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.right() - pdfRectangle.left(), pdfRectangle.top(), rectangle.right() - pdfRectangle.right()));
                            }
                        }
                    }
                }
                if (!pdfAnnotation.isUsed()) {
                    pdfAnnotation.setUsed();
                    this.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private void outlineTravel(PRIndirectReference pRIndirectReference) {
        while (pRIndirectReference != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary.get(PdfName.FIRST);
            if (pRIndirectReference2 != null) {
                this.outlineTravel(pRIndirectReference2);
            }
            PdfReader.killIndirect(pdfDictionary.get(PdfName.DEST));
            PdfReader.killIndirect(pdfDictionary.get(PdfName.A));
            PdfReader.killIndirect(pRIndirectReference);
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.OUTLINES);
        if (pRIndirectReference == null) {
            return;
        }
        this.outlineTravel(pRIndirectReference);
        PdfReader.killIndirect(pRIndirectReference);
        pdfDictionary.remove(PdfName.OUTLINES);
        this.markUsed(pdfDictionary);
    }

    void setJavaScript() throws IOException {
        ArrayList arrayList = this.pdf.getDocumentJavaScript();
        if (arrayList.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.NAMES, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        this.markUsed(pdfDictionary2);
        String string = String.valueOf(arrayList.size() - 1);
        int n = string.length();
        String string2 = "000000000000000";
        HashMap hashMap = new HashMap();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            string = String.valueOf(n2);
            string = String.valueOf(string2.substring(0, n - string.length())) + string;
            hashMap.put(string, arrayList.get(n2));
            ++n2;
        }
        PdfDictionary pdfDictionary3 = PdfNameTree.writeTree(hashMap, this);
        pdfDictionary2.put(PdfName.JAVASCRIPT, this.addToBody(pdfDictionary3).getIndirectReference());
    }

    void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.size() == 0) {
            return;
        }
        this.namedAsNames = this.reader.getCatalog().get(PdfName.DESTS) != null;
        PdfDictionary pdfDictionary = new PdfDictionary();
        PdfIndirectReference pdfIndirectReference = this.getPdfIndirectReference();
        Object[] objectArray = SimpleBookmark.iterateOutlines(this, pdfIndirectReference, this.newBookmarks, this.namedAsNames);
        pdfDictionary.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
        pdfDictionary.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
        pdfDictionary.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
        this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
        this.reader.getCatalog().put(PdfName.OUTLINES, pdfIndirectReference);
        this.markUsed(this.reader.getCatalog());
    }

    void setOutlines(List list) {
        this.newBookmarks = list;
    }

    public void setViewerPreferences(int n) {
        this.useVp = true;
        this.vp |= n;
    }

    public void setSigFlags(int n) {
        this.sigFlags |= n;
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setPageAction(PdfName pdfName, PdfAction pdfAction, int n) throws PdfException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + pdfName.toString());
        }
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AA), pdfDictionary);
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
            pdfDictionary.put(PdfName.AA, pdfDictionary2);
            this.markUsed(pdfDictionary);
        }
        pdfDictionary2.put(pdfName, pdfAction);
        this.markUsed(pdfDictionary2);
    }

    public void setDuration(int n) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    public void setTransition(PdfTransition pdfTransition) {
        throw new UnsupportedOperationException("Use setPageAction(PdfName actionType, PdfAction action, int page)");
    }

    void setDuration(int n, int n2) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n2);
        if (n < 0) {
            pdfDictionary.remove(PdfName.DUR);
        } else {
            pdfDictionary.put(PdfName.DUR, new PdfNumber(n));
        }
        this.markUsed(pdfDictionary);
    }

    void setTransition(PdfTransition pdfTransition, int n) {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        if (pdfTransition == null) {
            pdfDictionary.remove(PdfName.TRANS);
        } else {
            pdfDictionary.put(PdfName.TRANS, pdfTransition.getTransitionDictionary());
        }
        this.markUsed(pdfDictionary);
    }

    protected void markUsed(PdfObject pdfObject) {
        if (this.append && pdfObject != null) {
            PRIndirectReference pRIndirectReference = null;
            pRIndirectReference = pdfObject.type() == 10 ? (PRIndirectReference)pdfObject : pdfObject.getIndRef();
            if (pRIndirectReference != null) {
                this.marked.put(pRIndirectReference.getNumber(), 1);
            }
        }
    }

    protected void markUsed(int n) {
        if (this.append) {
            this.marked.put(n, 1);
        }
    }

    boolean isAppend() {
        return this.append;
    }

    static class PageStamp {
        int pageNumber;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp pdfStamperImp, PdfReader pdfReader, int n) {
            this.pageNumber = n;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary = pdfReader.getPageN(n);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(pdfDictionary2, pdfStamperImp.namePtr);
        }
    }
}

