/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfPhrase
extends RtfElement {
    public static final byte[] PARAGRAPH_DEFAULTS = "\\pard".getBytes();
    protected static final byte[] IN_TABLE = "\\intbl".getBytes();
    protected ArrayList chunks = new ArrayList();

    public RtfPhrase(RtfDocument rtfDocument, Phrase phrase) {
        super(rtfDocument);
        if (phrase == null) {
            return;
        }
        ArrayList arrayList = phrase.getChunks();
        int n = 0;
        while (n < arrayList.size()) {
            Chunk chunk = (Chunk)arrayList.get(n);
            chunk.setFont(phrase.font().difference(chunk.font()));
            try {
                this.chunks.add(rtfDocument.getMapper().mapElement(chunk));
            }
            catch (DocumentException documentException) {}
            ++n;
        }
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                byteArrayOutputStream.write(IN_TABLE);
            }
            int n = 0;
            while (n < this.chunks.size()) {
                byteArrayOutputStream.write(((RtfBasicElement)this.chunks.get(n)).write());
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        int n = 0;
        while (n < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(n)).setInTable(bl);
            ++n;
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        int n = 0;
        while (n < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(n)).setInHeader(bl);
            ++n;
        }
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        int n = 0;
        while (n < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(n)).setRtfDocument(this.document);
            ++n;
        }
    }
}

