/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Entities;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Graphic;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXiTextHandler
extends DefaultHandler {
    protected DocListener document;
    protected Stack stack;
    protected int chapters = 0;
    protected Chunk currentChunk = null;
    protected boolean ignore = false;
    protected boolean controlOpenClose = true;

    public SAXiTextHandler(DocListener docListener) {
        this.document = docListener;
        this.stack = new Stack();
    }

    public void setControlOpenClose(boolean bl) {
        this.controlOpenClose = bl;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Properties properties = new Properties();
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string4 = attributes.getQName(n);
                properties.setProperty(string4, attributes.getValue(n));
                ++n;
            }
        }
        this.handleStartingTags(string3, properties);
    }

    public void handleStartingTags(String string, Properties properties) {
        Object object;
        if (this.ignore || "ignore".equals(string)) {
            this.ignore = true;
            return;
        }
        if (this.currentChunk != null) {
            try {
                object = (TextElementArray)this.stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                object = new Paragraph();
            }
            object.add(this.currentChunk);
            this.stack.push(object);
            this.currentChunk = null;
        }
        if (Chunk.isTag(string)) {
            this.currentChunk = new Chunk(properties);
            return;
        }
        if (Entities.isTag(string)) {
            object = new Font();
            if (this.currentChunk != null) {
                this.handleEndingTags("chunk");
                object = this.currentChunk.font();
            }
            this.currentChunk = Entities.get(properties.getProperty("id"), (Font)object);
            return;
        }
        if (Phrase.isTag(string)) {
            this.stack.push(new Phrase(properties));
            return;
        }
        if (Anchor.isTag(string)) {
            this.stack.push(new Anchor(properties));
            return;
        }
        if (Paragraph.isTag(string) || Section.isTitle(string)) {
            this.stack.push(new Paragraph(properties));
            return;
        }
        if (List.isTag(string)) {
            this.stack.push(new List(properties));
            return;
        }
        if (ListItem.isTag(string)) {
            this.stack.push(new ListItem(properties));
            return;
        }
        if (Cell.isTag(string)) {
            this.stack.push(new Cell(properties));
            return;
        }
        if (Table.isTag(string)) {
            object = new Table(properties);
            float[] fArray = ((Table)object).getProportionalWidths();
            int n = 0;
            while (n < fArray.length) {
                if (fArray[n] == 0.0f) {
                    fArray[n] = 100.0f / (float)fArray.length;
                }
                ++n;
            }
            try {
                ((Table)object).setWidths(fArray);
            }
            catch (BadElementException badElementException) {
                throw new ExceptionConverter(badElementException);
            }
            this.stack.push(object);
            return;
        }
        if (Section.isTag(string)) {
            Section section;
            object = (Element)this.stack.pop();
            try {
                section = ((Section)object).addSection(properties);
            }
            catch (ClassCastException classCastException) {
                throw new ExceptionConverter(classCastException);
            }
            this.stack.push(object);
            this.stack.push(section);
            return;
        }
        if (Chapter.isTag(string)) {
            object = (String)properties.remove("number");
            this.chapters = object != null ? Integer.parseInt((String)object) : ++this.chapters;
            Chapter chapter = new Chapter(properties, this.chapters);
            this.stack.push(chapter);
            return;
        }
        if (Image.isTag(string)) {
            try {
                object = Image.getInstance(properties);
                try {
                    Object e = this.stack.pop();
                    if (e instanceof Chapter || e instanceof Section || e instanceof Cell) {
                        ((TextElementArray)e).add(object);
                        this.stack.push(e);
                        return;
                    }
                    Stack stack = new Stack();
                    try {
                        while (!(e instanceof Chapter || e instanceof Section || e instanceof Cell)) {
                            stack.push(e);
                            if (e instanceof Anchor) {
                                ((Image)object).setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, ((Anchor)e).reference()));
                            }
                            e = this.stack.pop();
                        }
                        ((TextElementArray)e).add(object);
                        this.stack.push(e);
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add((Element)object);
                    }
                    while (!stack.empty()) {
                        this.stack.push(stack.pop());
                    }
                    return;
                }
                catch (EmptyStackException emptyStackException) {
                    try {
                        this.document.add((Element)object);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    return;
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        if (Annotation.isTag(string)) {
            object = new Annotation(properties);
            try {
                try {
                    TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                    try {
                        textElementArray.add(object);
                    }
                    catch (Exception exception) {
                        this.document.add((Element)object);
                    }
                    this.stack.push(textElementArray);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object);
                }
                return;
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
        }
        if (this.isNewline(string)) {
            try {
                object = (TextElementArray)this.stack.pop();
                object.add(Chunk.NEWLINE);
                this.stack.push(object);
            }
            catch (EmptyStackException emptyStackException) {
                if (this.currentChunk == null) {
                    try {
                        this.document.add(Chunk.NEWLINE);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                }
                this.currentChunk.append("\n");
            }
            return;
        }
        if (this.isNewpage(string)) {
            try {
                object = (TextElementArray)this.stack.pop();
                Chunk chunk = new Chunk("");
                chunk.setNewPage();
                object.add(chunk);
                this.stack.push(object);
            }
            catch (EmptyStackException emptyStackException) {
                try {
                    this.document.newPage();
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            return;
        }
        if ("horizontalrule".equals(string)) {
            Graphic graphic = new Graphic();
            graphic.setHorizontalLine(1.0f, 100.0f);
            try {
                object = (TextElementArray)this.stack.pop();
                object.add(graphic);
                this.stack.push(object);
            }
            catch (EmptyStackException emptyStackException) {
                try {
                    this.document.add(graphic);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            return;
        }
        if (this.isDocumentRoot(string)) {
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string2 = properties.getProperty((String)object);
                try {
                    this.document.add(new Meta((String)object, string2));
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (this.controlOpenClose) {
                this.document.open();
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.ignore) {
            return;
        }
        String string = new String(cArray, n, n2);
        if (string.trim().length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            switch (c) {
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(c);
                    break;
                }
                case '\n': {
                    if (n4 <= 0) break;
                    bl = true;
                    stringBuffer.append(' ');
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    break;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
            ++n4;
        }
        if (this.currentChunk == null) {
            this.currentChunk = new Chunk(stringBuffer.toString());
        } else {
            this.currentChunk.append(stringBuffer.toString());
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.handleEndingTags(string3);
    }

    /*
     * Unable to fully structure code
     */
    public void handleEndingTags(String var1_1) {
        block49: {
            if ("ignore".equals(var1_1)) {
                this.ignore = false;
                return;
            }
            if (this.ignore) {
                return;
            }
            if (this.isNewpage(var1_1) || Annotation.isTag(var1_1) || Image.isTag(var1_1) || this.isNewline(var1_1)) {
                return;
            }
            try {
                if (Section.isTitle(var1_1)) {
                    var2_2 = (Paragraph)this.stack.pop();
                    if (this.currentChunk != null) {
                        var2_2.add(this.currentChunk);
                        this.currentChunk = null;
                    }
                    var3_5 = (Section)this.stack.pop();
                    var3_5.setTitle(var2_2);
                    this.stack.push(var3_5);
                    return;
                }
                if (this.currentChunk != null) {
                    try {
                        var2_3 = (TextElementArray)this.stack.pop();
                    }
                    catch (EmptyStackException v0) {
                        var2_3 = new Paragraph();
                    }
                    var2_3.add(this.currentChunk);
                    this.stack.push(var2_3);
                    this.currentChunk = null;
                }
                if (Chunk.isTag(var1_1)) {
                    return;
                }
                if (Phrase.isTag(var1_1) || Anchor.isTag(var1_1) || List.isTag(var1_1) || Paragraph.isTag(var1_1)) {
                    var2_3 = (Element)this.stack.pop();
                    try {
                        var3_6 = (TextElementArray)this.stack.pop();
                        var3_6.add(var2_3);
                        this.stack.push(var3_6);
                    }
                    catch (EmptyStackException v1) {
                        this.document.add((Element)var2_3);
                    }
                    return;
                }
                if (ListItem.isTag(var1_1)) {
                    var2_3 = (ListItem)this.stack.pop();
                    var3_7 = (List)this.stack.pop();
                    var3_7.add(var2_3);
                    this.stack.push(var3_7);
                }
                if (Table.isTag(var1_1)) {
                    var2_3 = (Table)this.stack.pop();
                    try {
                        var3_7 = (TextElementArray)this.stack.pop();
                        var3_7.add(var2_3);
                        this.stack.push(var3_7);
                    }
                    catch (EmptyStackException v2) {
                        this.document.add((Element)var2_3);
                    }
                    return;
                }
                if (Row.isTag(var1_1)) {
                    var2_3 = new ArrayList<E>();
                    var3_8 = 0;
                    while ((var6_11 = (Element)this.stack.pop()).type() == 20) {
                        var5_10 = (Cell)var6_11;
                        var3_8 += var5_10.colspan();
                        var2_3.add(var5_10);
                    }
                    var4_12 = (Table)var6_11;
                    if (var4_12.columns() < var3_8) {
                        var4_12.addColumns(var3_8 - var4_12.columns());
                    }
                    Collections.reverse(var2_3);
                    var7_13 = new float[var3_8];
                    var8_14 = new boolean[var3_8];
                    var9_15 = 0;
                    while (var9_15 < var3_8) {
                        var7_13[var9_15] = 0.0f;
                        var8_14[var9_15] = true;
                        ++var9_15;
                    }
                    var9_16 = 0.0f;
                    var10_17 = 0;
                    var11_18 = var2_3.iterator();
                    while (var11_18.hasNext()) {
                        var5_10 = (Cell)var11_18.next();
                        var6_11 = var5_10.cellWidth();
                        if (var6_11 == null) {
                            if (var5_10.colspan() == 1 && var7_13[var10_17] == 0.0f) {
                                try {
                                    var7_13[var10_17] = 100.0f / (float)var3_8;
                                    var9_16 += var7_13[var10_17];
                                }
                                catch (Exception v3) {}
                            } else if (var5_10.colspan() == 1) {
                                var8_14[var10_17] = false;
                            }
                        } else if (var5_10.colspan() == 1 && var6_11.endsWith("%")) {
                            try {
                                var7_13[var10_17] = Float.valueOf(String.valueOf(var6_11.substring(0, var6_11.length() - 1)) + "f").floatValue();
                                var9_16 += var7_13[var10_17];
                            }
                            catch (Exception v4) {}
                        }
                        var10_17 += var5_10.colspan();
                        var4_12.addCell(var5_10);
                    }
                    var11_18 = var4_12.getProportionalWidths();
                    if (((Object)var11_18).length == var3_8) {
                        var12_19 = 0.0f;
                        var13_20 = 0;
                        while (var13_20 < var3_8) {
                            if (var8_14[var13_20] && var11_18[var13_20] != 0.0f) {
                                var12_19 += var11_18[var13_20];
                                var7_13[var13_20] = (float)var11_18[var13_20];
                            }
                            ++var13_20;
                        }
                        if (100.0 >= (double)var9_16) {
                            var13_20 = 0;
                            while (var13_20 < ((Object)var11_18).length) {
                                if (var7_13[var13_20] == 0.0f && var11_18[var13_20] != 0.0f) {
                                    var7_13[var13_20] = (float)(var11_18[var13_20] / var12_19 * (100.0f - var9_16));
                                }
                                ++var13_20;
                            }
                        }
                        var4_12.setWidths(var7_13);
                    }
                    this.stack.push(var4_12);
                }
                if (Cell.isTag(var1_1)) {
                    return;
                }
                if (Section.isTag(var1_1)) {
                    this.stack.pop();
                    return;
                }
                if (Chapter.isTag(var1_1)) {
                    this.document.add((Element)this.stack.pop());
                    return;
                }
                if (!this.isDocumentRoot(var1_1)) break block49;
                block21: while (true) lbl-1000:
                // 2 sources

                {
                    try {
                        while (true) {
                            var2_3 = (Element)this.stack.pop();
                            try {
                                var3_9 = (TextElementArray)this.stack.pop();
                                var3_9.add(var2_3);
                                this.stack.push(var3_9);
                                continue block21;
                            }
                            catch (EmptyStackException v5) {
                                this.document.add((Element)var2_3);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (EmptyStackException v6) {
                        if (this.controlOpenClose) {
                            this.document.close();
                        }
                        return;
                    }
                    break;
                }
            }
            catch (DocumentException var2_4) {
                throw new ExceptionConverter(var2_4);
            }
            {
                ** while (true)
            }
        }
    }

    private boolean isNewpage(String string) {
        return "newpage".equals(string);
    }

    private boolean isNewline(String string) {
        return "newline".equals(string);
    }

    protected boolean isDocumentRoot(String string) {
        return "itext".equals(string);
    }
}

