/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException {
        DocumentInputStream in = fs.createDocumentInputStream("Workbook");
        this.processEvents(req, in);
    }

    public short abortableProcessWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException, HSSFUserException {
        DocumentInputStream in = fs.createDocumentInputStream("Workbook");
        return this.abortableProcessEvents(req, in);
    }

    public void processEvents(HSSFRequest req, InputStream in) throws IOException {
        try {
            this.genericProcessEvents(req, in);
        }
        catch (HSSFUserException hSSFUserException) {
            // empty catch block
        }
    }

    public short abortableProcessEvents(HSSFRequest req, InputStream in) throws IOException, HSSFUserException {
        return this.genericProcessEvents(req, in);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected short genericProcessEvents(HSSFRequest req, InputStream in) throws IOException, HSSFUserException {
        short userCode = 0;
        short sid = 0;
        try {
            byte[] sidbytes = new byte[2];
            int bytesread = in.read(sidbytes);
            Record rec = null;
            while (bytesread > 0 && (sid = (short)LittleEndian.getShort(sidbytes)) != 0) {
                byte[] data;
                short size;
                if (rec != null && sid != 60 && (userCode = req.processRecord(rec)) != 0) return userCode;
                if (sid != 60) {
                    Record[] recs;
                    size = LittleEndian.readShort(in);
                    data = new byte[size];
                    if (data.length > 0) {
                        in.read(data);
                    }
                    if ((recs = RecordFactory.createRecord(sid, size, data)).length > 1) {
                        for (int k = 0; k < recs.length - 1; ++k) {
                            userCode = req.processRecord(recs[k]);
                            if (userCode != 0) return userCode;
                        }
                    }
                    rec = recs[recs.length - 1];
                } else {
                    size = LittleEndian.readShort(in);
                    data = new byte[size];
                    if (data.length > 0) {
                        in.read(data);
                    }
                    rec.processContinueRecord(data);
                }
                bytesread = in.read(sidbytes);
            }
            if (rec != null && (userCode = req.processRecord(rec)) == 0) return userCode;
        }
        catch (IOException e) {
            throw new RecordFormatException("Error reading byteswhile processing record sid=" + sid);
        }
        return userCode;
    }
}

