/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.headerfooter;

import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfHeaderFooterGroup
extends HeaderFooter
implements RtfBasicElement {
    private static final int MODE_NONE = 0;
    private static final int MODE_SINGLE = 1;
    private static final int MODE_MULTIPLE = 2;
    private int mode = 0;
    private int type = 1;
    private RtfHeaderFooter headerAll = null;
    private RtfHeaderFooter headerFirst = null;
    private RtfHeaderFooter headerLeft = null;
    private RtfHeaderFooter headerRight = null;
    private RtfDocument document = null;

    public RtfHeaderFooterGroup() {
        super(new Phrase(""), false);
        this.mode = 0;
    }

    public RtfHeaderFooterGroup(RtfDocument rtfDocument, int n) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        this.type = n;
    }

    public RtfHeaderFooterGroup(RtfDocument rtfDocument, RtfHeaderFooterGroup rtfHeaderFooterGroup, int n) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        this.mode = rtfHeaderFooterGroup.getMode();
        this.type = n;
        if (rtfHeaderFooterGroup.getHeaderAll() != null) {
            this.headerAll = new RtfHeaderFooter(this.document, rtfHeaderFooterGroup.getHeaderAll(), 1);
        }
        if (rtfHeaderFooterGroup.getHeaderFirst() != null) {
            this.headerFirst = new RtfHeaderFooter(this.document, rtfHeaderFooterGroup.getHeaderFirst(), 0);
        }
        if (rtfHeaderFooterGroup.getHeaderLeft() != null) {
            this.headerLeft = new RtfHeaderFooter(this.document, rtfHeaderFooterGroup.getHeaderLeft(), 2);
        }
        if (rtfHeaderFooterGroup.getHeaderRight() != null) {
            this.headerRight = new RtfHeaderFooter(this.document, rtfHeaderFooterGroup.getHeaderRight(), 4);
        }
        this.setType(this.type);
    }

    public RtfHeaderFooterGroup(RtfDocument rtfDocument, RtfHeaderFooter rtfHeaderFooter, int n) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        this.type = n;
        this.mode = 1;
        this.headerAll = new RtfHeaderFooter(rtfDocument, rtfHeaderFooter, n);
        this.headerAll.setType(this.type);
    }

    public RtfHeaderFooterGroup(RtfDocument rtfDocument, HeaderFooter headerFooter, int n) {
        super(new Phrase(""), false);
        this.document = rtfDocument;
        this.type = n;
        this.mode = 1;
        this.headerAll = new RtfHeaderFooter(rtfDocument, headerFooter, n, 1);
        this.headerAll.setType(this.type);
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
        if (this.headerAll != null) {
            this.headerAll.setRtfDocument(this.document);
        }
        if (this.headerFirst != null) {
            this.headerFirst.setRtfDocument(this.document);
        }
        if (this.headerLeft != null) {
            this.headerLeft.setRtfDocument(this.document);
        }
        if (this.headerRight != null) {
            this.headerRight.setRtfDocument(this.document);
        }
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.mode == 1) {
                byteArrayOutputStream.write(this.headerAll.write());
            } else if (this.mode == 2) {
                if (this.headerFirst != null) {
                    byteArrayOutputStream.write(this.headerFirst.write());
                }
                if (this.headerLeft != null) {
                    byteArrayOutputStream.write(this.headerLeft.write());
                }
                if (this.headerRight != null) {
                    byteArrayOutputStream.write(this.headerRight.write());
                }
                if (this.headerAll != null) {
                    byteArrayOutputStream.write(this.headerAll.write());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setHeaderFooter(RtfHeaderFooter rtfHeaderFooter, int n) {
        this.mode = 2;
        rtfHeaderFooter.setRtfDocument(this.document);
        rtfHeaderFooter.setType(this.type);
        rtfHeaderFooter.setDisplayAt(n);
        switch (n) {
            case 1: {
                this.headerAll = rtfHeaderFooter;
                break;
            }
            case 0: {
                this.headerFirst = rtfHeaderFooter;
                break;
            }
            case 2: {
                this.headerLeft = rtfHeaderFooter;
                break;
            }
            case 4: {
                this.headerRight = rtfHeaderFooter;
            }
        }
    }

    public void setHeaderFooter(HeaderFooter headerFooter, int n) {
        this.mode = 2;
        switch (n) {
            case 1: {
                this.headerAll = new RtfHeaderFooter(this.document, headerFooter, this.type, n);
                break;
            }
            case 0: {
                this.headerFirst = new RtfHeaderFooter(this.document, headerFooter, this.type, n);
                break;
            }
            case 2: {
                this.headerLeft = new RtfHeaderFooter(this.document, headerFooter, this.type, n);
                break;
            }
            case 4: {
                this.headerRight = new RtfHeaderFooter(this.document, headerFooter, this.type, n);
            }
        }
    }

    public void setHasTitlePage() {
        if (this.mode == 1) {
            this.mode = 2;
            this.headerFirst = new RtfHeaderFooter(this.document, this.headerAll, 0);
            this.headerFirst.setType(this.type);
        }
    }

    public void setHasFacingPages() {
        if (this.mode == 1) {
            this.mode = 2;
            this.headerLeft = new RtfHeaderFooter(this.document, this.headerAll, 2);
            this.headerLeft.setType(this.type);
            this.headerRight = new RtfHeaderFooter(this.document, this.headerAll, 4);
            this.headerRight.setType(this.type);
            this.headerAll = null;
        }
    }

    public boolean hasTitlePage() {
        return this.headerFirst != null;
    }

    public boolean hasFacingPages() {
        return this.headerLeft != null || this.headerRight != null;
    }

    public void setInTable(boolean bl) {
    }

    public void setInHeader(boolean bl) {
    }

    public void setType(int n) {
        this.type = n;
        if (this.headerAll != null) {
            this.headerAll.setType(this.type);
        }
        if (this.headerFirst != null) {
            this.headerFirst.setType(this.type);
        }
        if (this.headerLeft != null) {
            this.headerLeft.setType(this.type);
        }
        if (this.headerRight != null) {
            this.headerRight.setType(this.type);
        }
    }

    protected int getMode() {
        return this.mode;
    }

    protected RtfHeaderFooter getHeaderAll() {
        return this.headerAll;
    }

    protected RtfHeaderFooter getHeaderFirst() {
        return this.headerFirst;
    }

    protected RtfHeaderFooter getHeaderLeft() {
        return this.headerLeft;
    }

    protected RtfHeaderFooter getHeaderRight() {
        return this.headerRight;
    }
}

