/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.Lock;

public abstract class IndexReader {
    private Directory directory;
    private boolean directoryOwner;
    private boolean closeDirectory;
    private SegmentInfos segmentInfos;
    private Lock writeLock;
    private boolean stale;
    private boolean hasChanges;

    protected IndexReader(Directory directory) {
        this.directory = directory;
    }

    IndexReader(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory) {
        this.init(directory, segmentInfos, closeDirectory, true);
    }

    void init(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory, boolean directoryOwner) {
        this.directory = directory;
        this.segmentInfos = segmentInfos;
        this.directoryOwner = directoryOwner;
        this.closeDirectory = closeDirectory;
    }

    public static IndexReader open(String path) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(path, false), true);
    }

    public static IndexReader open(File path) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(path, false), true);
    }

    public static IndexReader open(Directory directory) throws IOException {
        return IndexReader.open(directory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexReader open(final Directory directory, final boolean closeDirectory) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            return (IndexReader)new Lock.With(directory.makeLock("commit.lock"), 10000L){

                public Object doBody() throws IOException {
                    SegmentInfos infos = new SegmentInfos();
                    infos.read(directory);
                    if (infos.size() == 1) {
                        return SegmentReader.get(infos, infos.info(0), closeDirectory);
                    }
                    IndexReader[] readers = new IndexReader[infos.size()];
                    int i = 0;
                    while (i < infos.size()) {
                        readers[i] = SegmentReader.get(infos.info(i));
                        ++i;
                    }
                    return new MultiReader(directory, infos, closeDirectory, readers);
                }
            }.run();
        }
    }

    public Directory directory() {
        return this.directory;
    }

    public static long lastModified(String directory) throws IOException {
        return IndexReader.lastModified(new File(directory));
    }

    public static long lastModified(File directory) throws IOException {
        return FSDirectory.fileModified(directory, "segments");
    }

    public static long lastModified(Directory directory) throws IOException {
        return directory.fileModified("segments");
    }

    public static long getCurrentVersion(String directory) throws IOException {
        return IndexReader.getCurrentVersion(new File(directory));
    }

    public static long getCurrentVersion(File directory) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(directory, false);
        long version = IndexReader.getCurrentVersion(dir);
        ((Directory)dir).close();
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getCurrentVersion(Directory directory) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            Lock commitLock = directory.makeLock("commit.lock");
            boolean locked = false;
            try {
                locked = commitLock.obtain(10000L);
                long l = SegmentInfos.readCurrentVersion(directory);
                Object var4_5 = null;
                if (!locked) return l;
                commitLock.release();
                return l;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (!locked) throw throwable;
                commitLock.release();
                throw throwable;
            }
        }
    }

    public long getVersion() {
        return this.segmentInfos.getVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCurrent() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            Lock commitLock = this.directory.makeLock("commit.lock");
            boolean locked = false;
            try {
                locked = commitLock.obtain(10000L);
                boolean bl = SegmentInfos.readCurrentVersion(this.directory) == this.segmentInfos.getVersion();
                Object var4_5 = null;
                if (!locked) return bl;
                commitLock.release();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (!locked) throw throwable;
                commitLock.release();
                throw throwable;
            }
        }
    }

    public abstract TermFreqVector[] getTermFreqVectors(int var1) throws IOException;

    public abstract TermFreqVector getTermFreqVector(int var1, String var2) throws IOException;

    public static boolean indexExists(String directory) {
        return new File(directory, "segments").exists();
    }

    public static boolean indexExists(File directory) {
        return new File(directory, "segments").exists();
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return directory.fileExists("segments");
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public abstract Document document(int var1) throws IOException;

    public abstract boolean isDeleted(int var1);

    public abstract boolean hasDeletions();

    public boolean hasNorms(String field) throws IOException {
        return this.norms(field) != null;
    }

    public abstract byte[] norms(String var1) throws IOException;

    public abstract void norms(String var1, byte[] var2, int var3) throws IOException;

    public final synchronized void setNorm(int doc, String field, byte value) throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doSetNorm(doc, field, value);
        this.hasChanges = true;
    }

    protected abstract void doSetNorm(int var1, String var2, byte var3) throws IOException;

    public void setNorm(int doc, String field, float value) throws IOException {
        this.setNorm(doc, field, Similarity.encodeNorm(value));
    }

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    private void aquireWriteLock() throws IOException {
        if (this.stale) {
            throw new IOException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
        }
        if (this.writeLock == null) {
            Lock writeLock = this.directory.makeLock("write.lock");
            if (!writeLock.obtain(1000L)) {
                throw new IOException("Index locked for write: " + writeLock);
            }
            this.writeLock = writeLock;
            if (SegmentInfos.readCurrentVersion(this.directory) > this.segmentInfos.getVersion()) {
                this.stale = true;
                this.writeLock.release();
                this.writeLock = null;
                throw new IOException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
        }
    }

    public final synchronized void delete(int docNum) throws IOException {
        this.deleteDocument(docNum);
    }

    public final synchronized void deleteDocument(int docNum) throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doDelete(docNum);
        this.hasChanges = true;
    }

    protected abstract void doDelete(int var1) throws IOException;

    public final int delete(Term term) throws IOException {
        return this.deleteDocuments(term);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int deleteDocuments(Term term) throws IOException {
        TermDocs docs = this.termDocs(term);
        if (docs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (docs.next()) {
                this.deleteDocument(docs.doc());
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            docs.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        docs.close();
        return n;
    }

    public final synchronized void undeleteAll() throws IOException {
        if (this.directoryOwner) {
            this.aquireWriteLock();
        }
        this.doUndeleteAll();
        this.hasChanges = true;
    }

    protected abstract void doUndeleteAll() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void commit() throws IOException {
        if (this.hasChanges) {
            if (this.directoryOwner) {
                Directory directory = this.directory;
                synchronized (directory) {
                    new Lock.With(this.directory.makeLock("commit.lock"), 10000L){

                        public Object doBody() throws IOException {
                            IndexReader.this.doCommit();
                            IndexReader.this.segmentInfos.write(IndexReader.this.directory);
                            return null;
                        }
                    }.run();
                }
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
            } else {
                this.doCommit();
            }
        }
        this.hasChanges = false;
    }

    protected abstract void doCommit() throws IOException;

    public final synchronized void close() throws IOException {
        this.commit();
        this.doClose();
        if (this.closeDirectory) {
            this.directory.close();
        }
    }

    protected abstract void doClose() throws IOException;

    protected void finalize() {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public abstract Collection getFieldNames() throws IOException;

    public abstract Collection getFieldNames(boolean var1) throws IOException;

    public Collection getIndexedFieldNames(boolean storedTermVector) {
        if (storedTermVector) {
            HashSet fieldSet = new HashSet();
            fieldSet.addAll(this.getIndexedFieldNames(Field.TermVector.YES));
            fieldSet.addAll(this.getIndexedFieldNames(Field.TermVector.WITH_POSITIONS));
            fieldSet.addAll(this.getIndexedFieldNames(Field.TermVector.WITH_OFFSETS));
            fieldSet.addAll(this.getIndexedFieldNames(Field.TermVector.WITH_POSITIONS_OFFSETS));
            return fieldSet;
        }
        return this.getIndexedFieldNames(Field.TermVector.NO);
    }

    public abstract Collection getIndexedFieldNames(Field.TermVector var1);

    public abstract Collection getFieldNames(FieldOption var1);

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.makeLock("write.lock").isLocked() || directory.makeLock("commit.lock").isLocked();
    }

    public static boolean isLocked(String directory) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(directory, false);
        boolean result = IndexReader.isLocked(dir);
        ((Directory)dir).close();
        return result;
    }

    public static void unlock(Directory directory) throws IOException {
        directory.makeLock("write.lock").release();
        directory.makeLock("commit.lock").release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String filename = null;
        boolean extract = false;
        int i = 0;
        while (true) {
            if (i >= args.length) {
                if (filename != null) break;
                System.out.println("Usage: org.apache.lucene.index.IndexReader [-extract] <cfsfile>");
                return;
            }
            if (args[i].equals("-extract")) {
                extract = true;
            } else if (filename == null) {
                filename = args[i];
            }
            ++i;
        }
        Directory dir = null;
        CompoundFileReader cfr = null;
        try {
            try {
                File file = new File(filename);
                String dirname = file.getAbsoluteFile().getParent();
                filename = file.getName();
                dir = FSDirectory.getDirectory(dirname, false);
                cfr = new CompoundFileReader(dir, filename);
                Object[] files = cfr.list();
                Arrays.sort(files);
                int i2 = 0;
                while (i2 < files.length) {
                    block19: {
                        long len = cfr.fileLength((String)files[i2]);
                        if (extract) {
                            System.out.println("extract " + (String)files[i2] + " with " + len + " bytes to local directory...");
                            IndexInput ii = cfr.openInput((String)files[i2]);
                            FileOutputStream f = new FileOutputStream((String)files[i2]);
                            byte[] buffer = new byte[1024];
                            int chunk = buffer.length;
                            while (true) {
                                if (len <= 0L) {
                                    f.close();
                                    ii.close();
                                    break block19;
                                }
                                int bufLen = (int)Math.min((long)chunk, len);
                                ii.readBytes(buffer, 0, bufLen);
                                f.write(buffer, 0, bufLen);
                                len -= (long)bufLen;
                            }
                        }
                        System.out.println(String.valueOf(files[i2]) + ": " + len + " bytes");
                    }
                    ++i2;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            try {
                if (dir != null) {
                    dir.close();
                }
                if (cfr == null) throw throwable;
                cfr.close();
                throw throwable;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var16_19 = null;
        }
        try {}
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        if (dir != null) {
            dir.close();
        }
        if (cfr == null) return;
        cfr.close();
    }

    public static final class FieldOption {
        private String option;
        public static final FieldOption ALL = new FieldOption("ALL");
        public static final FieldOption INDEXED = new FieldOption("INDEXED");
        public static final FieldOption UNINDEXED = new FieldOption("UNINDEXED");
        public static final FieldOption INDEXED_WITH_TERMVECTOR = new FieldOption("INDEXED_WITH_TERMVECTOR");
        public static final FieldOption INDEXED_NO_TERMVECTOR = new FieldOption("INDEXED_NO_TERMVECTOR");
        public static final FieldOption TERMVECTOR = new FieldOption("TERMVECTOR");
        public static final FieldOption TERMVECTOR_WITH_POSITION = new FieldOption("TERMVECTOR_WITH_POSITION");
        public static final FieldOption TERMVECTOR_WITH_OFFSET = new FieldOption("TERMVECTOR_WITH_OFFSET");
        public static final FieldOption TERMVECTOR_WITH_POSITION_OFFSET = new FieldOption("TERMVECTOR_WITH_POSITION_OFFSET");

        private FieldOption() {
        }

        private FieldOption(String option) {
            this.option = option;
        }

        public String toString() {
            return this.option;
        }
    }
}

