/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class DERGeneralizedTime
extends DERObject {
    String time;

    public static DERGeneralizedTime getInstance(Object object) {
        if (object == null || object instanceof DERGeneralizedTime) {
            return (DERGeneralizedTime)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERGeneralizedTime(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERGeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERGeneralizedTime.getInstance(aSN1TaggedObject.getObject());
    }

    public DERGeneralizedTime(String string) {
        this.time = string;
    }

    public DERGeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = simpleDateFormat.format(date);
    }

    DERGeneralizedTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n != cArray.length) {
            cArray[n] = (char)(byArray[n] & 0xFF);
            ++n;
        }
        this.time = new String(cArray);
    }

    public String getTime() {
        if (this.time.charAt(this.time.length() - 1) == 'Z') {
            return String.valueOf(this.time.substring(0, this.time.length() - 1)) + "GMT+00:00";
        }
        int n = this.time.length() - 5;
        char c = this.time.charAt(n);
        if (c == '-' || c == '+') {
            return String.valueOf(this.time.substring(0, n)) + "GMT" + this.time.substring(n, n + 3) + ":" + this.time.substring(n + 3);
        }
        n = this.time.length() - 3;
        c = this.time.charAt(n);
        if (c == '-' || c == '+') {
            return String.valueOf(this.time.substring(0, n)) + "GMT" + this.time.substring(n) + ":00";
        }
        return this.time;
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat.parse(this.time);
    }

    private byte[] getOctets() {
        char[] cArray = this.time.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n != cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(24, this.getOctets());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERGeneralizedTime)) {
            return false;
        }
        return this.time.equals(((DERGeneralizedTime)object).time);
    }
}

