/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERString;
import java.io.IOException;

public class DERPrintableString
extends DERObject
implements DERString {
    String string;

    public static DERPrintableString getInstance(Object object) {
        if (object == null || object instanceof DERPrintableString) {
            return (DERPrintableString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERPrintableString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERPrintableString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERPrintableString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERPrintableString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERPrintableString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n != cArray.length) {
            cArray[n] = (char)(byArray[n] & 0xFF);
            ++n;
        }
        this.string = new String(cArray);
    }

    public DERPrintableString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n != cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(19, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERPrintableString)) {
            return false;
        }
        DERPrintableString dERPrintableString = (DERPrintableString)object;
        return this.getString().equals(dERPrintableString.getString());
    }
}

