/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;

public abstract class Lock {
    public static long LOCK_POLL_INTERVAL = 1000L;

    public abstract boolean obtain() throws IOException;

    public boolean obtain(long lockWaitTimeout) throws IOException {
        boolean locked = this.obtain();
        int maxSleepCount = (int)(lockWaitTimeout / LOCK_POLL_INTERVAL);
        int sleepCount = 0;
        while (!locked) {
            if (sleepCount++ == maxSleepCount) {
                throw new IOException("Lock obtain timed out: " + this.toString());
            }
            try {
                Thread.sleep(LOCK_POLL_INTERVAL);
            }
            catch (InterruptedException e) {
                throw new IOException(e.toString());
            }
            locked = this.obtain();
        }
        return locked;
    }

    public abstract void release();

    public abstract boolean isLocked();

    public static abstract class With {
        private Lock lock;
        private long lockWaitTimeout;

        public With(Lock lock) {
            this(lock, 10000L);
        }

        public With(Lock lock, long lockWaitTimeout) {
            this.lock = lock;
            this.lockWaitTimeout = lockWaitTimeout;
        }

        protected abstract Object doBody() throws IOException;

        public Object run() throws IOException {
            boolean locked = false;
            try {
                locked = this.lock.obtain(this.lockWaitTimeout);
                Object object = this.doBody();
                Object var2_3 = null;
                if (locked) {
                    this.lock.release();
                }
                return object;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var2_4 = null;
                    if (!locked) break block3;
                    this.lock.release();
                }
                throw throwable;
            }
        }
    }
}

