/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.jar.JarFile;
import php.java.bridge.classloader.DynamicJarURLConnection;
import php.java.bridge.util.Logger;

class DynamicHttpURLConnectionHandler
extends URLStreamHandler {
    private JarFile jarFile;
    private File baseFile;
    private Map headerFields;

    public DynamicHttpURLConnectionHandler() {
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("tempfile create DynamicHttpURLConnectionHander " + this);
        }
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new DynamicJarURLConnection(u, this);
    }

    public void deleteTempFile() {
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("classloader tempfile deleted: " + this.baseFile + " handler: " + this);
        }
        this.baseFile.delete();
    }

    public Map getHeaderFields() {
        return this.headerFields;
    }

    public JarFile getTempFile() {
        return this.jarFile;
    }

    public void setTempFile(JarFile jarFile, File baseFile) {
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("classloader tempfile created: " + baseFile + " handler" + this);
        }
        this.jarFile = jarFile;
        this.baseFile = baseFile;
    }

    public void setHeaderFields(Map headerFields) {
        this.headerFields = headerFields;
    }
}

