<?php
    /*
    *  $Id: CoverageRecorder.php 14665 2005-03-23 19:37:50Z npac $
    *  
    *  Copyright(c) 2004-2005, SpikeSource Inc. All Rights Reserved.
    *  Licensed under the Open Source License version 2.1
    *  (See http://www.spikesource.com/license.html)
    */
?>
<?php

    if(!defined("__PHPCOVERAGE_HOME")) {
        define("__PHPCOVERAGE_HOME", dirname(__FILE__));
    }
    require_once __PHPCOVERAGE_HOME . "/reporter/CoverageReporter.php";

    /**
    *
    * The Coverage Recorder utility
    *
    * This is the main class for the CoverageRecorder. User should 
    * instantiate this class and set various parameters of it.
    * The startInstrumentation and stopInstrumentation methods will
    * switch code coverage recording on and off respectively. 
    *
    * The code coverage is recorded using XDebug Zend Extension. Therefore,
    * it is required to install that extension on the system where
    * code coverage measurement is going to take place. See
    * {@link http://www.xdebug.org www.xdebug.org} for more
    * information.
    *
    * @author		Nimish Pachapurkar <npac@spikesource.com>
    * @version		$Revision: 14665 $
    */
    class CoverageRecorder {

        // {{{ Members

        protected $includePaths;
        protected $excludePaths;
        protected $reporter;
        protected $coverageData;
        protected $isRemote = false;
        protected $stripped = false;
        protected $phpCoverageFiles = array("phpcoverage.inc.php");
        protected $version;

        /** 
        * What extensions are treated as php files. 
        * 
        * @param "php" Array of extension strings
        */
        protected $phpExtensions = array("php", "tpl");

        // }}}
        // {{{ Constructor

        /** 
        * Constructor (PHP5 only) 
        * 
        * @param $includePaths Directories to be included in code coverage report
        * @param $excludePaths Directories to be excluded from code coverage report
        * @param $reporter Instance of a Reporter subclass
        * @access public
        */
        public function __construct($includePaths=array("."), $excludePaths=array(), $reporter="new HtmlCoverageReporter()") {
            $this->includePaths = $includePaths;
            $this->excludePaths = $excludePaths;
            $this->reporter = $reporter;
            // Set back reference
            $this->reporter->setCoverageRecorder($this);
            $this->excludeCoverageDir();
            $this->version = "0.6.4";
        }

        // }}}
        // {{{ public function startInstrumentation()

        /** 
        * Starts the code coverage recording 
        * 
        * @access public
        */
        public function startInstrumentation() {
            if(extension_loaded("xdebug")) {
                xdebug_start_code_coverage();
                return true;
            }
            error_log("[CoverageRecorder::startInstrumentation()] " 
            . "ERROR: Xdebug not loaded.");
            return false;
        }

        // }}}
        // {{{ public function stopInstrumentation()

        /** 
        * Stops code coverage recording 
        * 
        * @access public
        */
        public function stopInstrumentation() {
            if(extension_loaded("xdebug")) {
                $this->coverageData = xdebug_get_code_coverage();
                xdebug_stop_code_coverage();
                // error_log("Code coverage: " . print_r($this->coverageData, true));
                return true;
            }
            return false;
        }

        // }}}
        // {{{ public function generateReport()

        /** 
        * Generate the code coverage report 
        * 
        * @access public
        */
        public function generateReport() {
            if($this->isRemote) {
                error_log("[CoverageRecorder::generateReport()] "
                ."Writing report.");
            }
            else {
                echo "\n[CoverageRecorder::generateReport()] "
                . "Writing report:\t\t";
            }
            // print_r($this->coverageData);
            $this->unixifyCoverageData();
            $this->coverageData = $this->stripCoverageData();
            $this->reporter->generateReport($this->coverageData);
            if($this->isRemote) {
                error_log("[CoverageRecorder::generateReport()] [done]");
            }
            else {
                echo "[done]\n";
            }
        }

        // }}}
        /*{{{ protected function removeAbsentPaths() */

        /** 
        * Remove the directories that do not exist from the input array 
        * 
        * @param &$dirs Array of directory names
        * @access protected
        */
        protected function removeAbsentPaths(&$dirs) {
            for($i = 0; $i < count($dirs); $i++) {
                if(! file_exists($dirs[$i])) {
                    // echo "Not found: " . $dirs[$i] . "\n";
                    $this->errors[] = "Not found: " . $dirs[$i] 
                    . ". Removing ...";
                    array_splice($dirs, $i, 1);
                    $i--;
                }
                else {
                    $dirs[$i] = realpath($dirs[$i]);
                }
            }
        }

        /*}}}*/
        // {{{ protected function processSourcePaths()

        /** 
        * Processes and validates the source directories 
        * 
        * @access protected
        */
        protected function processSourcePaths() {
            $this->removeAbsentPaths($this->includePaths);
            $this->removeAbsentPaths($this->excludePaths);

            sort($this->includePaths, SORT_STRING);
        }

        // }}}
        /*{{{ protected function getFilesAndDirs() */

        /** 
        * Get the list of files that match the extensions in $this->phpExtensions 
        * 
        * @param $dir Root directory
        * @param &$files Array of filenames to append to
        * @access protected
        */
        protected function getFilesAndDirs($dir, &$files) {
            global $util;
            $dirs[] = $dir;
            while(count($dirs) > 0) {
                $currDir = realpath(array_pop($dirs));
                if(!is_readable($currDir)) {
                    continue;
                }
                //echo "Current Dir: $currDir \n";
                $currFiles = scandir($currDir);
                //print_r($currFiles);
                for($j = 0; $j < count($currFiles); $j++) {
                    if($currFiles[$j] == "." || $currFiles[$j] == "..") {
                        continue;
                    }
                    $currFiles[$j] = $currDir . "/" . $currFiles[$j];
                    //echo "Current File: " . $currFiles[$j] . "\n";
                    if(is_file($currFiles[$j])) {
                        $pathParts = pathinfo($currFiles[$j]);
                        if(in_array($pathParts['extension'], $this->phpExtensions)) {
                            $files[] = $util->replaceBackslashes($currFiles[$j]);
                        }
                    }
                    if(is_dir($currFiles[$j])) {
                        $dirs[] = $currFiles[$j];
                    }
                }
            }
        }

        /*}}}*/
        /*{{{ protected function addFiles() */

        /** 
        * Add all source files to the list of files that need to be parsed. 
        * 
        * @access protected
        */
        protected function addFiles() {
            $files = array();
            for($i = 0; $i < count($this->includePaths); $i++) {
                if(is_dir($this->includePaths[$i])) {
                    //echo "Calling getFilesAndDirs with " . $this->includePaths[$i] . "\n";
                    $this->getFilesAndDirs($this->includePaths[$i], $files);
                }
                else if(is_file($this->includePaths[$i])) {
                    $files[] = $this->includePaths[$i];
                }
            }

            //echo "Found files:";
            //print_r($files);
            for($i = 0; $i < count($files); $i++) {
                for($j = 0; $j < count($this->excludePaths); $j++) {
                    //echo $files[$i] . "\t" . $this->excludePaths[$j] . "\n";
                    if(strpos($files[$i], $this->excludePaths[$j]) === 0) {
                        continue;
                    }
                }
                if(!array_key_exists($files[$i], $this->coverageData)) {
                    $this->coverageData[$files[$i]] =  array();
                }
            }
        }

        /*}}}*/
        // {{{ protected function stripCoverageData()

        /** 
        * Removes the unwanted coverage data from the recordings 
        * 
        * @return Processed coverage data
        * @access protected
        */
        protected function stripCoverageData() {
            if($this->stripped) {
                error_log("[CoverageRecorder::stripCoverageData()] Already stripped!");
                return $this->coverageData;
            }
            $this->stripped = true;
            if(empty($this->coverageData)) {
                error_log("[CoverageRecorder::stripCoverageData()] No coverage data found.");
                return $this->coverageData;
            }
            $this->processSourcePaths();
            //echo "!!!!!!!!!!!!! Source Paths !!!!!!!!!!!!!! \n";
            //print_r($this->includePaths);
            //print_r($this->excludePaths);
            //echo "!!!!!!!!!!!!! Source Paths !!!!!!!!!!!!!! \n";
            $this->addFiles();
            $altCoverageData = array();
            foreach ($this->coverageData as $filename => $lines) {
                $preserve = false;
                $realFile = realpath($filename);
                for($i = 0; $i < count($this->includePaths); $i++) {
                    if(strpos($realFile, $this->includePaths[$i]) === 0) {
                        $preserve = true;
                    }
                }
                // Exclude dirs have a precedence over includes.
                for($i = 0; $i < count($this->excludePaths); $i++) {
                    if(strpos($realFile, $this->excludePaths[$i]) === 0) {
                        $preserve = false;
                    }
                    else if(in_array(basename($realFile), $this->phpCoverageFiles)) {
                        $preserve = false;
                    }
                }
                if($preserve) {
                    // Should be preserved
                    $altCoverageData[$filename] = $lines;
                }
            }

            array_multisort($altCoverageData, SORT_STRING);
            return $altCoverageData;
        }

        // }}}
        /*{{{ protected function unixifyCoverageData() */

        /** 
        * Convert filepaths in coverage data to forward slash separated
        * paths.
        * 
        * @access protected
        */
        protected function unixifyCoverageData() {
            global $util;
            $tmpCoverageData = array();
            foreach($this->coverageData as $file => $lines) {
                $tmpCoverageData[$util->replaceBackslashes($file)] = $lines;
            }
            $this->coverageData = $tmpCoverageData;
        }

        /*}}}*/
        // {{{ public function getErrors()

        /** 
        * Returns the errors array containing all error encountered so far. 
        * 
        * @return Array of error messages
        * @access public
        */
        public function getErrors() {
            return $this->errors;
        }

        // }}}
        // {{{ public function logErrors()

        /** 
        * Writes all error messages to error log 
        * 
        * @access public
        */
        public function logErrors() {
            error_log(print_r($this->errors, true));
        }

        // }}}
        /*{{{ Getters and Setters */

        public function getIncludePaths() {
            return $this->includePaths;
        }

        public function setIncludePaths($includePaths) {
            $this->includePaths = $includePaths;
        }

        public function getExcludePaths() {
            return $this->excludePaths;
        }

        public function setExcludePaths($excludePaths) {
            $this->excludePaths = $excludePaths;
            $this->excludeCoverageDir();
        }

        public function getReporter() {
            return $this->reporter;
        }

        public function setReporter(&$reporter) {
            $this->reporter = $reporter;
        }

        public function getPhpExtensions() {
            return $this->phpExtensions;
        }

        public function setPhpExtensions(&$extensions) {
            $this->phpExtensions = $extensions;
        }

        public function getVersion() {
            return $this->version;
        }

        /*}}}*/
        /*{{{ public function excludeCoverageDir() */

        /** 
        * Exclude the directory containing the coverage measurement code. 
        *
        * @access public
        */
        public function excludeCoverageDir() {
            $f = __FILE__;
            if(is_link($f)) {
                $f = readlink($f);
            }
            $this->excludePaths[] = realpath(dirname($f));
        }
        /*}}}*/
    }
?>
