<?php
/*
 *  $Id: license.txt 13981 2005-03-16 08:09:28Z eespino $
 *  
 *  Copyright(c) 2004-2005, SpikeSource Inc. All Rights Reserved.
 *  Licensed under the Open Source License version 2.1
 *  (See http://www.spikesource.com/license.html)
 */
?>
<?php
    /**
     * This driver file can be used to initialize and generate PHPCoverage 
     * report when PHPCoverage is used with a non-PHP test tool - like HttpUnit
     * This file should be hand-edited to change the exclude and include path
     * arrays. By default, only the application base path is included for code
     * coverage measurement. The exclude path array is empty.
     * 
     * Notes:
     *  * Option parsing courtesy of "daevid at daevid dot com" (http://php.planetmirror.com/manual/en/function.getopt.php)
     *  * Contributed by Ed Espino <eespino@spikesource.com>
    */

    // ######################################################################
    // ######################################################################

    function usage() {
        echo "Usage: " . $_SERVER['argv'][0] . " <options>\n";
        echo "\n";
        echo "    Options: \n";
        echo "       -p <path>                   Path to PHPCoverage home\n";
        echo "       --init                      Initialize PHPCoverage Reporting\n";
        echo "       --report                    Generate PHPCoverage Reports\n";
        echo "       --cleanup                   Remove existing PHPCoverage data\n";
        echo "       --cov-url <url>             Specify application default url\n";
        echo "       --tmp-dir <path>            Specify tmp directory location (Defaults to '/tmp')\n";
        echo "       --cov-file-name <name>      Specify coverage data file name (Defaults to 'phpcoverage.data.xml')\n";
        echo "       --report-name <name>        Report name\n";
        echo "       --report-dir <path>         Report directory path (Defaults to 'report')\n";
        echo "       --verbose                   Print verbose information\n";
        echo "       --help                      Display this usage information\n";
        exit;
    }

    //
    // Setup command line argument processing
    //

    $OPTION["p"] = false;
    $OPTION['verbose'] = false;
    $OPTION['init'] = false;
    $OPTION['report'] = false;
    $OPTION['cleanup'] = false;
    $OPTION['cov-url'] = false;
    $OPTION['report-name'] = false;
    $OPTION['report-dir'] = false;
    $OPTION['tmp-dir'] = false;
    $OPTION['cov-file-name'] = false;

    //
    // loop through our arguments and see what the user selected
    //

    for ($i = 1; $i < $_SERVER["argc"]; $i++) {
        switch($_SERVER["argv"][$i]) {
        case "-p":
            $OPTION['p'] = $_SERVER['argv'][++$i];
            break;
        case "--verbose":
            $OPTION['verbose'] = true;
            break;
        case "--init":
            $OPTION['init'] = true;
            break;
        case "--report":
            $OPTION['report'] = true;
            break;
        case "--cleanup":
            $OPTION['cleanup'] = true;
            break;
        case "--cov-url":
            $OPTION['cov-url'] = $_SERVER['argv'][++$i] . "/" . "phpcoverage.remote.top.inc.php";
            break; 
        case "--tmp-dir":
            $OPTION['tmp-dir'] = $_SERVER['argv'][++$i];
            break;
        case "--cov-file-name":
            $OPTION['cov-file-name'] = $_SERVER['argv'][++$i];
            break;
        case "--report-name":
            $OPTION['report-name'] = $_SERVER['argv'][++$i];
            break; 
        case "--report-dir":
            $OPTION['report-dir'] = $_SERVER['argv'][++$i];
            break; 
        case "--help":
            usage();
            break; 
        }
    }

    if($OPTION['p'] == false) {
        $OPTION['p'] = $_ENV["PHPCOVERAGE_HOME"];
    }
    if(empty($OPTION['p'])) {
        echo "ERROR: Cannot find PHPCOVERAGE_HOME path.\n";
        exit(1);
    }

    if (!$OPTION['cov-url']){
        echo "ERROR: No --cov-url option specified.\n";
        exit(1);
    }

    if (!$OPTION['report-name']){
        echo "ERROR: No --report-name option specified.\n";
        exit(1);
    }

    if(!$OPTION['report-dir']) {
        $OPTION["report-dir"] = "report";
    }
    if(!$OPTION['tmp-dir']) {
        $OPTION['tmp-dir'] = "/tmp";
    }
    if(!$OPTION['cov-file-name']) {
        $OPTION['cov-file-name'] = "phpcoverage.data.xml";
    }

    if ($OPTION['verbose']){
        print_r($OPTION);
    }

    //
    //
    //

    require_once $OPTION['p'] . "/phpcoverage.inc.php";
    require_once PHPCOVERAGE_HOME . "/remote/RemoteCoverageRecorder.php";
    require_once PHPCOVERAGE_HOME . "/reporter/HtmlCoverageReporter.php";

    if ($OPTION['init']){
        echo "PHPCoverage: report " . $OPTION['cov-url'] . "?phpcoverage-action=init&cov-file-name=". urlencode($OPTION["cov-file-name"]) . "&tmp-dir=" . urlencode($OPTION['tmp-dir']);

        //
        // Initialize the PHPCoverage reporting framework
        //

        file_get_contents($OPTION['cov-url'] . "?phpcoverage-action=init&cov-file-name=". urlencode("phpcoverage.data.xml") . "&tmp-dir=" . urlencode("/tmp"));

    } 
    else if ($OPTION['report']){

        echo "PHPCoverage: report " . $OPTION['cov-url'] . "?phpcoverage-action=get-coverage-xml";

        //
        // Retrieve coverage data (xml) from the PHPCoverage reporting framework
        //

        $xml = file_get_contents($OPTION['cov-url'] . "?phpcoverage-action=get-coverage-xml");

        //
        // Configure reporter, and generate the PHPCoverage report
        //

        $covReporter = new HtmlCoverageReporter($OPTION['report-name'], "", $OPTION["report-dir"]);
        $excludePaths = array(); 

        //
        // Set the include path for the web-app
        // PHPCOVERAGE_APPBASE_PATH is passed on the commandline
        //

        $includePaths = array(realpath($PHPCOVERAGE_APPBASE_PATH));

        //
        // Notice the coverage recorder is of type RemoteCoverageRecorder
        //

        $cov = new RemoteCoverageRecorder($includePaths, $excludePaths, $covReporter);
        $cov->generateReport($xml);
        $covReporter->printTextSummary($OPTION["report-dir"] . "/report.txt");

    } 
    else if ($OPTION['cleanup']){

        echo "PHPCoverage: cleanup " . $OPTION['cov-url'] . "?phpcoverage-action=cleanup";
        file_get_contents($OPTION['cov-url'] . "?phpcoverage-action=cleanup");

    }

?>

