<?php
    /*
    *  $Id: RemoteCoverageRecorder.php 14665 2005-03-23 19:37:50Z npac $
    *  
    *  Copyright(c) 2004-2005, SpikeSource Inc. All Rights Reserved.
    *  Licensed under the Open Source License version 2.1
    *  (See http://www.spikesource.com/license.html)
    */
?>
<?php

    require_once dirname(dirname(__FILE__)) . "/CoverageRecorder.php";
    require_once __PHPCOVERAGE_HOME . "/remote/XdebugTraceReader.php";
    require_once __PHPCOVERAGE_HOME . "/parser/CoverageXmlParser.php";

    /** 
    * A Coverage recorder extension for remote Coverage measurement. 
    * 
    * @author Nimish Pachapurkar <npac@spikesource.com>
    * @version $Revision: $
    * @package SpikePHPCoverage_Remote
    */
    class RemoteCoverageRecorder extends CoverageRecorder {
        /*{{{ Members */

        protected $traceFilePath;
        protected $xdebugTraceReader;
        protected $tmpDir = "/tmp";
        protected $tmpTraceFilename = "phpcoverage.xdebug.trace";
        protected $coverageFileName = "phpcoverage.coverage.xml";

        protected $xmlStart = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><spike-phpcoverage>";
        protected $xmlEnd = "</spike-phpcoverage>";

        /*}}}*/
        /*{{{ public function __construct() */

        /** 
        * Constructor 
        * 
        * @access public
        */
        public function __construct($includePaths=array("."), $excludePaths=array(), $reporter="new HtmlCoverageReporter()") {
            parent::__construct($includePaths, $excludePaths, $reporter);
            $this->isRemote = true;
            $this->phpCoverageFiles[] = "phpcoverage.remote.inc.php";
            $this->phpCoverageFiles[] = "phpcoverage.remote.top.inc.php";
            $this->phpCoverageFiles[] = "phpcoverage.remote.bottom.inc.php";
        }

        /*}}}*/
        /*{{{ Getters and Setters */

        public function getTraceFilePath() {
            return $this->traceFilePath;
        }

        public function setTraceFilePath($traceFilePath) {
            $this->traceFilePath = $traceFilePath;
        }

        public function getTmpDir() {
            return $this->tmpDir;
        }

        public function setTmpDir($tmpTraceDir) {
            $this->tmpDir = $tmpTraceDir;
        }

        public function getCoverageFileName() {
            return $this->coverageFileName;
        }

        public function setCoverageFileName($covFileName) {
            $this->coverageFileName = $covFileName;
        }

        /*}}}*/
        /*{{{ public function cleanCoverageFile() */

        /** 
        * Deletes a coverage data file if one exists. 
        * 
        * @return Boolean True on success, False on failure.
        * @access public
        */
        public function cleanCoverageFile() {
            $filepath = $this->tmpDir . "/" . $this->coverageFileName;
            if(file_exists($filepath)) {
                if(is_writable($filepath)) {
                    unlink($filepath);
                }
                else {
                    error_log("[RemoteCoverageRecorder::cleanCoverageFile()] "
                    . "ERROR: Cannot delete $filepath.");
                    return false;
                }
            }
            return true;
        }

        /*}}}*/
        /*{{{ protected function prepareCoverageXml() */

        /** 
        * Convert the Coverage data into an XML. 
        * 
        * @return String XML generated from Coverage data
        * @access protected
        */
        protected function prepareCoverageXml() {
            $xmlString = "";
            $xmlBody = "";
            if(!empty($this->coverageData)) {
                foreach($this->coverageData as $file => $lines) {
                    $xmlBody .= "<file path=\"". $file . "\">";
                    foreach($lines as $linenum => $frequency) {
                        $xmlBody .= "<line line-number=\"" . $linenum . "\"";
                        $xmlBody .= " frequency=\"" . $frequency . "\"/>";
                    }
                    $xmlBody .= "</file>";
                }
            }
            else {
                error_log("[RemoteCoverageRecorder::prepareCoverageXml()] Coverage data is empty.");
            }
            $xmlString .= $xmlBody;
            // error_log("[RemoteCoverageRecorder::prepareCoverageXml()] Xml: " . $xmlString);
            return $xmlString;
        }

        /*}}}*/
        /*{{{ protected function parseCoverageXml() */

        /** 
        * Parse coverage XML to regenerate the Coverage data array. 
        * 
        * @param $xml XML String of the coverage data
        * @access protected
        */
        protected function parseCoverageXml($xml) {
            $xmlParser = new CoverageXmlParser();
            $xmlParser->setInputString($xml);
            $xmlParser->parse();
            $this->coverageData = $xmlParser->getCoverageData();
        }

        /*}}}*/
        /*{{{ public function getCoverageXml() */

        /** 
        * Returns the coverage data in XML form 
        * 
        * @return String Coverage XML
        * @access public
        */
        public function getCoverageXml() {
            $filepath = $this->tmpDir . "/" . $this->coverageFileName;
            if(file_exists($filepath) && is_readable($filepath)) {
                return file_get_contents($filepath);
            }
            else {
                error_log("[RemoteCoverageRecorder::getCoverageXml()] " 
                . "ERROR: Cannot read file " . $filepath);
            }
            return false;
        }

        /*}}}*/
        /*{{{ public function saveCoverageXml() */

        /** 
         * Append coverage xml to a xml data file. 
         * 
         * @return Boolean True on success, False on error
         * @access public
         */
        public function saveCoverageXml() {
            $filepath = $this->tmpDir . "/" . $this->coverageFileName;
            if($this->stopInstrumentation()) {
                $xml = $this->prepareCoverageXml();
                $existing_xml = $this->getCoverageXml();
                if(!empty($existing_xml)) {
                    $pos = strpos($existing_xml, $this->xmlEnd);
                    if($pos !== false) {
                        $existing_xml = substr($existing_xml, 0, $pos);
                    }
                }
                else {
                    $existing_xml = $this->xmlStart;
                }
                $xml = $existing_xml . $xml . $this->xmlEnd;
                // error_log("[RemoteCoverageRecorder::saveCoverageXml()] Saving xml: " . $xml);
                $bytes = file_put_contents($filepath, $xml);
                if(!$bytes) {
                    error_log("[RemoteCoverageRecorder::saveCoverageXml()] "
                    . "ERROR: Nothing was written to " . $filepath);
                    return false;
                }
                error_log("[RemoteCoverageRecorder::saveCoverageXml()] "
                . "Saved XML to $filepath; size: [" . filesize($filepath) 
                . "]");
                return true;
            }
            return false;
        }

        /*}}}*/
        /*{{{ public function generateReport() */

        /** 
        * Generate report from the xml coverage data 
        * 
        * @param $xml XML String of coverage data
        * @access public
        */
        public function generateReport($xml) {
            // error_log("Coverage Data XML final: " . $xml);
            $this->parseCoverageXml($xml);
            // error_log("Coverage Data final: " . print_r($this->coverageData, true));
            parent::generateReport();
        }

        /*}}}*/
    }
?>
