<?php
/**
* CHM (Compiled Help Manual) output converter for Smarty Template.
* This Converter takes output from the {@link Parser} and converts it to HTML-ready output for use with {@link Smarty}.
*
* @package Converters
* @subpackage CHMdefault
* @see parserDocBlock, parserInclude, parserPage, parserClass, parserDefine, parserFunction, parserMethod, parserVar
* @author Greg Beaver <cellog@users.sourceforge.net>
* @since 1.0rc1
* @version $Id: CHMdefaultConverter.inc,v 1.2.2.2 2002/10/31 16:47:03 CelloG Exp $
*/
/**
* Smarty template files
*/
require_once("Smarty.class.php");
/**
* CHM output converter.
* This Converter takes output from the {@link Parser} and converts it to HTML-ready output for use with {@link Smarty}.
*
* @package Converters
* @subpackage CHMdefault
* @see parserDocBlock, parserInclude, parserPage, parserClass, parserDefine, parserFunction, parserMethod, parserVar
* @author Greg Beaver <cellog@users.sourceforge.net>
* @since 1.0rc1
* @version $Id: CHMdefaultConverter.inc,v 1.2.2.2 2002/10/31 16:47:03 CelloG Exp $
*/
class CHMdefaultConverter extends Converter
{
	/**
	* Smarty Converter wants elements sorted by type as well as alphabetically
	* @see Converter::$sort_page_contents_by_type
	* @var boolean
	*/
	var $sort_page_contents_by_type = true;
	/** @var string */
	var $outputformat = 'CHM';
	/** @var string */
	var $name = 'default';
	/**
	* indexes of elements by package that need to be generated
	* @var array
	*/
	var $leftindex = array('classes' => true, 'pages' => true, 'functions' => false, 'defines' => false, 'globals' => false);
	/**
	* whether a @see is going to be in the {@link $base_dir}, or in a package/subpackage subdirectory of $base_dir
	* @var boolean
	*/
	var $local = true;
	
	/**
	* name of current page being converted
	* @var string
	*/
	var $page;
	
	/**
	* path of current page being converted
	* @var string
	*/
	var $path;
	
	/**
	* name of current class being converted
	* @var string
	*/
	var $class;
	
	/**
	* template for the procedural page currently being processed
	* @var Template
	*/
	var $page_data;
	
	/**
	* output directory for the current procedural page being processed
	* @var string
	*/
	var $page_dir;
	
	/**
	* target directory passed on the command-line.
	* {@link $targetDir} is malleable, always adding package/ and package/subpackage/ subdirectories onto it.
	* @var string
	*/
	var $base_dir;
	
	/**
	* output directory for the current class being processed
	* @var string
	*/
	var $class_dir;
	
	/**
	* template for the class currently being processed
	* @var Template
	*/
	var $class_data;
	
	/**
	* array of converted package page names.
	* Used to link to the package page in the left index
	* @var array Format: array(package => 1)
	*/
	var $package_pages = array();
	
	/**
	* controls formatting of parser informative output
	* 
	* Converter prints:
	* "Converting /path/to/file.php... Procedural Page Elements... Classes..."
	* Since HTMLdefaultConverter outputs files while converting, it needs to send a \n to start a new line.  However, if there
	* is more than one class, output is messy, with multiple \n's just between class file output.  This variable prevents that
	* and is purely cosmetic
	* @var boolean
	*/
	var $juststarted = false;
	
	/**
	* contains all of the template procedural page element loop data needed for the current template
	* @var array
	*/
	var $current;
	
	/**
	* contains all of the template class element loop data needed for the current template
	* @var array
	*/
	var $currentclass;
	/**
	* sets {@link $base_dir} to $targetDir
	* @see Converter()
	*/
	
	var $hhp_files = array();
	function CHMdefaultConverter(&$allp, &$packp, &$classes, &$procpages, $po, $pp, $qm, $targetDir, $templateDir, $title)
	{
		Converter::Converter($allp, $packp, $classes, $procpages,$po, $pp, $qm, $targetDir, $templateDir, $title);
		$this->base_dir = $targetDir;
	}
	
	function &newSmarty()
	{
		$this->makeLeft();
		$templ = new Smarty;
		$templ->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
		$templ->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
		$templ->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
		$templ->assign("packageindex",$this->package_index);
		$templ->assign("phpdocversion",PHPDOC_VER);
		$templ->assign("phpdocwebsite",PHPDOC_WEBSITE);
		$templ->assign("package",$this->package);
		$templ->assign("subdir",'');
		return $templ;
	}
	
	/**
	* Writes out the template file of {@link $class_data} and unsets the template to save memory
	* @see registerCurrentClass()
	* @see parent::endClass()
	*/
	function endClass()
	{
		$a = '../';
		if (!empty($this->subpackage)) $a .= '../';
		if ($this->juststarted)
		{
			$this->juststarted = false;
			phpdoc_out("\n");
		}
		$this->setTargetDir($this->base_dir . PATH_DELIMITER . $this->class_dir);
		$this->class_data->assign("phpdocversion",PHPDOC_VER);
		$this->class_data->assign("phpdocwebsite",PHPDOC_WEBSITE);
		$this->class_data->assign("compiledclassindex",$this->getClassLeft());
		$this->class_data->assign("compiledfileindex",$this->getPageLeft());
		$this->class_data->assign("classcontents",$this->getClassContents());
		$this->class_data->assign("packageindex",$this->package_index);
		$this->class_data->assign("package",$this->package);
		$this->class_data->assign("subdir",$a);
		$this->addTOC($this->class,$this->class,$this->package,$this->subpackage, true);
		$this->writefile($this->class . '.html',$this->class_data->fetch('class.tpl'));
		unset($this->class_data);
	}
	
	function getClassLeft()
	{
		static $cache = false;
		if ($cache)
		{
			if (isset($cache[$this->package][$this->subpackage])) return $cache[$this->package][$this->subpackage];
		}
		$arr = array();
		if (isset($this->left['#class'][$this->package]))
		foreach($this->left['#class'][$this->package] as $subpackage => $pages)
		{
			$arr[$subpackage] = $pages;
		}
		$templ = new Smarty;
		$templ->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
		$templ->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
		$templ->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
		$templ->assign('classleftindex',$arr);
		$arr = $templ->fetch('classleft.tpl');
		$cache[$this->package][$this->subpackage] = $arr;
		return $arr;
	}
	
	function getClassContents()
	{
		static $cache = false;
		if ($cache)
		{
			if (isset($cache[$this->package][$this->subpackage][$this->class])) return $cache[$this->package][$this->subpackage][$this->class];
		}
		$arr = array();
		foreach($this->class_contents[$this->package][$this->subpackage][$this->class] as $i => $link)
		{
			if (is_object($link))
			$arr[$i] = $this->returnSee($link);
		}
		$cache[$this->package][$this->subpackage][$this->class] = $arr;
		return $arr;
	}
	
	function getPageContents()
	{
		static $cache = false;
		if (!isset($this->path)) $this->path = '#####';
		if ($cache)
		{
			if (isset($cache[$this->package][$this->subpackage][$this->path])) return $cache[$this->package][$this->subpackage][$this->path];
		}
		$arr = array();
		foreach($this->page_contents[$this->curpage->package][$this->curpage->subpackage] as $i => $link)
		{
			if (is_object($link))
			$arr[$i] = $this->returnSee($link);
		}
		$cache[$this->package][$this->subpackage][$this->path] = $arr;
		return $arr;
	}
	
	function getPageLeft()
	{
		static $cache = false;
		if ($cache)
		{
			if (isset($cache[$this->package][$this->subpackage])) return $cache[$this->package][$this->subpackage];
		}
		$arr = array();
		if (isset($this->left[$this->package]))
		foreach($this->left[$this->package] as $subpackage => $pages)
		{
			$arr[$subpackage] = $pages;
		}
		$templ = new Smarty;
		$templ->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
		$templ->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
		$templ->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
		$templ->assign('fileleftindex',$arr);
		$arr = $templ->fetch('fileleft.tpl');
		$cache[$this->package][$this->subpackage] = $arr;
		return $arr;
	}
	
	/**
	* Writes out the template file of {@link $page_data} and unsets the template to save memory
	* @see registerCurrent()
	* @see parent::endPage()
	*/
	function endPage()
	{
		$this->package = $this->curpage->package;
		$this->subpackage = $this->curpage->subpackage;
		$a = '../';
		if (!empty($this->subpackage)) $a .= '../';
		$this->setTargetDir($this->base_dir . PATH_DELIMITER . $this->page_dir);
		$this->page_data->assign("phpdocversion",PHPDOC_VER);
		$this->page_data->assign("phpdocwebsite",PHPDOC_WEBSITE);
		$this->page_data->assign("pagecontents",$this->getPageContents());
		$this->page_data->assign("compiledfileindex",$this->getPageLeft());
		$this->page_data->assign("compiledclassindex",$this->getClassLeft());
		$this->page_data->assign("packageindex",$this->package_index);
		$this->page_data->assign("package",$this->package);
		$this->page_data->assign("subdir",$a);
		$this->addTOC($this->curpage->file,$this->page,$this->package,$this->subpackage);
		$this->writefile($this->page . '.html',$this->page_data->fetch('page.tpl'));
		unset($this->page_data);
	}
	
	/**
	* @param string
	* @param string
	* @return string &lt;a href="'.$link.'">'.$text.'</a&gt;
	*/
	function returnLink($link,$text)
	{
		return '<a href="'.$link.'">'.$text.'</a>';
	}
	
	function makeLeft()
	{
		static $done = false;
		if ($done) return;
		$done = true;
		if (!isset($this->package_index))
		foreach($this->all_packages as $key => $val)
		{
			if (isset($this->pkg_elements[$key]))
			{
				if (!isset($start)) $start = $key;
				$this->package_index[] = array('link' => "li_$key.html", 'title' => $key);
			}
		}
		$this->local = false;
		foreach($this->page_elements as $package => $o1)
		{
			foreach($o1 as $subpackage => $links)
			{
				for($i=0;$i<count($links);$i++)
				{
					$this->left[$package][$subpackage][] =
						array("link" => $this->returnSee($links[$i], false, false, false), "title" => $links[$i]->name);
				}
			}
		}
		foreach($this->class_elements as $package => $o1)
		{
			foreach($o1 as $subpackage => $links)
			{
				for($i=0;$i<count($links);$i++)
				{
					$this->left['#class'][$package][$subpackage][] =
						array("link" => $this->returnSee($links[$i], false, false, false), "title" => $links[$i]->name);
				}
			}
		}
	}
	
	/**
	* HTMLdefaultConverter chooses to format both package indexes and the complete index here
	*
	* This function formats output for the elementindex.html and pkgelementindex.html template files.  It then
	* writes them to the target directory
	* @see generateElementIndex(), generatePkgElementIndex()
	*/
	function formatPkgIndex()
	{
		list($package_indexes,$packages,$mletters) = $this->generatePkgElementIndexes();
		for($i=0;$i<count($package_indexes);$i++)
		{
			$template = $this->newSmarty();
			$this->package = $package_indexes[$i]['package'];
			$this->subpackage = '';
			$template->assign("compiledclassindex",$this->getClassLeft());
			$template->assign("compiledfileindex",$this->getPageLeft());
			$template->assign("index",$package_indexes[$i]['pindex']);
			$template->assign("package",$package_indexes[$i]['package']);
			$template->assign("letters",$mletters[$package_indexes[$i]['package']]);
			$template->assign("title","Package ".$package_indexes[$i]['package']." Element Index");
			$template->assign("date",date("r",time()));
			$this->addTOC($package_indexes[$i]['package']." Alphabetical Index",'elementindex_'.$package_indexes[$i]['package'],$package_indexes[$i]['package'],'');
			$this->writefile('elementindex_'.$package_indexes[$i]['package'].'.html',$template->fetch('pkgelementindex.tpl'));
		}
		phpdoc_out("\n");
	}
	
	/**
	* HTMLdefaultConverter uses this function to format template index.html and packages.html
	*
	* This function generates the package list from {@link $all_packages}, eliminating any
	* packages that don't have any entries in their package index (no files at all, due to @ignore
	* or other factors).  Then it uses the default package name as the first package index to display.
	* It sets the right pane to be either a blank file with instructions on making package-level docs,
	* or the package-level docs for the default package.
	* @global string Used to set the starting package to display
	*/
	function formatIndex()
	{
		global $phpDocumentor_DefaultPackageName;
		list($elindex,$mletters) = $this->generateElementIndex();
		$template = $this->newSmarty();
		$template->assign("index",$elindex);
		$template->assign("letters",$mletters);
		$template->assign("title","Element Index");
		$template->assign("date",date("r",time()));
		phpdoc_out("\n");
		$this->setTargetDir($this->base_dir);
		$this->addTOC("Alphabetical Index Of All Elements",'elementindex',"Index",'');
		$this->writefile('elementindex.html',$template->fetch('elementindex.tpl'));
		uksort($this->package_index,"strnatcasecmp");
		$index = $this->newSmarty();
		foreach($this->all_packages as $key => $val)
		{
			if (isset($this->pkg_elements[$key]))
			{
				if (!isset($start)) $start = $key;
				if (!isset($this->package_pages[$key])) $this->writeNewPPage($key);
			}
		}
		// Created index.html
		if (isset($this->package_index[$phpDocumentor_DefaultPackageName])) $start = $phpDocumentor_DefaultPackageName;
		$this->package = $start;
		$this->subpackage = '';
		$index->assign("compiledclassindex",$this->getClassLeft());
		$index->assign("compiledfileindex",$this->getPageLeft());
		$index->assign("date",date("r",time()));
		$index->assign("title",$this->title);
		$index->assign("start","li_$start.html");
		if (isset($this->package_pages[$start]))
		{
			$index->assign("contents",$this->package_pages[$start]);
		}
		phpdoc_out("\n");
		$this->setTargetDir($this->base_dir);
		$this->addTOC("Start page","index","Index",'');
		$this->writefile("index.html",$index->fetch('index.tpl'));
		unset($index);

	}
	
	function writeNewPPage($key)
	{
		$template = $this->newSmarty();
		$this->package = $key;
		$this->subpackage = '';
		$template->assign("compiledclassindex",$this->getClassLeft());
		$template->assign("compiledfileindex",$this->getPageLeft());
		$template->assign("date",date("r",time()));
		$template->assign("title",$this->title);
		$template->assign("package",$key);
		phpdoc_out("\n");
		$this->setTargetDir($this->base_dir);
		$this->addTOC("$key Index","li_$key",$key,'');
		$this->writefile("li_$key.html",$template->fetch('index.tpl'));
		unset($template);
	}
	
	/**
	* Generate indexes for li_package.html and classtree output files
	*
	* This function generates the li_package.html files from the template file left.html.  It does this by
	* iterating through each of the $page_elements, $class_elements and  $function_elements arrays to retrieve
	* the pre-sorted {@link abstractLink} descendants needed for index generation.  Conversion of these links to
	* text is done by {@link returnSee()}.  The {@link $local} parameter is set to false to ensure that paths are correct.
	* 
	* Then it uses {@link generateFormattedClassTrees()} to create class trees from the template file classtrees.html.  Output
	* filename is classtrees_packagename.html.  This function also unsets {@link $elements} and {@link $pkg_elements} to free
	* up the considerable memory these two class vars use
	* @see $page_elements, $class_elements, $function_elements
	*/
	function formatLeftIndex()
	{
		phpdoc_out("\n");
		$this->setTargetDir($this->base_dir);
		if (!isset($this->left))
		{
			debug("Nothing parsed, check the command-line");
			die();
		}
		foreach($this->all_packages as $package => $rest)
		{
			if (!isset($this->pkg_elements[$package])) continue;
			// Create class tree page
			$template = $this->newSmarty();
			$template->assign("classtrees",$this->generateFormattedClassTrees($package));
			$template->assign("package",$package);
			$template->assign("date",date("r",time()));
			$template->assign("title","Class Trees for Package $package");
			$this->addTOC("$package Class Trees","classtrees_$package",$package,'');
			$this->writefile("classtrees_$package.html",$template->fetch('classtrees.tpl'));
			phpdoc_out("\n");
		}
		// free up considerable memory
		unset($this->elements);
		unset($this->pkg_elements);
		$this->local = true;
	}
	
	/**
	* This function takes an {@link abstractLink} descendant and returns an html link
	*
	* @param abstractLink a descendant of abstractlink should be passed, and never text
	* @param string text to display in the link
	* @param boolean this parameter is not used, and it set to $this->local.  See {@link $local}
	* @param boolean determines whether the returned text is enclosed in an &lt;a> tag
	*/
	function returnSee(&$element, $eltext = false, $local = true, $with_a = true)
	{
		if (PHPDOC_EXCEPTIONS)
		{
			addException(!is_object($element),PDEXCEPTION_NOT_A_CLASS,__FILE__,__LINE__,"element",$element,'eltext',$eltext,'local',$local,'with_a',$with_a);
		}
		$local = $this->local;
		if (!$element) return false;
		if (!$eltext)
		{
			$eltext = '';
			switch($element->type)
			{
				case 'method' :
				case 'var' :
				$eltext .= $element->class.'::';
				case 'page' :
				case 'define' :
				case 'class' :
				case 'function' :
				case 'global' :
				default :
				$eltext .= $element->name;
				if ($element->type == 'function' || $element->type == 'method') $eltext .= '()';
				break;
			}
		}
		$a = 1;
		$b = '';
		$c = '';
		if (!empty($this->subpackage))
		{
			$a++;
		}
		if (!empty($element->subpackage))
		{
			$c = '/'.$element->subpackage;
		}
		if ($local)
		{
			for($i=0;$i<$a;$i++) $b .= '../';
		}
		switch ($element->type)
		{
			case 'page' :
			if ($with_a)
			return '<a href="'.$b.$element->package.$c.'/_'.$element->fileAlias.'.html">'.$eltext.'</a>';
			else
			return $b.$element->package.$c.'/_'.$element->fileAlias.'.html';
			break;
			case 'define' :
			if ($with_a)
			return '<a href="'.$b.$element->package.$c.'/_'.$element->fileAlias.'.html#'.urlencode($element->name).'">'.$eltext.'</a>';
			else
			return $b.$element->package.$c.'/_'.$element->fileAlias.'.html#'.$element->name;
			break;
			case 'global' :
			if ($with_a)
			return '<a href="'.$b.$element->package.$c.'/_'.$element->fileAlias.'.html#'.urlencode($element->name).'">'.$eltext.'</a>';
			else
			return $b.$element->package.$c.'/_'.$element->fileAlias.'.html#'.$element->name;
			break;
			case 'class' :
			if ($with_a)
			return '<a href="'.$b.$element->package.$c.'/'.$element->name.'.html">'.$eltext.'</a>';
			else
			return $b.$element->package.$c.'/'.$element->name.'.html';
			break;
			case 'function' :
			if ($with_a)
			return '<a href="'.$b.$element->package.$c.'/_'.$element->fileAlias.'.html#'.$element->name.'">'.$eltext.'</a>';
			else
			return $b.$element->package.$c.'/_'.$element->fileAlias.'.html#'.$element->name;
			break;
			case 'method' :
			if ($with_a)
			return '<a href="'.$b.$element->package.$c.'/'.$element->class.'.html#'.$element->name.'">'.$eltext.'</a>';
			else
			return $b.$element->package.$c.'/'.$element->class.'.html#'.$element->name;
			break;
			case 'var' :
			if ($with_a)
			return '<a href="'.$b.$element->package.$c.'/'.$element->class.'.html#'.$element->name.'">'.$eltext.'</a>';
			else
			return $b.$element->package.$c.'/'.$element->class.'.html#'.$element->name;
			break;
		}
	}
	
	/**
	* Convert abstract $element for template
	*
	* calls helper function based on element type
	* @param mixed any descendant of {@link parserElement}, or {@link parserPage} or {@link parserPackagePage}
	* @see convertMethod(), convertFunction(), convertVar(), convertClass(), convertDefine(), convertGlobal()
	* @see convertInclude(), convertPage(), convertPackagePage()
	*/
	function Convert(&$element)
	{
		switch($element->type)
		{
			case 'method' :
				$this->convertMethod($element);
			break;
			case 'function' :
				$this->convertFunction($element);
			break;
			case 'var' :
				$this->convertVar($element);
			break;
			case 'class' :
				$this->convertClass($element);
			break;
			case 'define' :
				$this->convertDefine($element);
			break;
			case 'global' :
				$this->convertGlobal($element);
			break;
			case 'include' :
				$this->convertInclude($element);
			break;
			case 'page' :
				$this->convertPage($element);
			break;
			case 'packagepage' :
				$this->convertPackagePage($element);
			break;
		}
	}

	/**
	* Create errors.html template file output
	*
	* This method takes all parsing errors and warnings and spits them out ordered by file and line number.  It does not
	* display any phpDocumentor internal errors, that is handled by exceptions, which always terminate execution.
	* @see PHPDOC_EXCEPTIONS
	* @global ErrorTracker We'll be using it's output facility
	*/
	function ConvertErrorLog()
	{
		global $phpDocumentor_errors;
		$allfiles = array();
		$files = array();
		$warnings = $phpDocumentor_errors->returnWarnings();
		$errors = $phpDocumentor_errors->returnErrors();
		$template = $this->newSmarty();
		foreach($warnings as $warning)
		{
			$file = '##none';
			$linenum = 'Warning';
			if ($warning->file)
			{
				$file = $warning->file;
				$allfiles[$file] = 1;
				$linenum .= ' on line '.$warning->linenum;
			}
			$files[$file]['warnings'][] = array('name' => $linenum, 'listing' => $warning->data);
		}
		foreach($errors as $error)
		{
			$file = '##none';
			$linenum = 'Error';
			if ($error->file)
			{
				$file = $error->file;
				$allfiles[$file] = 1;
				$linenum .= ' on line '.$error->linenum;
			}
			$files[$file]['errors'][] = array('name' => $linenum, 'listing' => $error->data);
		}
		$i=1;
		$af = array();
		foreach($allfiles as $file => $num)
		{
			$af[$i++] = $file;
		}
		$allfiles = $af;
		usort($allfiles,'strnatcasecmp');
		$allfiles[0] = "Post-parsing";
		foreach($allfiles as $i => $a)
		{
			$allfiles[$i] = array('file' => $a);
		}
		$out = array();
		foreach($files as $file => $data)
		{
			if ($file == '##none') $file = 'Post-parsing';
			$out[$file] = $data;
		}
		$template->assign("files",$allfiles);
		$template->assign("all",$out);
		$template->assign("title","phpDocumentor Parser Errors and Warnings");
		$this->setTargetDir($this->base_dir);
		$this->writefile("errors.html",$template->fetch('errors.tpl'));
		unset($template);
		phpdoc_out("\n\nTo view errors and warnings, look at ".$this->base_dir. PATH_DELIMITER . "errors.html\n");
	}
	
	/**
	* convert the element's DocBlock for output
	*
	* This function converts all tags and descriptions for output
	* @return array Format: array(short description, long description, array(array('keyword' => tagname,'data' => converted tag),...))
	* @param mixed any descendant of {@link parserElement}, or {@link parserData}
	* @param boolean set to false for pages and classes, the only elements allowed to specify @package
	*/
	function prepareDocBlock(&$element,$nopackage = true)
	{
		$tpl = 'page_data';
		if ($element->type == 'class' || $element->type == 'method' || $element->type == 'var') $tpl = 'class_data';
		$tagses = $element->docblock->listTags();
		$tags = $ret = array();
		$names = array('staticvar' => 'Static Variable','deprec' => 'Deprecated','abstract' => 'Abstract Element','todo' => 'TODO');
		if (!$nopackage)
		{
			$tags[] = array('keyword' => 'Package','data' => $element->docblock->package);
			if (!empty($element->docblock->subpackage)) $tags[] = array('keyword' => 'Sub-Package','data' => $element->docblock->subpackage);
		}
		if ($element->docblock->var)
		{
			$a = $element->docblock->var->Convert($this);
			$ret['vartype'] = $element->docblock->var->converted_returnType;
			if (!empty($a))
			{
				$ret["var_descrip"] = adv_htmlentities($a);
			}
		}
		if ($element->docblock->funcglobals)
		foreach($element->docblock->funcglobals as $global => $val)
		{
			if ($a = $this->getGlobalLink($global,$element->docblock->package))
			{
				$global = $a;
			}
			$b = Converter::getLink($val[0]);
			if (is_object($b) && get_class($b) == 'classlink')
			{
				$val[0] = $this->returnSee($b);
			}
			$tags[] = array('keyword' => 'Global Variable Used','data' => $val[0].' '.$global.': '.adv_htmlentities($val[1]->Convert($this)));
		}
		if ($element->docblock->statics)
		foreach($element->docblock->statics as $static => $val)
		{
			$a = $val->Convert($this);
			$tags[] = array('keyword' => 'Static Variable Used','data' => $val->converted_returnType.' '.$static.': '.adv_htmlentities($a));
		}
		foreach($tagses as $tag)
		{
			if (isset($names[$tag->keyword])) $tag->keyword = $names[$tag->keyword];
			$tags[] = array("keyword" => ucfirst($tag->keyword),"data" => adv_htmlentities($tag->Convert($this)));
		}
		$ret['sdesc'] = '';
		$ret['desc'] = '';
		if ($element->docblock->sdesc) $ret['sdesc'] = adv_htmlentities($element->docblock->sdesc->Convert($this));
		if ($element->docblock->desc) $ret['desc'] = adv_htmlentities($element->docblock->desc->Convert($this));
		$ret['tags'] = $tags;
		if ($element->type != 'class' && $element->type != 'page')
		return $ret;
		$this->$tpl->assign('tags',$tags);
		$this->$tpl->assign('desc', $ret['desc']);
		$this->$tpl->assign('sdesc', $ret['sdesc']);
	}
	
	/**
	* Converts package page and sets its package as used in {@link $package_pages}
	* @param parserPackagePage
	*/
	function convertPackagePage(&$element)
	{
		phpdoc_out("\n");
		$template = $this->newSmarty();
		$this->package = $element->package;
		$this->subpackage = '';
		$template->assign("compiledclassindex",$this->getClassLeft());
		$template->assign("compiledfileindex",$this->getPageLeft());
		$template->assign("date",date("r",time()));
		$template->assign("title",$this->title);
		$template->assign("package",$element->package);
		$x = $element->Convert($this);
		$x = substr($x,strpos($x,'<body'));
		$template->assign("contents",trim(substr($x,strpos($x,'>') + 1)));
		phpdoc_out("\n");
		$this->setTargetDir($this->base_dir);
		$this->addTOC($element->package." Index","li_".$element->package,$element->package,'');
		$this->writefile("li_".$element->package.".html",$template->fetch('index.tpl'));
		unset($template);
		$this->package_pages[$element->package] = trim(substr($x,strpos($x,'>') + 1));
	}
	
	/**
	* Converts class variables for template output.
	* @see prepareDocBlock(), getFormattedOverrides()
	* @param parserVar
	*/
	function convertVar(&$element)
	{
		$docblock = $this->prepareDocBlock($element);
		$b = 'mixed';
		if ($element->docblock->var)
		{
			$b = $element->docblock->var->converted_returnType;
		}
		$this->class_data->append('vars',array('sdesc' => $docblock['sdesc'],
											   'desc' => $docblock['desc'],
											   'tags' => $docblock['tags'],
											   'var_name' => $element->getName(),
											   'var_default' => htmlspecialchars($element->getValue()),
											   'var_type' => $b,
											   'var_overrides' => $this->getFormattedOverrides($element)));
	}
	
	/**
	* Converts class for template output
	* @see prepareDocBlock(), generateChildClassList(), generateFormattedClassTree(), getFormattedConflicts()
	* @see getFormattedInheritedMethods(), getFormattedInheritedVars()
	* @param parserClass
	*/
	function convertClass(&$element)
	{
		$this->class = $element->getName();
		$this->class_dir = $element->docblock->package;
		if (!empty($element->docblock->subpackage)) $this->class_dir .= PATH_DELIMITER . $element->docblock->subpackage;
		$this->class_data = new Smarty;
		$this->class_data->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
		$this->class_data->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
		$this->class_data->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
		$a = '../classtrees_';
		if ($element->docblock->subpackage != '') $a = "../$a";
		$docblock = $this->prepareDocBlock($element,false);
		
		$this->class_data->assign("title","Docs For Class " . $element->getName());
		$this->class_data->assign("page",$element->getName() . '.html');
		$this->class_data->assign("class_name",$element->getName());
		$this->class_data->assign("vars",array());
		$this->class_data->assign("methods",array());
		$this->class_data->assign("package",$a.$element->docblock->package);

		$this->class_data->assign("children", $this->generateChildClassList($element));
		$this->class_data->assign("class_tree", $this->generateFormattedClassTree($element));
		$this->class_data->assign("conflicts", $this->getFormattedConflicts($element,"classes"));
		
		$this->class_data->assign("source_location",$element->getSourceLocation());
		$this->class_data->assign("date",date("r",time()));

		$inherited_methods = $this->getFormattedInheritedMethods($element);
		if (!empty($inherited_methods))
		{
			$this->class_data->assign("imethods",$inherited_methods);
		}
		$inherited_vars = $this->getFormattedInheritedVars($element);
		if (!empty($inherited_vars))
		{
			$this->class_data->assign("ivars",$inherited_vars);
		}
	}
	
	/**
	* Converts method for template output
	* @see prepareDocBlock(), parserMethod::getFunctionCall(), getFormattedDescMethods(), getFormattedOverrides()
	* @param parserMethod
	*/
	function convertMethod(&$element)
	{
		$fname = $element->getName();
		if ($element->isConstructor)
		{
			$fname = 'constructor '.$element->getName();
		}
		$docblock = $this->prepareDocBlock($element);
		$returntype = 'void';
		if ($element->docblock->return)
		{
			$a = $element->docblock->return->Convert($this);
			$returntype = $element->docblock->return->converted_returnType;
		}
		$params = array();
		if (count($element->docblock->params))
		foreach($element->docblock->params as $param => $val)
		{
			$a = $val->Convert($this);
			$params[] = array("var" => ucfirst($param),"datatype" => $val->converted_returnType,"data" => $a);
		}

		$this->class_data->append('methods',array('sdesc' => $docblock['sdesc'],
											   'desc' => $docblock['desc'],
											   'tags' => $docblock['tags'],
											   'function_name' 	=> $fname,
											   'function_return'	=> $returntype,
											   'function_call' 	=> $element->getFunctionCall(),
											   'descmethod'	=> $this->getFormattedDescMethods($element),
											   'method_overrides'	=> $this->getFormattedOverrides($element),
											   'params' => $params));
	}
	
	/**
	* Converts function for template output
	* @see prepareDocBlock(), parserFunction::getFunctionCall(), getFormattedConflicts()
	* @param parserFunction
	*/
	function convertFunction(&$element)
	{
		$docblock = $this->prepareDocBlock($element);
		$fname = $element->getName();
		$params = array();
		if (count($element->docblock->params))
		foreach($element->docblock->params as $param => $val)
		{
			$a = $val->Convert($this);
			$params[] = array("var" => ucfirst($param),"datatype" => $val->converted_returnType,"data" => $a);
		}
		$returntype = 'void';
		if ($element->docblock->return)
		{
			$a = $element->docblock->return->Convert($this);
			$returntype = $element->docblock->return->converted_returnType;
		}

		$this->page_data->append('functions',array('sdesc' => $docblock['sdesc'],
											 	   'desc' => $docblock['desc'],
												   'tags' => $docblock['tags'],
												   'function_name' 	=> $fname,
												   'function_link' 	=> "FUNCTION$$$".$fname,
												   'function_return'	=> $returntype,
												   'function_conflicts'	=> $this->getFormattedConflicts($element,"functions"),
												   'function_call' 	=> $element->getFunctionCall(),
												   'params' => $params));
	}
	
	/**
	* Converts include elements for template output
	* @see prepareDocBlock()
	* @param parserInclude
	*/
	function convertInclude(&$element)
	{
		$docblock = $this->prepareDocBlock($element);
		$per = $this->getIncludeValue($element->getValue());
		

		$this->page_data->append('includes',array('sdesc' => $docblock['sdesc'],
											 	  'desc' => $docblock['desc'],
												  'tags' => $docblock['tags'],
												  'include_name' 	=> $element->getName(),
												  'include_value'	=> $per,
												  'include_file'	=> '_'.strtr($element->getValue(),array('"' => '', "'" => '','.' => '_'))));
	}
	
	/**
	* Converts defines for template output
	* @see prepareDocBlock(), getFormattedConflicts()
	* @param parserDefine
	*/
	function convertDefine(&$element)
	{
		$docblock = $this->prepareDocBlock($element);
		$this->page_data->append('defines',array('sdesc' => $docblock['sdesc'],
											 	 'desc' => $docblock['desc'],
												 'tags' => $docblock['tags'],
												 'define_name' 	=> $element->getName(),
												 'define_link'	=> urlencode($element->getName()),
												 'define_value'	=> $element->getValue(),
												 'define_conflicts'	=> $this->getFormattedConflicts($element,"defines")));
	}
	
	/**
	* Converts global variables for template output
	* @param parserGlobal
	* @see prepareDocBlock(), getFormattedConflicts()
	*/
	function convertGlobal(&$element)
	{
		$docblock = $this->prepareDocBlock($element);
		$value = $this->getGlobalValue($element->getValue());
		$this->page_data->append('globals',array('sdesc' => $docblock['sdesc'],
											 	 'desc' => $docblock['desc'],
												 'tags' => $docblock['tags'],
												 'global_name' 	=> $element->getName(),
												 'global_link'	=> urlencode($element->getName()),
												 'global_value'	=> $value,
												 'global_conflicts'	=> $this->getFormattedConflicts($element,"global variables")));
	}
	
	/**
	* converts procedural pages for template output
	* @see prepareDocBlock(), getClassesOnPage()
	* @param parserData
	*/
	function convertPage(&$element)
	{
		$this->juststarted = true;
		$this->page_data = new Smarty;
		$this->page_data->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
		$this->page_data->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
		$this->page_data->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
		$this->page = '_'.$element->parent->getName();
		$this->path = $element->parent->getPath();
		$this->curpage = &$element->parent;
		$this->page_dir = $element->parent->package;
		if (!empty($element->parent->subpackage)) $this->page_dir .= PATH_DELIMITER . $element->parent->subpackage;
		// registering stuff on the template
		$this->page_data->assign("source_location",$element->parent->getSourceLocation());
		$this->page_data->assign("date",date("r",time()));
		$this->page_data->assign("functions",array());
		$this->page_data->assign("includes",array());
		$this->page_data->assign("defines",array());
		$this->page_data->assign("globals",array());
		$this->page_data->assign("classes",$this->getClassesOnPage($element));
		$this->page_data->assign("page",'_'.$element->parent->getName() . '.html');
		$this->page_data->assign("title","Docs for page ".$element->parent->getFile());
		if (0)
		{
		if ($element->docblock)
		{
			$docblock = $this->prepareDocBlock($element, false);
			$this->page_data->register("sdesc",$docblock[0]);
			$this->page_data->register("desc",$docblock[1]);
			$this->page_data->register("docblock",$docblock[2]);
		} else
		{
			$this->page_data->register("sdesc",'');
			$this->page_data->register("desc",'');
			$this->page_data->register("docblock",array());
		}}
		$this->page_data->assign("name", $element->parent->getFile());
	}
	
	/**
	* gets a list of all classes declared on a procedural page represented by $element, a {@link parserData} class
	* @param parserData &$element
	* @return string comma-delimited list of links to each classes documentation
	*/
	function getClassesOnPage(&$element)
	{
		$a = $element->getClasses($this);
		$r = '';
		foreach($a as $package => $classes)
		{
			for($i=0; $i<count($classes); $i++)
			{
				if (!empty($r)) $r .= ', ';
				$r .= $this->getClassLink($classes[$i]->getName(),$package,$classes[$i]->getPath());
			}
		}
		return $r;
	}
	
	/**
	* @param mixed {@link parserClass, parserFunction, parserDefine} or {@link parserGlobal}
	* @param string type to display.  either 'class','function','define' or 'global variable'
	* @return string full div of comma-separated links to conflicting elements, or empty string
	* @see parserClass::getConflicts(), parserFunction::getConflicts(), parserDefine::getConflicts(), parserGlobal::getConflicts()
	*/
	function getFormattedConflicts(&$element,$type)
	{
		$conflicts = $element->getConflicts($this);
		$r = '';
		if (!$conflicts) return $r;
		foreach($conflicts as $package => $class)
		{
			if (!empty($r)) $r .= ', ';
			$r .= $class->getLink($this,$class->docblock->package);
		}
		if (!empty($r)) $r = "<div align=\"left\"><b>Warning:</b> Conflicts with $type in packages $r<br></div>";
		return $r;
	}
	
	/**
	* @return string empty string or 'Overridden in child class(es) as: link to class1, link to class2...'
	* @see parserMethod::getOverridingMethods()
	* @param parserMethod
	*/
	function getFormattedDescMethods(&$element)
	{
		$meths = $element->getOverridingMethods($this);
		$r = '';
		for($i=0; $i<count($meths); $i++)
		{
			if (!empty($r)) $r .= ', ';
			$r .= $meths[$i]->getLink($this);//$this->getMethodLink($meths[$i]->getName(),$meths[$i]->class,$meths[$i]->docblock->package);
		}
		if (!empty($r)) $r = "Overridden in child class(es) as: $r<br>";
		return $r;
	}
	
	/**
	* @return string empty string or 'Overrides {link to overridden method}'
	* @see parserMethod::getOverrides()
	* @param parserMethod
	*/
	function getFormattedOverrides(&$element)
	{
		$ovr = $element->getOverrides($this);
		if (!$ovr) return '';
		return '<p>Overrides: '.$ovr->getLink($this).'</p>';
	}
	
	/**
	* returns a string containing a comma-delimited list of child classes
	*
	* @param parserClass class variable
	* @see parserClass::getChildClassList()
	*/
	
	function generateChildClassList($class)
	{
		$kids = $class->getChildClassList($this);
		$list = '';
		if (count($kids))
		{
			for($i=0; $i<count($kids); $i++)
			{
				if (!empty($list)) $list .= ', ';
				$list .= $this->getClassLink($kids[$i]->getName(),$kids[$i]->docblock->package, false, false, true);
			}
		}
		return $list;
	}

	/**
	* returns a string containing the class inheritance tree from the root object to the class
	*
	* @param parserClass	class variable
	* @see parserClass::getParentClassTree()
	*/
	
	function generateFormattedClassTree($class)
	{
		$tree = $class->getParentClassTree($this);
		$out = '';
		if (count($tree) - 1)
		{
			$result = array($class->getName());
			$parent = $tree[$class->getName()];
			while ($parent)
			{
				$subpackage = $parent->docblock->subpackage;
				$package = $parent->docblock->package;
				$x = $parent;
				if (is_object($parent))
				$x = $parent->getLink($this);
				if (!$x) $x = $parent->getName();
				$result[] = 
					$x."\n" .
					"%s|\n" .
					"%s--";
				if (is_object($parent))
				$parent = $tree[$parent->getName()];
				elseif (isset($tree[$parent]))
				$parent = $tree[$parent];
			}
			$nbsp = '   ';
			for($i=count($result) - 1;$i>=0;$i--)
			{
				$my_nbsp = '';
				for($j=0;$j<count($result) - $i;$j++) $my_nbsp .= $nbsp;
				$out .= sprintf($result[$i],$my_nbsp,$my_nbsp);
			}
			return "<pre>$out</pre>";
		} else
		{
			return $class->getName();
		}
	}
	
	/** @access private */
	function sortVar($a, $b)
	{
		return strnatcasecmp($a->getName(),$b->getName());
	}
	
	/** @access private */
	function sortMethod($a, $b)
	{
		if ($a->isConstructor) return -1;
		if ($b->isConstructor) return 1;
		return strnatcasecmp($a->getName(),$b->getName());
	}
	
	/**
	* Return template-enabled list of inherited variables
	*
	* uses parserVar helper function getInheritedVars and generates a template-enabled list using getClassLink()
	* @param parserVar $child class method
	* @see getClassLink(), parserVar::getInheritedVars()
	* @return array {@link Template}-ready array
	*/
	
	function getFormattedInheritedVars($child)
	{
		$package = $child->docblock->package;
		$subpackage = $child->docblock->subpackage;
		$ivars = $child->getInheritedVars($this);
		$results = array();
		if (!count($ivars)) return $results;
		foreach($ivars as $parent => $vars)
		{
			$file = $vars['file'];
			$vars = $vars['vars'];
			$par = $this->classes->getClass($parent,$file);
			if (PHPDOC_EXCEPTIONS)
			{
				addException(!is_object($par),PDEXCEPTION_NOT_A_CLASS,__FILE__,__LINE__,"class",$parent,"file",$file,"parent of class",$child);
			}
			$package = $par->docblock->package;
			usort($vars,array($this,"sortVar"));
			$result['parent_class'] = $this->getClassLink($parent,$package);
			foreach($vars as $var)
			{
				$info = array();
				if ($b = $this->getClassLink($parent,$package,false , false, true, false))
				{
					$info['ipath'] = $b;
				}
				$info['ivar_name'] = $var->getName();
				$info['ivar_default'] = $var->getValue();
				if ($var->docblock)
				$info['ivar_sdesc'] = $var->docblock->getSDesc($this);
				else
				$info['ivar_sdesc'] = '';
				$info['ipage'] = $this->class . '.html';
				$result["ivars"][] = $info;
			}
			$results[] = $result;
			$result = array();
		}
		return $results;
	}
	
	/**
	* Return template-enabled list of inherited methods
	*
	* uses parserMethod helper function getInheritedMethods and generates a template-enabled list using getClassLink()
	* @param parserMethod $child class method
	* @see getClassLink(), parserMethod::getInheritedMethods()
	* @return array {@link Template}-ready array
	*/

	function getFormattedInheritedMethods($child)
	{
		$package = $child->docblock->package;
		$subpackage = $child->docblock->subpackage;
		$imethods = $child->getInheritedMethods($this);
		$results = array();
		if (!count($imethods)) return $results;
		foreach($imethods as $parent => $methods)
		{
			$file = $methods['file'];
			$methods = $methods['methods'];
			$par = $this->classes->getClass($parent,$file);
			if (PHPDOC_EXCEPTIONS)
			{
				addException(!is_object($par),PDEXCEPTION_NOT_A_CLASS,__FILE__,__LINE__,"class",$parent,"file",$file,"parent of class",$child);
			}
			$package = $par->docblock->package;
			usort($methods,array($this,"sortMethod"));
			$result['parent_class'] = $this->getClassLink($parent,$package);
			foreach($methods as $method)
			{
				$info = array();
				if ($b = $this->getClassLink($parent,$package,false , false, true, false))
				{
					$info['ipath'] = $b;
				}
				$qq = '';
				if ($method->isConstructor) $qq = 'constructor ';
				$info['ifunction_name'] = $qq.$method->getName();
				if ($method->docblock)
				$info['ifunction_sdesc'] = $method->docblock->getSDesc($this);
				else
				$info['ifunction_sdesc'] = '';
				$info['ifunction_call'] = $method->getFunctionCall();
				$info['ipage'] = $this->class . '.html';
				$result["imethods"][] = $info;
			}
			$results[] = $result;
			$result = array();
		}
		return $results;
	}

	/**
	* returns a template-enabled array of class trees
	* 
	* @param	string	$package	package to generate a class tree for
	* @see $roots, HTMLConverter::getRootTree()
	*/
	function generateFormattedClassTrees($package)
	{
		$this->local = false;
		if (!isset($this->roots[$package])) return array();
		$roots = $trees = array();
		$roots = $this->roots[$package];
		for($i=0;$i<count($roots);$i++)
		{
			$trees[] = array('class' => $roots[$i],'class_tree' => "<ul>\n".$this->getRootTree($this->getSortedClassTreeFromClass($roots[$i],$package,''),$package)."</ul>\n");
		}
		$this->local = true;
		return $trees;
	}
	
	/**
	* return formatted class tree for the Class Trees page
	*
	* @param array $tree output from {@link getSortedClassTreeFromClass()}
	* @see Classes::$definitechild, generateFormattedClassTrees()
	* @return string
	*/
	function getRootTree($tree,$package)
	{
		if (!$tree) return '';
		$my_tree = '';
		$cur = '#root';
		$lastcur = array(false);
		$kids = array();
		$dopar = false;
		if ($tree[$cur]['parent'])
		{
			$dopar = true;
			if (!is_object($tree[$cur]['parent']))
			{
//				debug("parent ".$tree[$cur]['parent']." not found");
				$my_tree .= '<li>' . $tree[$cur]['parent'] .'<ul>';
			}
			else
			{
//						debug("parent ".$this->returnSee($tree[$cur]['parent'], false, false)." in other package");
				$my_tree .= '<li>' . $this->returnSee($tree[$cur]['parent'], false, false);
				if ($tree[$cur]['parent']->package != $package) $my_tree .= ' <b>(Different package)</b><ul>';
			}
		}
		do
		{
//			fancy_debug($cur,$lastcur,$kids);
			if (count($tree[$cur]['children']))
			{
//				debug("$cur has children");
				if (!isset($kids[$cur]))
				{
//					debug("set $cur kids");
					$kids[$cur] = 1;
					$my_tree .= '<li>'.$this->returnSee($tree[$cur]['link'], false, false);
					$my_tree .= '<ul>'."\n";
				}
				array_push($lastcur,$cur);
				list(,$cur) = each($tree[$cur]['children']);
//				var_dump('listed',$cur);
				if ($cur)
				{
					$cur = $cur['package'] . '#' . $cur['class'];
//					debug("set cur to child $cur");
//					$my_tree .= '<li>'.$this->returnSee($tree[$cur]['link'], false, false);
					continue;
				} else
				{
//					debug("end of children for $cur");
					$cur = array_pop($lastcur);
					$cur = array_pop($lastcur);
					$my_tree .= '</ul></li>'."\n";
					if ($dopar && ($cur == '#root' || !$cur)) $my_tree .= '</ul></li>';
				}
			} else 
			{
//				debug("$cur has no children");
				$my_tree .= '<li>'.$this->returnSee($tree[$cur]['link'], false, false)."</li>";
				if ($dopar && $cur == '#root') $my_tree .= '</ul></li>';
				$cur = array_pop($lastcur);
			}
		} while ($cur);
		return $my_tree;
	}
	/**
	* Generate alphabetical index of all elements
	*
	* @see $elements, walk()
	*/
	function generateElementIndex()
	{
		$this->local = false;
		$elementindex = array();
		$letters = array();
		$i = 0;
		foreach($this->elements as $letter => $nutoh)
		{
			$letters[]['letter'] = $letter;
			$elindex['letter'] = $letter;
			foreach($this->elements[$letter] as $i => $yuh)
			{
				switch($this->elements[$letter][$i]->type)
				{
					case 'class':
						$aa = '';
						$aa = $this->elements[$letter][$i]->docblock->getSDesc($this);
						if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
						$oo['name'] = $this->elements[$letter][$i]->getName();
						$oo['listing'] =
							'in file '.$this->elements[$letter][$i]->file.', class '.$this->getClassLink($this->elements[$letter][$i]->getName(),
												$this->elements[$letter][$i]->docblock->package,
												$this->elements[$letter][$i]->getPath(),
												$this->elements[$letter][$i]->getName()
												, false
												, true)."$aa";
						$elindex['index'][] = $oo; 
					break;
					case 'define':
						$aa = '';
						$aa = $this->elements[$letter][$i]->docblock->getSDesc($this);
						if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
						$oo['name'] = $this->elements[$letter][$i]->getName();
						$oo['listing'] =
							'in file '.$this->elements[$letter][$i]->file.', constant '.$this->getDefineLink($this->elements[$letter][$i]->getName(),
												 $this->elements[$letter][$i]->docblock->package,
												 $this->elements[$letter][$i]->getPath(),
												 $this->elements[$letter][$i]->getName()
												 , false)."$aa";
						$elindex['index'][] = $oo; 
					break;
					case 'global':
						$aa = '';
						$aa = $this->elements[$letter][$i]->docblock->getSDesc($this);
						if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
						$oo['name'] = $this->elements[$letter][$i]->getName();
						$oo['listing'] =
							'in file '.$this->elements[$letter][$i]->file.', global variable '.$this->getGlobalLink($this->elements[$letter][$i]->getName(),
												 $this->elements[$letter][$i]->docblock->package,
												 $this->elements[$letter][$i]->getPath(),
												 $this->elements[$letter][$i]->getName()
												 , false)."$aa";
						$elindex['index'][] = $oo; 
					break;
					case 'function':
						$aa = '';
						$aa = $this->elements[$letter][$i]->docblock->getSDesc($this);
						if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
						$oo['name'] = $this->elements[$letter][$i]->getName();
						$oo['listing'] =
							'in file '.$this->elements[$letter][$i]->file.', function '.$this->getFunctionLink($this->elements[$letter][$i]->getName(),
												   $this->elements[$letter][$i]->docblock->package,
												   $this->elements[$letter][$i]->getPath(),
												   $this->elements[$letter][$i]->getName().'()'
												   , false)."$aa";
						$elindex['index'][] = $oo; 
					break;
					case 'method':
						$aa = '';
						$aa = $this->elements[$letter][$i]->docblock->getSDesc($this);
						if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
						$oo['name'] = $this->elements[$letter][$i]->getName();
						$oo['listing'] =
							'in file '.$this->elements[$letter][$i]->file.', method '.$this->getMethodLink($this->elements[$letter][$i]->getName(),
												 $this->elements[$letter][$i]->class,
												 $this->elements[$letter][$i]->docblock->package,
												 $this->elements[$letter][$i]->getPath(),
												 $this->elements[$letter][$i]->class.'::'.$this->elements[$letter][$i]->getName().'()'
												 , false)."$aa";
						$elindex['index'][] = $oo; 
					break;
					case 'var':
						$aa = '';
						$aa = $this->elements[$letter][$i]->docblock->getSDesc($this);
						if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
						$oo['name'] = $this->elements[$letter][$i]->getName();
						$oo['listing'] =
							'in file '.$this->elements[$letter][$i]->file.', variable '.$this->getVarLink($this->elements[$letter][$i]->getName(),
											  $this->elements[$letter][$i]->class,
											  $this->elements[$letter][$i]->docblock->package,
											  $this->elements[$letter][$i]->getPath(),
											  $this->elements[$letter][$i]->class.'::'.$this->elements[$letter][$i]->getName()
											  , false)."$aa";
						$elindex['index'][] = $oo; 
					break;
					case 'page':
						$oo['name'] = $this->elements[$letter][$i]->getFile();
						$oo['listing'] =
							'procedural page '.$this->getPageLink($this->elements[$letter][$i]->getFile(),
											   $this->elements[$letter][$i]->package,
											   $this->elements[$letter][$i]->getPath(),
											   $this->elements[$letter][$i]->getFile()
											   , false);
						$elindex['index'][] = $oo; 
					break;
				}
			}
			if (isset($elindex['index']))
			{
				$elementindex[] = $elindex;
			} else
			{
				unset($letters[count($letters) - 1]);
			}
			$elindex = array();
		}
		$this->local = true;
		return array($elementindex,$letters);
	}
	
	function setTemplateDir($dir)
	{
		Converter::setTemplateDir($dir);
		$this->smarty_dir = $this->templateDir;
	}
	
	/**
	* calls the converter setTargetDir, and then copies any template images and the stylesheet if they haven't been copied
	* @see Converter::setTargetDir()
	*/
	function setTargetDir($dir)
	{
		Converter::setTargetDir($dir);
		static $wrote = false;
		if ($wrote) return;
		$wrote = true;
		$template_images = array();
		$stylesheets = array();
		$dir = $this->templateDir;
		$this->templateDir = $this->templateDir.'templates/';
		$d = dir($this->templateDir); 
		$template_images = array();
		while($entry = $d->read())
		{
			$sp = explode(".", $entry); 
			if ( preg_match("/\.(gif|jpg|png)$/i", $entry) )
			{
				$template_images[] = $entry;
			}
		}
		$d = dir($this->templateDir); 
		while($entry = $d->read())
		{
			$sp = explode(".", $entry); 
			if ( preg_match("/\.css$/i", $entry) )
			{
				$stylesheets[] = $entry;
			}
		}
		phpdoc_out("Copying Any Stylesheets\n");
		foreach($stylesheets as $image)
		{
			if (file_exists($this->templateDir.$image))
			{
				phpdoc_out("Writing $image\n");
				$this->copyFile($image);
			}
		}
		phpdoc_out("Copying Any Template Images\n");
		foreach($template_images as $image)
		{
			if (file_exists($this->templateDir.$image))
			{
				phpdoc_out("Writing $image\n");
				$this->copyFile($image);
			}
		}
		$this->templateDir = $dir;
	}
	
	/**
	* Generate alphabetical index of all elements by package and subpackage
	*
	* @param string $package name of a package
	* @see $pkg_elements, walk(), generatePkgElementIndexes()
	*/
	function generatePkgElementIndex($package)
	{
		$this->local = false;
		$elementindex = array();
		$letters = array();
		$letterind = array();
		$used = array();
		$subp = '';
		foreach($this->pkg_elements[$package] as $subpackage => $els)
		{
			if (empty($els)) continue;
			if (!empty($subpackage)) $subp = " (<b>subpackage:</b> $subpackage)"; else $subp = '';
			foreach($els as $letter => $yuh)
			{
				if (!isset($used[$letter]))
				{
					$letters[]['letter'] = $letter;
					$letterind[$letter] = count($letters) - 1;
					$used[$letter] = 1;
				}
				$elindex[$letter]['letter'] = $letter;
				foreach($els[$letter] as $i => $yuh)
				{
					switch($els[$letter][$i]->type)
					{
						case 'class':
							$aa = '';
							$aa = $els[$letter][$i]->docblock->getSDesc($this);
							if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
							$oo['name'] = $els[$letter][$i]->getName();
							$oo['listing'] =
								'in file '.$els[$letter][$i]->file.', class '.$this->getClassLink($els[$letter][$i]->getName(),
													$els[$letter][$i]->docblock->package,
													$els[$letter][$i]->getPath(),
													$els[$letter][$i]->getName()
													, false
													, true)."$subp$aa";
							$elindex[$letter]['index'][] = $oo; 
						break;
						case 'define':
							$aa = '';
							$aa = $els[$letter][$i]->docblock->getSDesc($this);
							if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
							$oo['name'] = $els[$letter][$i]->getName();
							$oo['listing'] =
								'in file '.$els[$letter][$i]->file.', constant '.$this->getDefineLink($els[$letter][$i]->getName(),
													 $els[$letter][$i]->docblock->package,
													 $els[$letter][$i]->getPath(),
													 $els[$letter][$i]->getName()
													 , false)."$subp$aa";
							$elindex[$letter]['index'][] = $oo; 
						break;
						case 'global':
							$aa = '';
							$aa = $els[$letter][$i]->docblock->getSDesc($this);
							if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
							$oo['name'] = $els[$letter][$i]->getName();
							$oo['listing'] =
								'in file '.$els[$letter][$i]->file.', global variable '.$this->getGlobalLink($els[$letter][$i]->getName(),
													 $els[$letter][$i]->docblock->package, 
													 $els[$letter][$i]->getPath(),
													 $els[$letter][$i]->getName()
													 ,false)."$subp$aa";
							$elindex[$letter]['index'][] = $oo; 
						break;
						case 'function':
							$aa = '';
							$aa = $els[$letter][$i]->docblock->getSDesc($this);
							if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
							$oo['name'] = $els[$letter][$i]->getName();
							$oo['listing'] =
								'in file '.$els[$letter][$i]->file.', function '.$this->getFunctionLink($els[$letter][$i]->getName(),
													   $els[$letter][$i]->docblock->package,
													   $els[$letter][$i]->getPath(),
													   $els[$letter][$i]->getName().'()'
													   , false)."$subp$aa";
							$elindex[$letter]['index'][] = $oo; 
						break;
						case 'method':
							$aa = '';
							$aa = $els[$letter][$i]->docblock->getSDesc($this);
							if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
							$oo['name'] = $els[$letter][$i]->getName();
							$oo['listing'] =
								'in file '.$els[$letter][$i]->file.', method '.$this->getMethodLink($els[$letter][$i]->getName(),
													 $els[$letter][$i]->class,
													 $els[$letter][$i]->docblock->package, 
													 $els[$letter][$i]->getPath(),
													 $els[$letter][$i]->class.'::'.$els[$letter][$i]->getName().'()'
													 , false)."$subp$aa";
							$elindex[$letter]['index'][] = $oo; 
						break;
						case 'var':
							$aa = '';
							$aa = $els[$letter][$i]->docblock->getSDesc($this);
							if (!empty($aa)) $aa = "<br>&nbsp;&nbsp;&nbsp;&nbsp;$aa";
							$oo['name'] = $els[$letter][$i]->getName();
							$oo['listing'] =
								'in file '.$els[$letter][$i]->file.', variable '.$this->getVarLink($els[$letter][$i]->getName(),
												  $els[$letter][$i]->class,
												  $els[$letter][$i]->docblock->package,
												  $els[$letter][$i]->getPath(),
												  $els[$letter][$i]->class.'::'.$els[$letter][$i]->getName()
												  , false)."$subp$aa";
							$elindex[$letter]['index'][] = $oo; 
						break;
						case 'page':
							$oo['name'] = $els[$letter][$i]->getFile();
							$oo['listing'] =
								'procedural page '.$this->getPageLink($els[$letter][$i]->getFile(),
												   $els[$letter][$i]->package,
												   $els[$letter][$i]->getPath(),
												   $els[$letter][$i]->getFile()
												   , false)."$subp";
							$elindex[$letter]['index'][] = $oo; 
						break;
					}
				}
			}
		}
		ksort($elindex);
		usort($letters,'lettersort');
		if (isset($elindex))
		{
			while(list($letter,$tempel) = each($elindex))
			{
				if (!isset($tempel))
				{
					unset($letters[$letterind[$tempel['letter']]]);
				} else
				$elementindex[] = $tempel;
			}
		} else $letters = array();
		$this->local = true;
		return array($elementindex,$letters);
	}
	
	/**
	*
	* @see generatePkgElementIndex()
	*/
	function generatePkgElementIndexes()
	{
		$packages = array();
		$package_names = array();
		$pkg = array();
		$letters = array();
		foreach($this->pkg_elements as $package => $trash)
		{
			$pkgs['package'] = $package;
			$pkg['package'] = $package;
			list($pkg['pindex'],$letters[$package]) = $this->generatePkgElementIndex($package);
			if (count($pkg['pindex']))
			{
				$packages[] = $pkg;
				$package_names[] = $pkgs;
			}
			unset($pkgs);
			unset($pkg);
		}
		foreach($packages as $i => $package)
		{
			$pnames = array();
			for($j=0;$j<count($package_names);$j++)
			{
				if ($package_names[$j]['package'] != $package['package']) $pnames[] = $package_names[$j];
			}
			$packages[$i]['packageindexes'] = $pnames;
		}
		return array($packages,$package_names,$letters);
	}
	
	/**
	* @param string name of class
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @param boolean return just the URL, or enclose it in an html a tag
	* @return mixed false if not found, or an html a link to the class's documentation
	* @see parent::getClassLink()
	*/
	function getClassLink($expr,$package, $file = false,$text = false, $local = true, $with_a = true)
	{
		$a = Converter::getClassLink($expr,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text, $local, $with_a);
	}

	/**
	* @param string name of function
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @param boolean return just the URL, or enclose it in an html a tag
	* @return mixed false if not found, or an html a link to the function's documentation
	* @see parent::getFunctionLink()
	*/
	function getFunctionLink($expr,$package, $file = false,$text = false, $local = true)
	{
		$a = Converter::getFunctionLink($expr,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text, $local);
	}

	/**
	* @param string name of define
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @param boolean return just the URL, or enclose it in an html a tag
	* @return mixed false if not found, or an html a link to the define's documentation
	* @see parent::getDefineLink()
	*/
	function getDefineLink($expr,$package, $file = false,$text = false, $local = true)
	{
		$a = Converter::getDefineLink($expr,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text, $local);
	}

	/**
	* @param string name of global variable
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @param boolean return just the URL, or enclose it in an html a tag
	* @return mixed false if not found, or an html a link to the global variable's documentation
	* @see parent::getGlobalLink()
	*/
	function getGlobalLink($expr,$package, $file = false,$text = false, $local = true)
	{
		$a = Converter::getGlobalLink($expr,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text, $local);
	}

	/**
	* @param string name of procedural page
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @param boolean return just the URL, or enclose it in an html a tag
	* @return mixed false if not found, or an html a link to the procedural page's documentation
	* @see parent::getPageLink()
	*/
	function getPageLink($expr,$package, $path = false,$text = false, $local = true)
	{
		$a = Converter::getPageLink($expr,$package,$path);
		if (!$a) return false;
		return $this->returnSee($a, $text, $local);
	}

	/**
	* @param string name of method
	* @param string class containing method
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @param boolean return just the URL, or enclose it in an html a tag
	* @return mixed false if not found, or an html a link to the method's documentation
	* @see parent::getMethodLink()
	*/
	function getMethodLink($expr,$class,$package, $file = false,$text = false, $local = true)
	{
		$a = Converter::getMethodLink($expr,$class,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text, $local);
	}

	/**
	* @param string name of var
	* @param string class containing var
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @param boolean return just the URL, or enclose it in an html a tag
	* @return mixed false if not found, or an html a link to the var's documentation
	* @see parent::getVarLink()
	*/
	function getVarLink($expr,$class,$package, $file = false,$text = false, $local = true)
	{
		$a = Converter::getVarLink($expr,$class,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text, $local);
	}
	
	/**
	* returns {@link $local}
	* @see Converter::getState()
	*/
	function getState()
	{
		return $this->local;
	}

	/**
	* checks $state to see if it is the same as {@link $local}
	* @param boolean value to compare to $local
	* @see Converter::getState(), $local
	*/
	function checkState($state)
	{
		return $state == $this->local;
	}

	/**
	* does a nat case sort on the specified second level value of the array
	*
	* @param	mixed	$a
	* @param	mixed	$b
	* @return	int
	*/
	function rcNatCmp ($a, $b)
	{
		$aa = strtoupper($a[$this->rcnatcmpkey]);
		$bb = strtoupper($b[$this->rcnatcmpkey]);
		
		return strnatcasecmp($aa, $bb);
	}
	
	/**
	* does a nat case sort on the specified second level value of the array.
	* this one puts constructors first
	*
	* @param	mixed	$a
	* @param	mixed	$b
	* @return	int
	*/
	function rcNatCmp1 ($a, $b)
	{
		$aa = strtoupper($a[$this->rcnatcmpkey]);
		$bb = strtoupper($b[$this->rcnatcmpkey]);
		
		if (strpos($aa,'CONSTRUCTOR') === 0)
		{
			return -1;
		}
		if (strpos($bb,'CONSTRUCTOR') === 0)
		{
			return 1;
		}
		if (strpos($aa,strtoupper($this->class)) === 0)
		{
			return -1;
		}
		if (strpos($bb,strtoupper($this->class)) === 0)
		{
			return -1;
		}
		return strnatcasecmp($aa, $bb);
	}
	
	function writefile($file,$contents)
	{
		$this->addHHP($this->targetDir . PATH_DELIMITER . $file);
		Converter::writefile($file,$contents);
	}
	
	function addHHP($file)
	{
		$file = str_replace('\\',PATH_DELIMITER,$file);
		$file = str_replace('//',PATH_DELIMITER,$file);
		$file = str_replace(PATH_DELIMITER,'\\',$file);
		$this->hhp_files[]['name'] = $file;
	}
	
	function generateTOC()
	{
		$comppack = '';
		$templ = new Smarty;
		$templ->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
		$templ->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
		$templ->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
		foreach($this->TOC as $package => $TOC1)
		{
			$comp_subs = '';
			$comp_subs1 = false;
			foreach($TOC1 as $subpackage => $types)
			{
				$comp_types = '';
				foreach($types as $type => $files)
				{
					$comp = '';
					$templ1 = new Smarty;
					$templ1->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
					$templ1->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
					$templ1->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
					$templ1->assign('entry', array());
					foreach($files as $file)
					{
						$templ1->append('entry', array('paramname' => $file[0],'outputfile' => $file[1]));
					}
					$templ = new Smarty;
					$templ->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
					$templ->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
					$templ->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
					$templ->assign('tocsubentries',$templ1->fetch('tocentry.tpl'));
					$templ->assign('entry', array(array('paramname' => $type)));
					$comp_types .= $templ->fetch('tocentry.tpl');
				}
				if (!empty($subpackage))
				{
					$templ = new Smarty;
					$templ->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
					$templ->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
					$templ->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
					$templ->assign('tocsubentries',$comp_types);
					$templ->assign('entry', array(array('paramname' => $subpackage)));
					$comp_subs .= $templ->fetch('tocentry.tpl');
				} else
				{
					$comp_subs1 = $comp_types;
				}
			}
			if ($comp_subs1)
			$templ->assign('tocsubentries',$comp_subs1);
			if (!empty($comp_subs))
			$templ->assign('entry', array(array('paramname' => $package, 'tocsubentries' => $comp_subs)));
			else
			$templ->assign('entry', array(array('paramname' => $package)));
			$comppack .= $templ->fetch('tocentry.tpl');
		}
		return $comppack;
	}
	
	function addTOC($name,$file,$package,$subpackage,$class = false)
	{
		$file = $this->targetDir . PATH_DELIMITER . $file . '.html';
		$file = str_replace('\\',PATH_DELIMITER,$file);
		$file = str_replace('//',PATH_DELIMITER,$file);
		$file = str_replace(PATH_DELIMITER,'\\',$file);
		$sub = $class ? 'Classes' : 'Files';
		$this->TOC[$package][$subpackage][$sub][] = array($name,$file);
	}
	
	/**
	* This function will be used by CHMdefaultConverter to call html help compiler
	*/
	function Output()
	{
		$templ = new Smarty;
		$templ->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
		$templ->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
		$templ->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
		$file = $this->base_dir . PATH_DELIMITER;
		$file = str_replace('\\',PATH_DELIMITER,$file);
		$file = str_replace('//',PATH_DELIMITER,$file);
		$file = str_replace(PATH_DELIMITER,'\\',$file);
		$templ->assign('files',$this->hhp_files);
		$this->setTargetDir($this->base_dir);
		Converter::writefile('phpdoc.hhp',$templ->fetch('hhp.tpl'));
		$templ = new Smarty;
		$templ->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
		$templ->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
		$templ->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
		$templ->assign('toc',$this->generateTOC());
		$templ->assign('phpdocver',PHPDOC_VER);
		Converter::writefile('contents.hhc',$templ->fetch('contents.hhc.tpl'));
		phpdoc_out("NOTE: to create the documentation.chm file, you must now run Microsoft Help Workshop on phpdoc.hhp\n");
		phpdoc_out("To get the free Microsoft Help Workshop, browse to: http://www.microsoft.com/downloads/release.asp?releaseid=33071\n");
	}
}

/** @access private */
function lettersort($a, $b)
{
	return strnatcasecmp($a['letter'],$b['letter']);
}
?>
