<?php
include_once('class.phpdocpdf.php');
/**
* Smarty template files
*/
require_once("Smarty.class.php");
/**
* PDF output converter.
* This Converter takes output from the {@link Parser} and converts it to PDF-ready output for use with {@link Cezpdf}.
* This is extraordinarily pre-alpha code.
*
* @package Converters
* @subpackage PDFdefault
* @author Greg Beaver <cellog@users.sourceforge.net>
* @since 1.1
* @version $Id: PDFdefaultConverter.inc,v 1.14.2.5 2002/11/12 19:14:25 CelloG Exp $
*/
class PDFdefaultConverter extends Converter
{
	/**
	* default PDF Converter wants elements sorted by type as well as alphabetically
	* @see Converter::$sort_page_contents_by_type
	* @var boolean
	*/
	var $sort_page_contents_by_type = true;
	var $leftindex = array('classes' => false, 'pages' => false, 'functions' => false, 'defines' => false, 'globals' => false);
	var $pagepackage_pagenums = array();
	var $classpackage_pagenums = array();
	/** @var string always PDF */
	var $outputformat = 'PDF';
	/** @var string always default */
	var $name = 'default';
	var $curpagepackage = false;
	var $curclasspackage = false;
    var $smarty_dir;
	/**
	* @var Cezpdf
	*/
	var $pdf = false;
	/**
	* @see Converter::Converter()
	*/
	function PDFdefaultConverter(&$allp, &$packp, &$classes, &$procpages, $po, $pp, $qm, $targetDir, $templateDir, $title)
	{
		Converter::Converter($allp, $packp, $classes, $procpages, $po, $pp, $qm, $targetDir, $templateDir, $title);
		$this->pdf =& new phpdocpdf('letter');
		$this->pdf->selectFont('./Converters/PDF/default/templates/fonts/Helvetica.afm');		
// put a line top and bottom on all the pages
		$this->pdf->ezSetMargins(50,70,50,50);
		$all = $this->pdf->openObject();
		$this->pdf->saveState();
		$this->pdf->setStrokeColor(0,0,0,1);
		$this->pdf->line(20,40,578,40);
		$this->pdf->line(20,822,578,822);
		$this->pdf->addText(50,34,6,'Generated by phpDocumentor <b>v'.PHPDOC_VER.'</b> http://www.phpdoc.org - http://www.sourceforge.net/projects/phpdocu');
		$this->pdf->restoreState();
		$this->pdf->closeObject();
		// note that object can be told to appear on just odd or even pages by changing 'all' to 'odd'
		// or 'even'.
		$this->pdf->addObject($all,'all');
		
		$this->pdf->ezSetDy(-100);
		$this->pdf->ezText($title,30,array('justification'=>'centre'));
		
		$this->pdf->ezSetDy(-150);
		// modified to use the local file if it can
		
		$this->pdf->openHere('FitH');
		
		if (file_exists('logo.jpg'))
		{
			$this->pdf->addJpegFromFile('logo.jpg',199,$this->pdf->y-100,200,0);
		}
	}
	
	/**
	* Returns a bookmark using Cezpdf 009
	*
	* @param abstractLink a descendant of abstractlink should be passed, and never text
	* @param string text to display in the link
	*/
	function returnSee(&$element, $eltext = false)
	{
		if (!$element) return false;
		if (!$eltext)
		{
			$eltext = '';
			switch($element->type)
			{
				case 'method' :
				case 'var' :
				$eltext .= $element->class.'::';
				case 'page' :
				case 'define' :
				case 'class' :
				case 'function' :
				case 'global' :
				default :
				$eltext .= $element->name;
				if ($element->type == 'function' || $element->type == 'method') $eltext .= '()';
				break;
			}
		}
		switch ($element->type)
		{
			case 'page' :
			return '<c:ilink:'.urlencode($element->type.$element->package.$element->path).'>'.$eltext.'</c:ilink>';
			case 'define' :
			case 'global' :
			case 'class' :
			case 'function' :
			return '<c:ilink:'.urlencode($element->type.$element->package.$element->name).'>'.$eltext.'</c:ilink>';
			case 'method' :
			case 'var' :
			return '<c:ilink:'.urlencode($element->type.$element->package.$element->class.'::'.$element->name).'>'.$eltext.'</c:ilink>';
		}
		
		return "<c:ilink:".urlencode($link).">$eltext</c:ilink>";
	}
	
	/**
	* @param string
	* @param string
	* @return string <c:alink:$link>$text</c:alink>
	*/
	function returnLink($link,$text)
	{
		return "<c:alink:$link>$text</c:alink>";
	}
    
	/**
	* Convert abstract $element for template
	*
	* calls helper function based on element type
	* @param mixed any descendant of {@link parserElement}, or {@link parserPage} or {@link parserPackagePage}
	* @see convertMethod(), convertFunction(), convertVar(), convertClass(), convertDefine(), convertGlobal()
	* @see convertInclude(), convertPage(), convertPackagePage()
	*/
	function Convert(&$element)
	{
		switch($element->type)
		{
			case 'method' :
				$this->convertMethod($element);
			break;
			case 'function' :
				$this->convertFunction($element);
			break;
			case 'var' :
				$this->convertVar($element);
			break;
			case 'class' :
				$this->convertClass($element);
			break;
			case 'define' :
				$this->convertDefine($element);
			break;
			case 'global' :
				$this->convertGlobal($element);
			break;
			case 'include' :
				$this->convertInclude($element);
			break;
			case 'page' :
				$this->convertPage($element);
			break;
			case 'packagepage' :
				$this->convertPackagePage($element);
			break;
		}
	}
	
	function convertDocBlock(&$element)
	{
		if (!$element->docblock) return;
		$nopackage = true;
		if ($element->type == 'page' || $element->type == 'docblock') $nopackage = false;
		$tagses = $element->docblock->listTags();
		$tags = array();
		$names = array('staticvar' => 'Static Variable','deprec' => 'Deprecated','abstract' => 'Abstract Element','todo' => 'TODO');
		if (!$nopackage)
		{
			$tags[] = array('keyword' => 'Package','data' => $element->docblock->package);
			if (!empty($element->docblock->subpackage)) $tags[] = array('keyword' => 'Sub-Package','data' => $element->docblock->subpackage);
		}
		if ($element->docblock->var)
		{
			$a = $element->docblock->var->Convert($this);
			if (!empty($a))
			$tags[] = array('keyword' => 'Var', 'data' => $a);
		}
		if ($element->docblock->funcglobals)
		foreach($element->docblock->funcglobals as $global => $val)
		{
			if ($a = $this->getGlobalLink($global,$element->docblock->package))
			{
				$global = $a;
			}
			$b = Converter::getLink($val[0]);
			if (is_object($b) && get_class($b) == 'classlink')
			{
				$val[0] = $this->returnSee($b);
			}
			$tags[] = array('keyword' => 'Global Variable Used','data' => $val[0].' '.$global.': '.$val[1]->Convert($this));
		}
		if ($element->docblock->statics)
		foreach($element->docblock->statics as $static => $val)
		{
			$a = $val->Convert($this);
			$tags[] = array('keyword' => 'Static Variable Used','data' => $val->converted_returnType.' '.$static.': '.$a);
		}
		foreach($tagses as $tag)
		{
			if (isset($names[$tag->keyword])) $tag->keyword = $names[$tag->keyword];
			$tags[] = array("keyword" => ucfirst($tag->keyword),"data" => $tag->Convert($this));
		}
		if ($element->type == 'packagepage') return;
		$sdesc = '';
		$desc = '';
		if ($element->type != 'page')
		{
			if ($element->docblock->sdesc)
			{
				$sdesc = $element->docblock->sdesc->Convert($this);
			}
			if ($element->docblock->desc)
			{
				$desc = '    '.$element->docblock->desc->Convert($this);
                // make nicely formatted paragraphs
                $desc = str_replace("\n\n","<##P##>",$desc);
                $desc = str_replace("\n",' ',$desc);
                $desc = str_replace("<\li>","\n",$desc);
			}
			if ($element->type != 'var' && $element->type != 'method')
			{
				$this->pdf->addDestination(urlencode($element->type.$element->docblock->package.$element->name),'FitH',$this->pdf->y);
			} else
			{
				$this->pdf->addDestination(urlencode($element->type.$element->docblock->package.$element->class.'::'.$element->name),'FitH',$this->pdf->y);
			}
		} else
		{
			if ($element->docblock->sdesc)
			{
				$sdesc = $element->docblock->sdesc->Convert($this);
			}
			if ($element->docblock->desc)
			{
				$desc = '    '.$element->docblock->desc->Convert($this);
                // make nicely formatted paragraphs
                $desc = str_replace("\n\n","<##P##>",$desc);
                $desc = str_replace("\n",' ',$desc);
                $desc = str_replace("<\li>","\n",$desc);
			}
			$this->pdf->addDestination(urlencode('page'.$element->parent->package.$element->parent->getPath()),'FitH',$this->pdf->y);
		}
		$this->convertParams($element);
		$this->pdf->ezText("<b>Summary: $sdesc</b>\n",12,array('justification'=>'full'));
		$this->pdf->ezText("$desc\n",12,array('justification'=>'full'));
		foreach($tags as $tag)
		{
			$this->pdf->ezText("<b>* ".$tag['keyword']."</b> ".$tag['data']."\n",10,array('left' => 15));
		}
	}
	
	function convertParams(&$element)
	{
		if ($element->type != 'function' && $element->type != 'method') return;
		if (count($element->docblock->params))
		{
			$this->pdf->ezText("<b>Function Parameters:</b>\n",13,array('left' => 15));
			foreach($element->docblock->params as $param => $val)
			{
				$a = $val->Convert($this);
				$this->pdf->ezText("<b>*</b> <i>".$val->converted_returnType."</i> <b>".ucfirst($param)."</b> $a\n",11,array('left' => 20));
			}
		}
	}
	
	function convertGlobal(&$element)
	{
        $sdesc = '';
        if ($element->docblock->sdesc)
        {
            $sdesc = $element->docblock->sdesc->Convert($this);
        }
		$this->pdf->ezText("     Global Variable <i>".$element->type."</i> ".$element->name." = ".$this->getGlobalValue($element->getValue())."<C:rf:3".rawurlencode("     global variable ".$element->name)."><C:index:".rawurlencode($element->name.'|||'.$sdesc).">",14,array('justification'=>'left'));
		$this->convertDocBlock($element);
	}
	
	function convertMethod(&$element)
	{
        $sdesc = '';
        if ($element->docblock->sdesc)
        {
            $sdesc = $element->docblock->sdesc->Convert($this);
        }
		if (!$element->docblock->return->returnType) $element->docblock->return->returnType = 'void';
		$this->pdf->ezText("     Method ".$element->getFunctionCall()."<C:rf:3".rawurlencode("     Method ".$element->name)."><C:index:".rawurlencode($element->name.'|||'.$sdesc).">",14,array('justification'=>'left'));
		$this->convertDocBlock($element);
	}
	
	function convertVar(&$element)
	{
        $sdesc = '';
        if ($element->docblock->sdesc)
        {
            $sdesc = $element->docblock->sdesc->Convert($this);
        }
		$this->pdf->ezText("     <i>".$element->docblock->var->returnType."</i> ".$element->name." = ".$element->value."<C:rf:3".rawurlencode("     Var ".$element->name)."><C:index:".rawurlencode($element->name.'|||'.$sdesc).">",14,array('justification'=>'left'));
		$this->convertDocBlock($element);
	}
	
	function convertClass(&$element)
	{
		if ($this->curclasspackage != $element->docblock->package)
		{
			$this->classpackage_pagenums[$this->curclasspackage] = $this->pdf->ezGetCurrentPageNumber();
			if (isset($this->classpackage_pagenums[$element->docblock->package]))
			{
				$this->pdf->ezInsertMode(1,$this->classpackage_pagenums[$element->docblock->package],'after');
				$this->pdf->ezNewPage();
			} else
			{
				$this->pdf->ezInsertMode(0);
				$this->pdf->ezNewPage();
                if (isset($this->package_pages[$element->docblock->package]))
                {
                    $this->pdf->ezText("Package ".$element->docblock->package."<C:rf:1".rawurlencode("Package ".$element->docblock->package).">\n\n\n",26,array('justification'=>'centre'));
                    $this->pdf->ezText($this->package_pages[$element->docblock->package],12);
                    unset($this->package_pages[$element->docblock->package]);
                }
				$this->pdf->ezText("Package ".$element->docblock->package." Classes<C:rf:1".rawurlencode("Package ".$element->docblock->package." Classes").">\n\n\n",26,array('justification'=>'centre'));
			}
		}
        $sdesc = '';
        if ($element->docblock->sdesc)
        {
            $sdesc = $element->docblock->sdesc->Convert($this);
        }
		$this->curclasspackage = $element->docblock->package;
		$this->pdf->ezText("Class ".$element->name."<C:rf:2".rawurlencode("Class ".$element->name)."><C:index:".rawurlencode($element->name.'|||'.$sdesc).">",18,array('justification'=>'centre'));
		$this->convertDocBlock($element);
	}
	
	function convertInclude(&$element)
	{
		$this->pdf->ezText("<b>".$element->name."(".$this->getIncludeValue($element->value).")</b>\n");
		$this->convertDocBlock($element);
	}
	
	function convertFunction(&$element)
	{
        $sdesc = '';
        if ($element->docblock->sdesc)
        {
            $sdesc = $element->docblock->sdesc->Convert($this);
        }
		if (!$element->docblock->return->returnType) $element->docblock->return->returnType = 'void';
		$this->pdf->ezText("     Function <i>".$element->docblock->return->returnType."</i> ".$element->getFunctionCall()."<C:rf:3".rawurlencode("     Function ".$element->name)."><C:index:".rawurlencode($element->name.'|||'.$sdesc).">",14,array('justification'=>'left'));
		$this->convertDocBlock($element);
	}
	
	function convertDefine(&$element)
	{
        $sdesc = '';
        if ($element->docblock->sdesc)
        {
            $sdesc = $element->docblock->sdesc->Convert($this);
        }
		$this->pdf->ezText("     Define ".$element->name." = ".$element->value."<C:rf:3".rawurlencode("     Define ".$element->name)."><C:index:".rawurlencode($element->name.'|||'.$sdesc).">",14,array('justification'=>'left'));
		$this->convertDocBlock($element);
	}
	
	function convertPage(&$element)
	{
		if ($this->curpagepackage != $element->parent->package)
		{
			$this->pagepackage_pagenums[$this->curpagepackage] = $this->pdf->ezGetCurrentPageNumber();
			if (isset($this->pagepackage_pagenums[$element->parent->package]))
			{
				$this->pdf->ezInsertMode(1,$this->pagepackage_pagenums[$element->parent->package],'after');
				$this->pdf->ezNewPage();
			} else
			{
				$this->pdf->ezInsertMode(0);
				$this->pdf->ezNewPage();
                if (isset($this->package_pages[$element->parent->package]))
                {
                    $this->pdf->ezText("Package ".$element->parent->package."<C:rf:1".rawurlencode("Package ".$element->parent->package).">\n\n\n",26,array('justification'=>'centre'));
                    $this->pdf->ezText($this->package_pages[$element->parent->package],12);
                    unset($this->package_pages[$element->parent->package]);
                }
                $this->pdf->ezText("Package ".$element->parent->package." Procedural Elements<C:rf:1".rawurlencode("Package ".$element->parent->package." Procedural Elements").">\n\n\n",26,array('justification'=>'centre'));
			}
		}
        $sdesc = '';
        if ($element->docblock->sdesc)
        {
            $sdesc = $element->docblock->sdesc->Convert($this);
        }
		$this->curpagepackage = $element->parent->package;
		$this->pdf->ezText($element->parent->file."<C:rf:2".rawurlencode($element->parent->file)."><C:index:".rawurlencode($element->parent->file.'|||'.$sdesc).">",18,array('justification'=>'centre'));
		$this->convertDocBlock($element);
	}
	
	function convertPackagePage(&$element)
	{
		$x = $element->Convert($this);
		$x = substr($x,strpos($x,'<body'));
		$this->package_pages[$element->package] = trim(substr($x,strpos($x,'>') + 1,strpos($x,'</body>') - 6));
	}
	
	/**
	* returns a template-enabled array of class trees
	* 
	* @param	string	$package	package to generate a class tree for
	* @see $roots, getRootTree()
	*/
	function generateFormattedClassTrees($package)
	{
		$this->local = false;
		if (!isset($this->roots[$package])) return array();
		$roots = $trees = array();
		$roots = $this->roots[$package];
		for($i=0;$i<count($roots);$i++)
		{
			$trees[] = array('class' => $roots[$i],'class_tree' => "<ul>\n".$this->getRootTree($this->getSortedClassTreeFromClass($roots[$i],$package,''),$package)."</ul>\n");
		}
		$this->local = true;
		return $trees;
	}
	
	/**
	* return formatted class tree for the Class Trees page
	*
	* @param array $tree output from {@link getSortedClassTreeFromClass()}
	* @see Classes::$definitechild, generateFormattedClassTrees()
	* @return string
	*/
	function getRootTree($tree,$package)
	{
		if (!$tree) return '';
		$my_tree = '';
		$cur = '#root';
		$lastcur = array(false);
		$kids = array();
		$dopar = false;
		if ($tree[$cur]['parent'])
		{
			$dopar = true;
			if (!is_object($tree[$cur]['parent']))
			{
//				debug("parent ".$tree[$cur]['parent']." not found");
				$my_tree .= '<li>' . $tree[$cur]['parent'] .'<ul>';
			}
			else
			{
//						debug("parent ".$this->returnSee($tree[$cur]['parent'], false, false)." in other package");
				$my_tree .= '<li>' . $this->returnSee($tree[$cur]['parent'], false, false);
				if ($tree[$cur]['parent']->package != $package) $my_tree .= ' <b>(Different package)</b><ul>';
			}
		}
		do
		{
//			fancy_debug($cur,$lastcur,$kids);
			if (count($tree[$cur]['children']))
			{
//				debug("$cur has children");
				if (!isset($kids[$cur]))
				{
//					debug("set $cur kids");
					$kids[$cur] = 1;
					$my_tree .= '<li>'.$this->returnSee($tree[$cur]['link'], false, false);
					$my_tree .= '<ul>'."\n";
				}
				array_push($lastcur,$cur);
				list(,$cur) = each($tree[$cur]['children']);
//				var_dump('listed',$cur);
				if ($cur)
				{
					$cur = $cur['package'] . '#' . $cur['class'];
//					debug("set cur to child $cur");
//					$my_tree .= '<li>'.$this->returnSee($tree[$cur]['link'], false, false);
					continue;
				} else
				{
//					debug("end of children for $cur");
					$cur = array_pop($lastcur);
					$cur = array_pop($lastcur);
					$my_tree .= '</ul></li>'."\n";
					if ($dopar && ($cur == '#root' || !$cur)) $my_tree .= '</ul></li>';
				}
			} else 
			{
//				debug("$cur has no children");
				$my_tree .= '<li>'.$this->returnSee($tree[$cur]['link'], false, false)."</li>";
				if ($dopar && $cur == '#root') $my_tree .= '</ul></li>';
				$cur = array_pop($lastcur);
			}
		} while ($cur);
		return $my_tree;
	}
	
	/**
	* calls {@link Cezpdf::ezOutput()} and writes documentation.pdf to targetDir
	*/
	function Output($title = 'Generated Documentation')
	{
        phpdoc_out("Generating PDF file..");
        flush();
        $this->pdf->ezNewPage();
        $this->pdf->ezText("<C:rf:1Appendices>");
        $this->pdf->ezText("Appendices\n",26,array('justification'=>'centre'));
        $this->pdf->ezNewPage();
        $this->pdf->ezText("<C:rf:2Appendix A - Class Trees>");
        $this->pdf->ezText("Appendix A - Class Trees\n",26,array('justification'=>'centre'));
		foreach($this->all_packages as $package => $rest)
		{
			if (!isset($this->pkg_elements[$package])) continue;
            phpdoc_out('.');
            flush();
            $this->pdf->ezText("<C:rf:3$package>");
            $this->pdf->ezText("Package $package\n",16,array('justification'=>'centre'));
            $trees = $this->generateFormattedClassTrees($package);
    		$templ = new Smarty;
    		$templ->template_dir = $this->smarty_dir . PATH_DELIMITER . 'templates';
    		$templ->compile_dir = $this->smarty_dir . PATH_DELIMITER . 'templates_c';
    		$templ->config_dir = $this->smarty_dir . PATH_DELIMITER . 'configs';
            $templ->assign("trees",$trees);
            $this->pdf->ezText($templ->fetch('classtree.tpl'),12);
        }
        $this->pdf->ezNewPage();
        $this->pdf->ezText("<C:rf:1Index>");
        phpdoc_out('.');
        flush();
		$this->pdf->ezStopPageNumbers(1,1);
        $this->pdf->ezText("Index\n",26,array('justification'=>'centre'));
		uksort($this->pdf->indexContents,'strnatcasecmp');
		$xpos = 520;
        $z = 0;
        foreach($this->pdf->indexContents as $letter => $contents)
        {
            if ($z++/50 == 0) {phpdoc_out('.');flush();}
    		uksort($this->pdf->indexContents[$letter],array($this,'mystrnatcasecmp'));
            $this->pdf->ezText("<C:IndexLetter:$letter>");
            foreach($contents as $k => $v)
            {
				$y=$this->pdf->ezText('<c:ilink:toc'.$v[3].'>'.$v[0].'</c:ilink><C:dots:4'.$v[2].'>',11,array('aright'=>$xpos));
                if (strlen($v[1]))
                $this->pdf->ezText('<i>'.$v[1].'</i>',11,array('left'=>50));
            }
        }
		
		$this->pdf->ezInsertMode(1,1,'after');
		$this->pdf->ezNewPage();
		$this->pdf->ezText("Contents\n",26,array('justification'=>'centre'));
		$contents = $this->pdf->reportContents;
		foreach($contents as $k => $v)
		{
			switch ($v[2])
			{
				case '1':
					$y=$this->pdf->ezText('<c:ilink:toc'.$k.'>'.$v[0].'</c:ilink><C:dots:3'.$v[1].'>',16,array('aright'=>$xpos));
				break;
				case '2':
					$this->pdf->ezText('<c:ilink:toc'.$k.'>'.$v[0].'</c:ilink><C:dots:3'.$v[1].'>',12,array('left'=>50,'aright'=>$xpos));
				break;
				case '3':
					$this->pdf->ezText('<c:ilink:toc'.$k.'>'.$v[0].'</c:ilink><C:dots:3'.$v[1].'>',12,array('left'=>60,'aright'=>$xpos));
				break;
			}
		}
		$x = $this->pdf->ezOutput();
        phpdoc_out("done\n");
        flush();
		$this->writeFile("documentation.pdf",$x);
	}
    
    function mystrnatcasecmp($a,$b)
    {
        return strnatcasecmp($a[0],$b[0]);
    }
	
	
	/**
	* @param string name of class
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @return mixed false if not found, or an html a link to the class's documentation
	* @see parent::getClassLink()
	*/
	function getClassLink($expr,$package, $file = false,$text = false)
	{
		$a = Converter::getClassLink($expr,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text);
	}

	/**
	* @param string name of function
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @return mixed false if not found, or an html a link to the function's documentation
	* @see parent::getFunctionLink()
	*/
	function getFunctionLink($expr,$package, $file = false,$text = false)
	{
		$a = Converter::getFunctionLink($expr,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text);
	}

	/**
	* @param string name of define
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @return mixed false if not found, or an html a link to the define's documentation
	* @see parent::getDefineLink()
	*/
	function getDefineLink($expr,$package, $file = false,$text = false)
	{
		$a = Converter::getDefineLink($expr,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text);
	}

	/**
	* @param string name of global variable
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @return mixed false if not found, or an html a link to the global variable's documentation
	* @see parent::getGlobalLink()
	*/
	function getGlobalLink($expr,$package, $file = false,$text = false)
	{
		$a = Converter::getGlobalLink($expr,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text);
	}

	/**
	* @param string name of procedural page
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @return mixed false if not found, or an html a link to the procedural page's documentation
	* @see parent::getPageLink()
	*/
	function getPageLink($expr,$package, $path = false,$text = false)
	{
		$a = Converter::getPageLink($expr,$package,$path);
		if (!$a) return false;
		return $this->returnSee($a, $text);
	}

	/**
	* @param string name of method
	* @param string class containing method
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @return mixed false if not found, or an html a link to the method's documentation
	* @see parent::getMethodLink()
	*/
	function getMethodLink($expr,$class,$package, $file = false,$text = false)
	{
		$a = Converter::getMethodLink($expr,$class,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text);
	}

	/**
	* @param string name of var
	* @param string class containing var
	* @param string package name
	* @param string full path to look in (used in index generation)
	* @param boolean deprecated
	* @param boolean return just the URL, or enclose it in an html a tag
	* @return mixed false if not found, or an html a link to the var's documentation
	* @see parent::getVarLink()
	*/
	function getVarLink($expr,$class,$package, $file = false,$text = false)
	{
		$a = Converter::getVarLink($expr,$class,$package,$file);
		if (!$a) return false;
		return $this->returnSee($a, $text);
	}

	function setTemplateDir($dir)
	{
		Converter::setTemplateDir($dir);
		$this->smarty_dir = $this->templateDir;
	}
	
	/** @return 1 always the same */
	function getState()
	{
		return 1;
	}
}
?>