<?php
//===================================================================================================
// this is the php file which creates the readme.pdf file, this is not seriously 
// suggested as a good way to create such a file, nor a great example of prose,
// but hopefully it will be useful
//
// adding ?d=1 to the url calling this will cause the pdf code itself to ve echoed to the 
// browser, this is quite useful for debugging purposes.
// there is no option to save directly to a file here, but this would be trivial to implement.
//
// note that this file comprisises both the demo code, and the generator of the pdf documentation
//
//===================================================================================================


include 'class.ezpdf.php';

// define a class extension to allow the use of a callback to get the table of contents, and to put the dots in the toc
class phpdocpdf extends Cezpdf
{
	var $reportContents = array();
    var $indexContents = array();
    var $indents = array();

	function rf($info)
	{
		$tmp = $info['p'];
		$lvl = $tmp[0];
		$lbl = rawurldecode(substr($tmp,1));
		$num=$this->ezWhatPageNumber($this->ezGetCurrentPageNumber());
		$this->reportContents[] = array($lbl,$num,$lvl );
        $this->addDestination('toc'.(count($this->reportContents)-1),'FitH',$info['y']+$info['height']);
	}
    
    function index($info)
    {
        $res = explode('|||',rawurldecode($info['p']));
        $name = $res[0];
        $descrip = $res[1];
        $letter = $name[0];
        if ($letter == '$') $letter = $name[1];
        $this->indexContents[strtoupper($letter)][] = array($name,$descrip,$this->ezWhatPageNumber($this->ezGetCurrentPageNumber()),count($this->reportContents) - 1);
    }
    
    function IndexLetter($info)
    {
        $letter = $info['p'];
        $this->transaction('start');
        $ok=0;
        while (!$ok){
          $thisPageNum = $this->ezPageCount;
          $this->saveState();
          $this->setColor(0.9,0.9,0.9);
          $this->filledRectangle($this->ez['leftMargin'],$this->y-$this->getFontHeight(18)+$this->getFontDecender(18),$this->ez['pageWidth']-$this->ez['leftMargin']-$this->ez['rightMargin'],$this->getFontHeight(18));
          $this->restoreState();
          $this->ezText($letter,18,array('justification'=>'left'));
          if ($this->ezPageCount==$thisPageNum){
            $this->transaction('commit');
            $ok=1;
          } else {
            // then we have moved onto a new page, bad bad, as the background colour will be on the old one
            $this->transaction('rewind');
            $this->ezNewPage();
          }
        }
    }

	function dots($info)
	{
		// draw a dotted line over to the right and put on a page number
		$tmp = $info['p'];
		$lvl = $tmp[0];
		$lbl = substr($tmp,1);
		$xpos = 520;
		
		switch($lvl)
		{
			case '1':
				$size=16;
				$thick=1;
			break;
			case '2':
				$size=14;
				$thick=1;
			break;
			case '3':
				$size=12;
				$thick=1;
			break;
            case '4':
                $size=11;
                $thick=1;
            break;
		}
		
		$adjust = 0;
		if ($size != 16) $adjust = 1;
		$this->saveState();
		$this->setLineStyle($thick,'round','',array(0,10));
		$this->line($xpos - (5*$adjust),$info['y'],$info['x']+5,$info['y']);
		$this->restoreState();
		$this->addText($xpos - (5*$adjust)+5,$info['y'],$size,$lbl);
	}
	
	function ezText($text,$size=0,$options=array(),$test=0)
	{
		$text = str_replace("\t","   ",$text);
        // paragraph breaks
        $text = str_replace("<##P##>","\n    ",$text);
		$text = str_replace("<<c:i",'< <c:i',$text);
		$text = str_replace("ilink>>","ilink> >",$text);
		Cezpdf::ezText($text,$size,$options,$test);
	}
    
    function ezProcessText($text){
      // this function will intially be used to implement underlining support, but could be used for a range of other
      // purposes
      $text = parent::ezProcessText($text);
      $text = str_replace(array('<UL>','</UL>','<LI>','</LI>','<OL>','</OL>','<ol>','</ol>'),
                          array('<ul>','</ul>','<li>','</li>','<ul>','</ul>','<ul>','</ul>'),$text);
      $text = str_replace("\n<ul>","<ul>",$text);
      $text = str_replace("<ul>\n","<ul>",$text);
      $text = str_replace("\n<li>","<li>",$text);
      $text = str_replace("<li>\n","<li>",$text);
      $text = str_replace('</li></ul>','</ul>',$text);
      $search = array('<ul>','</ul>','<li>','</li>');
      $replace = array("<C:indent:20>\n","<C:indent:-20>",'<C:bullet:*>',"\n");
      return str_replace($search,$replace,$text);
    }
    
    function indent($info)
    {
        $this->ez['leftMargin']+=$info['p'];
    }
    
    function bullet($info)
    {
        $this->addText($info['x']-20,$info['y']-1,10,$info['p']);
    }
    
    function ezNewPage()
    {
        parent::ezNewPage();
        if (!isset($this->ez['pageNumbering']))
		$this->ezStartPageNumbers(500,28,10,'','',1);
    }
}
?>
