<?php
/**
* @package phpDocumentor
* @subpackage Errors
* @author Gregory Beaver <cellog@users.sourceforge.net>
* @version $Id: Errors.inc,v 1.38.2.1 2002/08/13 17:34:05 dviner Exp $
*/
/**
* warning triggered when inheritance could be from more than one class
*/
define("PDERROR_MULTIPLE_PARENT",1);
/**
* warning triggered when parent class doesn't exist
*/
define("PDERROR_PARENT_NOT_FOUND",2);
/**
* warning triggered when an {@inline tag} is not terminated (no } before the * / ending the comment)
*/
define("PDERROR_UNTERMINATED_INLINE_TAG",3);
/**
* warning triggered when inheritance could be from more than one class
*/
define("PDERROR_CLASS_EXISTS",4);
/**
* warning triggered when inheritance could be from more than one class
*/
define("PDERROR_INHERITANCE_CONFLICT",5);
/**
* warning triggered when a converter is passed to {@link IntermediateParser::addConverter()} that is not a class
*/
define("PDERROR_CONVERTER_NOT_FOUND",6);
/**
* warning triggered when a converter is passed to {@link IntermediateParser::addConverter()} that is not a class
*/
define("PDERROR_NO_CONVERTERS",7);
/**
* warning triggered when the arguments to @access are neither public nor private
*/
define("PDERROR_ACCESS_WRONG_PARAM",8);
/**
* warning triggered when there are multiple @access tags in a docblock
*/
define("PDERROR_MULTIPLE_ACCESS_TAGS",9);
/**
* warning triggered when there are multiple @return tags in a docblock
*/
define("PDERROR_MULTIPLE_RETURN_TAGS",10);
/**
* warning triggered when there are multiple @var tags in a docblock
*/
define("PDERROR_MULTIPLE_VAR_TAGS",11);
/**
* warning triggered when there are multiple @package tags in a docblock
*/
define("PDERROR_MULTIPLE_PACKAGE_TAGS",12);
/**
* warning triggered when there are multiple @subpackage tags in a docblock
*/
define("PDERROR_MULTIPLE_SUBPACKAGE_TAGS",13);
/**
* warning triggered when the package or subpackage name is illegal
*/
define("PDERROR_ILLEGAL_PACKAGENAME",14);
/**
* warning triggered when there a @package tag is used in a function, define, method, var or include
*/
define("PDERROR_OVERRIDDEN_PACKAGE_TAGS",15);
/**
* warning triggered when there a @subpackage tag is used in a function, define, method, var or include
*/
define("PDERROR_OVERRIDDEN_SUBPACKAGE_TAGS",16);
/**
* warning triggered when classes in the same package have the same name
*/
define("PDERROR_CLASS_CONFLICT",17);
/**
* warning triggered when classes in the same package have the same name
*/
define("PDERROR_UNKNOWN_TAG",18);
/**
* warning triggered when there are multiple @name tags in a docblock
*/
define("PDERROR_MULTIPLE_NAME_TAGS",19);
/**
* warning triggered when there are multiple @name tags in a docblock
*/
define("PDERROR_PACKAGEOUTPUT_DELETES_PARENT_FILE",20);
/**
* warning triggered when there are multiple @name tags in a docblock
*/
define("PDERROR_GLOBAL_NOT_FOUND",21);
/**
* warning triggered when there are multiple @name tags in a docblock
*/
define("PDERROR_MULTIPLE_GLOBAL_TAGS",22);
/**
* warning triggered when there are multiple @name tags in a docblock
*/
define("PDERROR_MALFORMED_GLOBAL_TAG",23);
/**
* warning triggered when an @ignore tag is used in a DocBlock preceding a method, variable, include, or global variable
*/
define("PDERROR_IGNORE_TAG_IGNORED",24);
/**
* warning triggered when a duplicate element is encountered that will be ignored by the documentor
*/
define("PDERROR_ELEMENT_IGNORED",25);
/**
* warning triggered when an entire page is ignored because of @access private
*/
define("PDERROR_PARSEPRIVATE",26);
/**
* warning triggered when an entire page is ignored because of @access private
*/
define("PDERROR_UNKNOWN_COMMANDLINE",27);
/**
* warning triggered when an entire page is ignored because of @access private
*/
define("PDERROR_NEED_WHITESPACE",28);
/**
* warning triggered when an entire page is ignored because of @access private
*/
define("PDERROR_CLASS_PARENT_NOT_FOUND",29);
/**
* warning triggered when a getClassByPackage is called and can't find the class
*/
define("PDERROR_CLASS_NOT_IN_PACKAGE",30);
/**
* warning triggered when a { @source } inline tag is used in a docblock not preceding a function
*/
define("PDERROR_SOURCE_TAG_FUNCTION_NOT_FOUND",30);

define("PDEXCEPTION_NOT_A_CLASS",1);
define("PDEXCEPTION_NOT_AN_ARRAY",2);
define("PDEXCEPTION_ELEMENT_NOT_PROCEDURAL_ELEMENT",3);
define("PDEXCEPTION_DEFINESBYFILE_NOT_SET",4);
define("PDEXCEPTION_GLOBALSBYFILE_NOT_SET",5);
define("PDEXCEPTION_INCLUDESBYFILE_NOT_SET",6);
define("PDEXCEPTION_FUNCTIONSBYFILE_NOT_SET",7);
define("PDEXCEPTION_ELEMENT_NOT_PARSERELEMENT",8);
define("PDEXCEPTION_NOT_A_PROCPAGEELEMENT",9);
define("PDEXCEPTION_NOT_A_CLASSELEMENT",10);
define("PDEXCEPTION_FILENOTFOUND_METHOD",11);
define("PDEXCEPTION_NOT_AN_ELEMENT",12);
define("PDEXCEPTION_NOT_A_PARSERDATA",13);
define("PDEXCEPTION_NOT_SET",14);
define("PDEXCEPTION_ROOT_THAT_AINT",15);
/**
* Error messages for phpDocumentor parser warnings
* @global array $GLOBALS['phpDocumentor_warning_descrip']
* @name $phpDocumentor_warning_descrip
*/
$GLOBALS['phpDocumentor_warning_descrip'] =
	array(
		PDERROR_MULTIPLE_PARENT => 'Class %s has multiple possible parents, package inheritance aborted',
		PDERROR_PARENT_NOT_FOUND => 'Class %s parent %s not found',
		PDERROR_INHERITANCE_CONFLICT => 'Class %s in file %s has multiple possible parents named %s.  Cannot resolve name conflict,'."\n".' try ignoring a file that contains the conflicting parent class',
		PDERROR_UNKNOWN_TAG => 'Unknown tag "@%s" used',
		PDERROR_IGNORE_TAG_IGNORED => '@ignore tag used for %s element "%s" will be ignored',
		PDERROR_ELEMENT_IGNORED => "\n".'duplicate %s element "%s" in file %s will be ignored.'."\n".'Use an @ignore tag on the original if you want this case to be documented.',
		PDERROR_PARSEPRIVATE => "entire page %s ignored because of @access private.\nChoose -pp to enable parsing of private elements",
		PDERROR_CLASS_PARENT_NOT_FOUND => "class %s in package %s parent not found in @see parent::%s",
		PDERROR_CLASS_NOT_IN_PACKAGE => "class %s was not found in package %s");



//********************************************************



/**
* Error messages for phpDocumentor parser errors
* @global array $GLOBALS['phpDocumentor_error_descrip']
* @name $phpDocumentor_error_descrip
*/
$GLOBALS['phpDocumentor_error_descrip'] = 
	array(
		PDERROR_UNTERMINATED_INLINE_TAG => 'Inline tag {@%s} in tag %s is unterminated, "%s"',
		PDERROR_CLASS_EXISTS => 'Class %s already exists in package "%s"',
		PDERROR_CONVERTER_NOT_FOUND => 'Converter %s specified by --output command-line option is not a class',
		PDERROR_NO_CONVERTERS => 'No Converters have been specified by --output command-line option',
		PDERROR_ACCESS_WRONG_PARAM => '@access was passed neither "public" nor "private."  Was passed: "%s"',
		PDERROR_MULTIPLE_ACCESS_TAGS => 'DocBlock has multiple @access tags, illegal. ignoring additional tag "@access %s"',
		PDERROR_MULTIPLE_RETURN_TAGS => 'DocBlock has multiple @return tags, illegal. ignoring additional tag "@return %s %s"',
		PDERROR_MULTIPLE_VAR_TAGS => 'DocBlock has multiple @var tags, illegal. ignoring additional tag "@var %s %s"',
		PDERROR_MULTIPLE_PACKAGE_TAGS => 'DocBlock has multiple @package tags, illegal. ignoring additional tag "@package %s"',
		PDERROR_MULTIPLE_SUBPACKAGE_TAGS => 'DocBlock has multiple @subpackage tags, illegal. ignoring additional tag "@subpackage %s"',
		PDERROR_ILLEGAL_PACKAGENAME => '@%s tag has illegal %s name "%s"',
		PDERROR_OVERRIDDEN_PACKAGE_TAGS => '%s %s\'s DocBlock has @package tag, illegal. ignoring tag "@package %s"',
		PDERROR_OVERRIDDEN_SUBPACKAGE_TAGS => '"%s" %s\'s DocBlock has @subpackage tags, illegal. ignoring tag "@subpackage %s"',
		PDERROR_CLASS_CONFLICT => 'class "%s" has multiple declarations in package %s, in file %s and file %s, documentation will have output errors!',
		PDERROR_MULTIPLE_NAME_TAGS => 'DocBlock has multiple @name tags, illegal. ignoring additional tag "@name %s"',
		PDERROR_PACKAGEOUTPUT_DELETES_PARENT_FILE => '-po (packageoutput) option deletes parent file "%s" containing class "%s."'."\n".'  Try using --defaultpackagename (-dn) %s to include the parent file in the same package as the class',
		PDERROR_GLOBAL_NOT_FOUND => 'global variable %s specified in @global tag was never found',
		PDERROR_MULTIPLE_GLOBAL_TAGS => '@global define tag already used for global variable "%s", ignoring @global %s',
		PDERROR_MALFORMED_GLOBAL_TAG => 'incorrect @global syntax.  Should be @global vartype $varname or @global vartype description',
		PDERROR_UNKNOWN_COMMANDLINE => 'Unknown command-line option "%s" encountered, use phpdoc -h for help',
		PDERROR_NEED_WHITESPACE => 'phpDocumentor programmer error - wordparser whitespace set to false in handleDocBlock, notify developers.  You should never see this error',
		PDERROR_SOURCE_TAG_FUNCTION_NOT_FOUND => '{@source} tag used in a docblock that isn\'t preceding a function',
		);


/**
* Error messages for phpDocumentor exceptions, i.e. bugs in phpDocumentor that violate expected input data
* @global array $GLOBALS['phpDocumentor_exception_descrip']
* @name $phpDocumentor_exception_descrip
*/
$GLOBALS['phpDocumentor_exception_descrip'] =
	array(
		PDEXCEPTION_NOT_A_CLASS => 'variable is not a class and should be',
		PDEXCEPTION_NOT_AN_ARRAY => 'variable is not an array and should be',
		PDEXCEPTION_ELEMENT_NOT_PROCEDURAL_ELEMENT => 'in ProceduralPages::replaceElement, $element is not a procedural element',
		PDEXCEPTION_DEFINESBYFILE_NOT_SET => 'definesbyfile elements is not set and is expected to be set',
		PDEXCEPTION_GLOBALSBYFILE_NOT_SET => 'globalsbyfile elements is not set and is expected to be set',
		PDEXCEPTION_INCLUDESBYFILE_NOT_SET => 'includesbyfile elements is not set and is expected to be set',
		PDEXCEPTION_FUNCTIONSBYFILE_NOT_SET => 'functionsbyfile elements is not set and is expected to be set',
		PDEXCEPTION_ELEMENT_NOT_PARSERELEMENT => 'element must be a descendant of parserElement or parserPage, and isn\'t',
		PDEXCEPTION_NOT_A_PROCPAGEELEMENT => 'element must be a procedural page element, and isn\'t',
		PDEXCEPTION_NOT_A_CLASSELEMENT => 'element must be a class element, and isn\'t',
		PDEXCEPTION_FILENOTFOUND_METHOD => 'rare encounter of bug 564174, no linkswithfile for file in Converter::get*Link()',
		PDEXCEPTION_NOT_AN_ELEMENT => 'class was not a subclass of parserElement, and should be',
		PDEXCEPTION_NOT_A_PARSERDATA => 'class is not a parserData and should be',
		PDEXCEPTION_NOT_SET => 'variable is not set, and should be',
		PDEXCEPTION_ROOT_THAT_AINT => 'root that isn\'t a root!',
		);
/**
* encapsulates warning information
* @package phpDocumentor
* @subpackage Errors
*/
class RecordWarning
{
	/**
	* name of global variable that descriptors for this warning/error is kept
	* @var string
	*/
	var $type = 'phpDocumentor_warning_descrip';
	/**
	* file this error occurred in
	* @var string
	*/
	var $file = false;
	/**
	* line number of the file this error occurred in
	* @var integer
	*/
	var $linenum;
	/**
	* error string
	* @var string
	*/
	var $data;
	/**
	* error number
	* @see Errors.inc
	* @var string
	*/
	var $num;
	/**
	* @param string $file filename this error occurred in ({@link $file})
	* @param integer $linenum line number this error occurred on ({@link $linenum})
	* @param integer $num Error number defined in {@link Errors.inc}
	* @param string $data... variable number of strings, up to 4, to sprintf based on the error number
	*/
	function RecordWarning($file,$linenum,$num)
	{
		$this->file = $file;
		$this->linenum = $linenum;
		$a = array('','','','');
		if (func_num_args()>3)
		{
			for($i=3;$i<func_num_args();$i++)
			{
				$a[$i - 3] = func_get_arg($i);
			}
		}

		$this->num = $num;
		$this->data = sprintf($GLOBALS[$this->type][$this->num],$a[0],$a[1],$a[2],$a[3]);
		$this->output();
	}
	
	/**
	* prints the warning
	*/
	function output($string = false)
	{
		if ($string)
		{
			if ($this->file)
			return "WARNING in $this->file on line $this->linenum: $this->data\n";
			else
			return "WARNING: $this->data\n";
		}
		if ($this->file)
		phpdoc_out("WARNING in $this->file on line $this->linenum: $this->data\n");
		else
		phpdoc_out("WARNING: $this->data\n");
	}
}

/**
* encapsulates error information
* @package phpDocumentor
* @subpackage Errors
*/
class RecordError extends RecordWarning
{
	/**
	* name of global variable that descriptors for this warning/error is kept
	* @var string
	*/
	var $type = 'phpDocumentor_error_descrip';

	/**
	* prints the error
	*/
	function output($string = false)
	{
		if ($string)
		{
			if ($this->file)
			return "\n\tERROR in $this->file on line $this->linenum: $this->data\n";
			else
			return "\n\tERROR: $this->data\n";
		}
		if ($this->file)
		phpdoc_out("\n\tERROR in $this->file on line $this->linenum: $this->data\n");
		else
		phpdoc_out("\n\tERROR: $this->data\n");
	}
}

class RecordException extends RecordError
{
	/**
	* name of global variable that descriptors for this warning/error is kept
	* @var string
	*/
	var $type = 'phpDocumentor_exception_descrip';
	
	var $info = '';
	
	function output($string = false)
	{
		
		RecordError::output($string);
		$data = $this->data . $this->info;
		$this->writeException($data);
		die();
	}
	
	/**
	* writes information needed to debug a phpDocumentor exception.
	* An exception is distinguished from an error or warning in that a bug in phpDocumentor raises an exception, rather than a mistake
	* in the DocBlock or files parsed.  Exception output log is very useful in helping us to debug phpDocumentor bugs
	* @global array	we use the target attribute to write the exception log to the target directory
	*/
	function writeException($data)
	{
		global $setting;
		$fp = fopen($setting['target']  . PATH_DELIMITER . "phpdoc_exceptions.log","w");
		set_file_buffer( $fp, 0 );
		fwrite($fp,$data,strlen($data));
		fclose($fp);
	}

	/**
	* @param string $file filename this error occurred in ({@link $file})
	* @param integer $linenum line number this error occurred on ({@link $linenum})
	* @param integer $num Exception number defined in {@link Errors.inc}
	* @param array $data array of variables to var_dump
	* @global array	we use the target attribute to tell the user where phpdoc_exceptions.log is located
	*/
	function RecordException($num,$file,$linenum,$data = false)
	{
		global $setting;
		$this->file = $file;
		$this->linenum = $linenum;
		$this->num = $num;
		$this->data = "Exception $num in file $file on line $linenum:\n";
		$this->data .= $GLOBALS[$this->type][$this->num]."\n";
		$this->data .= "Please email the phpdoc_exceptions.log file created in " .$setting['target']  . PATH_DELIMITER . "phpdoc_exceptions.log to jeichorn@phpdoc.org\n";
		ob_start();
		if ($data)
		{
			foreach($data as $bug) var_dump($bug);
		}
		$this->info = ob_get_contents();
		ob_end_clean();
		$this->output();
	}
	
}

/**
* contains all the errors/warnings
* @see $errors, $warnings
* @package phpDocumentor
* @subpackage Errors
*/
class ErrorTracker
{
	/**
	* array of {@link RecordError}s
	* @var array
	*/
	var $errors = array();
	/**
	* array of {@link RecordWarning}s
	* @var array
	*/
	var $warnings = array();
	/**
	* @var string
	*/
	var $curfile = '';
	/**
	* @var integer
	*/
	var $linenum = 0;
	
	var $lasterror = false;
	
	var $lastwarning = false;
	
	/**
	* This function subscribes to two events in the Parser in order to keep track of line number information and file name.
	* @param integer $num parser-passed event (see {@link PHPDOC_EVENT_NEWLINENUM, PHPDOC_EVENT_NEWFILE})
	* @param mixed $data either a line number if $num is PHPDOC_EVENT_NEWLINENUM or a file name if $num is PHPDOC_EVENT_NEWFILE
	*/
	function handleEvent($num,$data)
	{
		switch($num)
		{
			case PHPDOC_EVENT_NEWLINENUM :
				$this->linenum = $data;
			break;
			case PHPDOC_EVENT_NEWFILE :
				$this->linenum = 0;
				$this->curfile = $data;
			break;
			// debugging
			case 1000000635 :
				phpdoc_out($this->curfile.' has '.$this->linenum.' lines'."\n");
			break;
		}
	}

	/**
	* add a new warning to the {@link $warnings} array
	* @param integer $num error number from {@link Errors.inc}
	* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
	*/
	function addWarning($num)
	{
		$a = array('','','','');
		if (func_num_args()>1)
		{
			for($i=1;$i<func_num_args();$i++)
			{
				$a[$i - 1] = func_get_arg($i);
			}
		}
		$this->warnings[] = new RecordWarning($this->curfile,$this->linenum,$num,$a[0],$a[1],$a[2],$a[3]);
		$this->lastwarning = count($this->warnings) - 1;
	}

	/**
	* add a new error to the {@link $errors} array
	* @param integer $num error number from {@link Errors.inc}
	* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
	*/
	function addError($num)
	{
		$a = array('','','','');
		if (func_num_args()>1)
		{
			for($i=1;$i<func_num_args();$i++)
			{
				$a[$i - 1] = func_get_arg($i);
			}
		}
		$this->errors[] = new RecordError($this->curfile,$this->linenum,$num,$a[0],$a[1],$a[2],$a[3]);
		$this->lasterror = count($this->errors) - 1;
	}
	
	/**
	* add a new error to the {@link $errors} array and returns the error string
	* @param integer $num error number from {@link Errors.inc}
	* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
	*/
	function addErrorReturn($num)
	{
		$a = array('','','','');
		if (func_num_args()>1)
		{
			for($i=1;$i<func_num_args();$i++)
			{
				$a[$i - 1] = func_get_arg($i);
			}
		}
		$this->errors[] = new RecordError($this->curfile,$this->linenum,$num,$a[0],$a[1],$a[2],$a[3],false);
		$this->lasterror = count($this->errors) - 1;
	}
	
	function addException($num,$file,$line,$data = false)
	{
		$a = new RecordException($num,$file,$line,$data);
	}
	
	function &returnWarnings()
	{
		usort($this->warnings,array($this,"errorsort"));
		return $this->warnings;
	}
	
	function &returnErrors()
	{
		usort($this->errors,array($this,"errorsort"));
		return $this->errors;
	}
	
	function errorsort($a, $b)
	{
		if (!$a->file) return -1;
		if (!$b->file) return 1;
		if ($a->file == $b->file)
		{
			if ($a->linenum == $b->linenum) return 0;
			if ($a->linenum < $b->linenum) return -1;
			return 1;
		}
		return strnatcasecmp($a->file,$b->file);
	}
	
	function returnLastError()
	{
		return $this->errors[$this->lasterror]->output(true);
	}

	function returnLastWarning()
	{
		return $this->warnings[$this->lastwarning]->output(true);
	}
}

/**
* @global ErrorTracker $GLOBALS['phpDocumentor_errors']
* @name $phpDocumentor_errors
*/
$GLOBALS['phpDocumentor_errors'] = new ErrorTracker;

/**
* @param integer $num error number from {@link Errors.inc}
* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
* @see ErrorTracker::addError()
*/
function addError($num)
{
	global $phpDocumentor_errors;
	$a = array('','','','');
	if (func_num_args()>1)
	{
		for($i=1;$i<func_num_args();$i++)
		{
			$a[$i - 1] = func_get_arg($i);
		}
	}
	$phpDocumentor_errors->addError($num,$a[0],$a[1],$a[2],$a[3]);
}

/**
* like {@link addError()} but exits parsing
* @param integer $num error number from {@link Errors.inc}
* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
* @global ErrorTracker repository for all errors generated by phpDocumentor
* @see ErrorTracker::addError()
*/
function addErrorDie($num)
{
	global $phpDocumentor_errors;
	$a = array('','','','');
	if (func_num_args()>1)
	{
		for($i=1;$i<func_num_args();$i++)
		{
			$a[$i - 1] = func_get_arg($i);
		}
	}
	$phpDocumentor_errors->addErrorReturn($num,$a[0],$a[1],$a[2],$a[3]);
	die($phpDocumentor_errors->returnLastError());
}

/**
* @param boolean $test if true, an exception is thrown
* @param integer $num exception number from the global {@link $phpDocumentor_exception_descrip} array
* @param __FILE__ $file	this parameter must be the file that throws the exception
* @param __LINE__ $line this parameter must be the line number that throws the exception
* @see ErrorTracker::addException()
* @global ErrorTracker repository for all errors generated by phpDocumentor
*/
function addException($test,$num,$file,$line)
{
/*
	global $phpDocumentor_errors;
	if ($test)
	{
		$a = false;
		if (func_num_args() > 4)
		{
			$a = func_get_args();
			unset($a[0]);
			unset($a[1]);
			unset($a[2]);
			unset($a[3]);
		}
		$phpDocumentor_errors->addException($num,$file,$line,$a);
	}
*/
}

/**
* @param integer $num warning number from {@link Errors.inc}
* @param string $data... up to 4 string parameters to sprintf() into the error string for error number $num
* @global ErrorTracker repository for all errors generated by phpDocumentor
* @see ErrorTracker::addWarning()
*/
function addWarning($num)
{
	global $phpDocumentor_errors;
	$a = array('','','','');
	if (func_num_args()>1)
	{
		for($i=1;$i<func_num_args();$i++)
		{
			$a[$i - 1] = func_get_arg($i);
		}
	}

	$phpDocumentor_errors->addWarning($num,$a[0],$a[1],$a[2],$a[3]);
}
?>
