<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/**
* Class to handle file and user io opperations
*
* @author	Joshua Eichorn <jeichorn@phpdoc.org>
* @version	$Id: Io.inc,v 1.49.2.3 2002/10/31 18:18:07 jeichorn Exp $
* @package 	phpDocumentor
*/
/**
* Class to handle file and user io opperations
*
* @author	Joshua Eichorn <jeichorn@phpdoc.org>
* @version	$Id: Io.inc,v 1.49.2.3 2002/10/31 18:18:07 jeichorn Exp $
* @package 	phpDocumentor
*/
class Io 
{
	
	/** Holds all the options that are avaible to the cmd line interface
	 *  and to the different web interfaces
	 */
	var $phpDocOptions;
	
	var $ignore = false;

	/**
	 *  creates an array $this->phpDocOptions and sets program options in it
	 *  Array is in the format of:
	 *  [filename][tag][] = "f";
	 *  [filename][tag][] = "-file";
	 *  [filename][desc] "name of file to parse"
	 */
	function Io()
	{
		$this->phpDocOptions['filename']['tag'] = array( "-f", "--filename");
		$this->phpDocOptions['filename']['desc'] = "name of file(s) to parse ',' file1,file2.  Can contain complete path and * ? wildcards";
		$this->phpDocOptions['filename']['type'] = "path";

		$this->phpDocOptions['directory']['tag'] = array( "-d", "--directory");
		$this->phpDocOptions['directory']['desc'] = "name of a directory(s) to parse directory1,directory2";
		$this->phpDocOptions['directory']['type'] = "path";

		$this->phpDocOptions['target']['tag'] = array("-t", "--target");
		$this->phpDocOptions['target']['desc'] = "path where to save the generated files";
		$this->phpDocOptions['target']['type'] = "path";
		
		$this->phpDocOptions['ignore']['tag'] = array("-i", "--ignore");
		$this->phpDocOptions['ignore']['desc'] = "file(s) that will be ignored, multiple separated by ','.  Wildcards * and ? are ok";
		$this->phpDocOptions['ignore']['type'] = "path";

		$this->phpDocOptions['hidden']['tag'] = array("-dh", "--hidden");
		$this->phpDocOptions['hidden']['desc'] = "set equal to on (-dh on) to descend into hidden directories\n\t\t\t\t\t(directories starting with '.'), default is off";
		$this->phpDocOptions['hidden']['type'] = "value";

		$this->phpDocOptions['title']['tag'] = array("-ti","--title");
		$this->phpDocOptions['title']['desc'] = "title of generated documentation, default is 'Generated Documentation'";
		$this->phpDocOptions['title']['type'] = "value";

		$this->phpDocOptions['help']['tag'] = array("-h", "--help");
		$this->phpDocOptions['help']['desc'] = "	show this help message";

		$this->phpDocOptions['help']['tag'] = array("-q", "--quiet");
		$this->phpDocOptions['help']['desc'] = "	do not be verbose";

		$this->phpDocOptions['parseprivate']['tag'] = array("-pp","--parseprivate");
		$this->phpDocOptions['parseprivate']['desc'] = "parse elements marked private with @access.  Use on/off, default off";
		$this->phpDocOptions['parseprivate']['type'] = "value";

		$this->phpDocOptions['packageoutput']['tag'] = array("-po","--packageoutput");
		$this->phpDocOptions['packageoutput']['desc'] = "output documentation only for selected packages.  Use a comma-delimited list";
		$this->phpDocOptions['packageoutput']['type'] = "value";

		$this->phpDocOptions['defaultpackagename']['tag'] = array("-dn","--defaultpackagename");
		$this->phpDocOptions['defaultpackagename']['desc'] = "name to use for the default package.  If not specified, uses 'default'";
		$this->phpDocOptions['defaultpackagename']['type'] = "value";

		$this->phpDocOptions['output']['tag'] = array("-o","--output");
		$this->phpDocOptions['output']['desc'] = "output information to use separated by ','.  Format: output:converter:templatedir like \"HTML:default:default\"";
		$this->phpDocOptions['output']['type'] = "value";

		$this->phpDocOptions['customtags']['tag'] = array("-ct","--customtags");
		$this->phpDocOptions['customtags']['desc'] = "custom tags, will be recognized and put in tags[] instead of unknowntags[]";
		$this->phpDocOptions['customtags']['type'] = "value";

		$this->phpDocOptions['javadocdesc']['tag'] = array("-j","--javadocdesc");
		$this->phpDocOptions['javadocdesc']['desc'] = "JavaDoc-compliant description parsing.  Use on/off, default off (more flexibility)";
		$this->phpDocOptions['javadocdesc']['type'] = "value";

		$this->phpDocOptions['general']['message'] ="You can have multiple directories and multiple files, as well as a combination of both options\n";
	}

	
	/** created a help message
	 *  @return string a string containing a help message
	 */
	function displayHelpMsg()
	{
		unset($ret);
		$ret = "\n";
		foreach($this->phpDocOptions as $data)
		{
			unset($tag);
			$tag = "";
			if (isset($data['tag']))
			{
				if (is_array($data['tag'])) {
					foreach($data['tag'] as $param) {
						$tag .= "$param	";
					}
				}
				$tmp = "  ".trim($tag).str_repeat(" ",26);
				$tmp = substr($tmp,0,26);
				$ret .= $tmp."\t".ltrim($data['desc'])."\n\n";
			}
		}
		$ret .= "\n$data[message]\n";
		return $ret; 
	}


	/** write an array out to a file
         *  @param $fileName The name of the file to be written
         *  @param $array The to be wrote
         */
        function writeArray($fileName, $array)
        {
                $fp = fopen($fileName, "w");
                echo "Creating $fileName\n";
                foreach($array as $line) {
                        fputs($fp,$line . "\n");
                }
                fclose($fp);
        }

	/** Parses $GLOBALS[argv] and creates a setup array
	 *  @return array a setup array
	 *  @global array command-line arguments
	 */
	function parseArgv()
	{
		// defaults for setting
		$setting['hidden'] = "off";
		$setting['template'] = 'templates' . PATH_DELIMITER .'default' . PATH_DELIMITER;

		$valnext = "junk";
		if(array_key_exists('argv',$GLOBALS) && is_array($GLOBALS['argv']))
		{
			foreach ( $GLOBALS['argv'] as $cmd )
			{
				//if($cmd === 'phpdoc' || basename($cmd)==='phpdoc')
				//	continue;

				if ($cmd == '-h' || $cmd == '--help')
				{
					echo $this->displayHelpMsg();
					die();
				}
				$setting[$valnext] = $cmd;
				foreach( $this->phpDocOptions as $name => $data )
				{
					if (!empty($data['tag']))
					{
						if (in_array($cmd,$data['tag']))
						{
							$valnext = $name;
							break;
						} 
						else
						{
							$valnext = "junk";
						}
					}
				}
				if ($valnext == 'junk' && (strpos(trim($cmd),'-') === 0))
				{
					addErrorDie(PDERROR_UNKNOWN_COMMANDLINE,$cmd);
				}
			}
		}
		/* $setting will always have at least 2 elements
		[hidden] => off
		[template] => templates/default
		*/
		if (count($setting) < 3) {
			echo $this->displayhelpMsg();
			die();
		}
		return $setting;
	}


	/** Returns an array containing a list of files in a directory
         *  @param $directory full path to the directory you want the list of
         */
        function dirList($directory,$hidden = "off")
        {
			$ret = false;
			if (@is_dir($directory))
			{
				$ret = array();
				$d = @dir($directory); // thanks to Jason E Sweat (jsweat@users.sourceforge.net) for fix
				while($d && $entry=$d->read()) {
					if (strcmp($entry,".") != 0 && strcmp($entry,"..") != 0) {
						if ($hidden == "off")
						{
							if (substr($entry,0,1) == ".")
							{
								$getentry = false;
							} else {
								$getentry = true;
							}
								
						} else {
							$getentry = true;
						}
	
						if ($getentry == true)
						{
							if (is_file($directory . PATH_DELIMITER . $entry)) {
								$ret[] = $directory . PATH_DELIMITER . $entry;
							}
							if (is_dir($directory . PATH_DELIMITER . $entry)) {
								$tmp = $this->dirList($directory . PATH_DELIMITER . $entry, $hidden);
								if (is_array($tmp)) {
									foreach($tmp as $ent) {
										$ret[] = $ent;
									}
								}
							}
						}
					}
				}
				if ($d) $d->close();
			} else {
				die("directory: '$directory'  not found\n");
			}
			return $ret;
        }

	/**
	* Reads a file and returns it as a string
	* Does basic error checking
	*
	* file extensions are set in {@link phpdoc.inc}
	*
	* @global array PHP File extensions, used to validate that $path is a PHP File
	* @global array PHP File extensions in a CVS repository, used to validate that $path is a PHP File
	* @param	string	$path
	*/
	function readPhpFile($path, $quietMode = false)
	{
		global $CVSDOC_PHPFILE_EXTS, $PHPDOC_PHPFILE_EXTS;
		// tiberiusblue addition
		$cvsExt = $CVSDOC_PHPFILE_EXTS; 
		$ext = $PHPDOC_PHPFILE_EXTS;
		if (file_exists($path))
		{
			if (is_file($path))
			{
				// check extension
				$tmp = explode(".",$path);
				// tiberiusblue addition
				$tmp2 = $tmp;
				if (in_array(array_pop($tmp),$ext))
				{
					if ( $quietMode === false ) 
					{
						echo " -- Parsing file\n";
						flush();
					}
					$fp = fopen($path,"r");
					$ret = fread($fp,filesize($path));
					fclose($fp);
					return $ret;
				} elseif (in_array(array_pop($tmp2),$cvsExt)) 
				{ 
					phpdoc_out(" CVS file [EXPERIMENTAL]\n"); 
					$fp = fopen($path,"r"); 
					$ret = fread($fp,filesize($path)); 
					fclose($fp); 
					$ret = strstr($ret,"<?");
					$ret = substr($ret,0,strpos($ret,"@\n"));
					$ret = str_replace("@@","@",$ret); 
					return $ret; 
				} elseif ( $quietMode === false ) 
				{
					echo " -- File not parsed, not a php file\n";
				}
			} else {
				echo " -- Unable to read file, not a file\n";
			}
		} else {
			echo " -- Unable to read file, file does not exist\n";
		}
	}

	/**
	* Tell whether to ignore a file or a directory
	* allows * and ? wildcards
	*
	* @author Greg Beaver <cellog@users.sourceforge.net>
	* @param	string	$file	just the file name of the file or directory, the the case of directories this is the last dir
	* @param	string	$path	the full path
	* @param	array	$ignore
	* @return 	bool		true if $path should be ignored, false if it should not
	*/
	function checkIgnore($file,$path,$ignore)
	{
		if (!count($ignore)) return false;
		if (!is_numeric(strpos($file,'.'))) return true;
		$this->setupIgnore($ignore);
		if (!$this->ignore) return false;
		if (is_array($ignore))
		{
			foreach($this->ignore as $match)
			{
				if (is_array($match))
				{
					preg_match('/^'.$match[0].'$/',$path . PATH_DELIMITER,$find);
					if (!count($find))
					{
						preg_match('/^'.$match[0].'$/',$path,$find);
					}
					if (count($find))
					{
						preg_match('/^'.$match[1].'$/',$file,$find);
						if (count($find)) return true;
					}
				} else
				{
					preg_match('/^'.$match.'$/',$file,$find);
					if (count($find)) return true;
				}
			}
		}
		return false;
	}
	
	/**
	* @author Greg Beaver <cellog@users.sourceforge.net>
	*/
	function setupIgnore($ignore)
	{
		$ig = array();
		if (is_array($ignore))
		{
			for($i=0; $i<count($ignore);$i++)
			{
				$ignore[$i] = strtr($ignore[$i], "\\", "/");
				$ignore[$i] = str_replace('//','/',$ignore[$i]);

				if (!empty($ignore[$i]))
				{
					if (!is_numeric(strpos($ignore[$i],PATH_DELIMITER)))
					{
						$ig[] = $this->getRegExpableSearchString($ignore[$i]);
					} else
					{
						$ig[] = array($this->getRegExpableSearchString($ignore[$i]),$this->getRegExpableSearchString(basename($ignore[$i])));
					}
				}
			}
			if (count($ig)) $this->ignore = $ig;
		} else $this->ignore = false;
	}
	
	/**
	* Converts $s into a string that can be used with preg_match
	* @param string $s string with wildcards ? and *
	* @author Greg Beaver <cellog@users.sourceforge.net>
	*/
	function getRegExpableSearchString($s)
	{
		return strtr($s,array('?' => '.','*' => '.*','.' => '\\.','\\' => '\\\\','/' => '\\/', '[' => '\\[',']' => '\\]','-' => '\\-'));
	}
	
	/**
	* Removes files from the $dir array that do not match the search string in $match
	* @param array $dir array of filenames (full path)
	* @param string $match search string with wildcards
	* @author Greg Beaver <cellog@users.sourceforge.net>
	*/
	function removeNonMatches($dir, $match)
	{
		$match = $this->getRegExpableSearchString($match);
		$nodir = false;
		if (!is_array($dir))
		{
			$dir = array($dir);
			$nodir = true;
		}
		foreach($dir as $i => $file)
		{
			preg_match('/^'.$match.'$/',basename($file),$find);
			if (!count($find)) unset($dir[$i]);
		}
		if ($nodir) return $dir[0];
		return $dir;
	}
	
	/**
	* @param string $file a full path from the -f command-line parameter, with potential * and ? wildcards.
	* @return mixed if $file contains wilcards, returns an array of matching files, otherwise returns false
	* @author Greg Beaver <cellog@users.sourceforge.net>
	*/
	function getAllFiles($file)
	{
		$path = dirname($file);
		$file = basename($file);
		// any wildcards?
		if (is_numeric(strpos($file,'?')) || is_numeric(strpos($file,'*')))
		{
			$files = $this->dirList($path);
			$a = $this->removeNonMatches($files,$file);
			return $a;
		}
		return false;
	}
}
?>
