<?php
//
// PhpDoc, a program for creating javadoc style documentation from php code
// Copyright (C) 2000-2001 Joshua Eichorn
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//
// Copyright 2000-2001 Kellin
// Email passionplay@hotmail.com
// Portions Copyright 2000-2001 Joshua Eichorn
// Email jeichorn@phpdoc.org
// Web 		http://phpdoc.org/
// Mirror 	http://phpdocu.sourceforge.net/
// Project    	http://sourceforge.net/projects/phpdocu/
//

/**
* a class for handling the publishing of data
*
* @author Kellin <passionplay@hotmail.com>
* @author Joshua Eichorn <jeichorn@phpdoc.org>
* @version	$Id: Publisher.inc,v 1.7 2002/05/19 17:58:57 jeichorn Exp $
* @package 	phpDocumentor
*/
/**
* a class for handling the publishing of data
*
* @author Kellin <passionplay@hotmail.com>
* @author Joshua Eichorn <jeichorn@phpdoc.org>
* @version	$Id: Publisher.inc,v 1.7 2002/05/19 17:58:57 jeichorn Exp $
* @package 	phpDocumentor
*/
class Publisher
{
	/** Array of references objects that have Subscribed to this publiisher */
	var $subscriber	=	array();

	var $tokens	=	array();

	var $pushEvent	=	array();
	var $popEvent	=	array();


	/**
	* Adds a subscriber to the {@link $subscriber} array().
	* if $event is '*', the publisher will use $object as the default event handler
	* @param integer $event see {@link Parser.inc} PARSER_EVENT_* constants
	* @param class $object any class that has a HandleEvent() method like {@link IntermediateParser::HandleEvent()} or {@link Classes::HandleEvent()}
	*/
	function subscribe($event, &$object)
	{
		$this->subscriber[$event] =& $object;
	}

	/**
	* @param integer $event see {@link Parser.inc} PARSER_EVENT_* constants
	* @param mixed $data anything the subscribed event handler is expecting
	*/
	function publishEvent($event,$data)
	{
		
		// see if there is a specific event handler
		if (!empty($this->subscriber[$event]))
		{
			$this->subscriber[$event]->HandleEvent($event,$data);
		} 
		 else if (is_object($this->subscriber['*'])) // check to see if a generic handler exists
		{
			$this->subscriber['*']->HandleEvent($event,$data);
		}
	}	
}
?>
