from wxPython import wx
from wxPython import grid
from Objects import PhysicalPropertyTypes
from Objects.PhysicalProperty import PhysicalProperty
from Objects.PhysicalPropertyLink import PhysicalPropertyLink
from Objects.PhysicalPropertyTypes import VarcharType

ID_ADD = 10000
ID_REMOVE = 10001
ID_UP = 10002
ID_DOWN = 10003
ID_NAME = 10004

NAME_COL = 0
LOCALNAME_COL = 1
TYPE_COL = 2
SIZE1_COL = 3
SIZE2_COL = 4
PRIMARY_COL = 5
UNIQUE_COL = 6
NOTNULL_COL = 7
EDITABLE_COL = 8
SEQUENCE = 9
NUM_COLS = 10

class MyGrid(grid.wxGrid):
    def __init__(self, parent, model):
        grid.wxGrid.__init__(self, parent, -1, [5,5],[800, 250])
        grid.EVT_GRID_CELL_CHANGE(self, self.OnCellChange)
        self.model = model
        grid.EVT_GRID_CELL_LEFT_DCLICK(self, self.OnLeftDclick)

    def OnLeftDclick(self, e):
        if(self.CanEnableCellControl()):
            self.EnableCellEditControl()

    def OnCellChange(self, e):
        row=e.GetRow()
        col=e.GetCol()
        if(col!=NAME_COL):
            return
        val = self.GetCellValue(row, col)
        for i in self.model.properties:
            if(i.name == val):
                self.SetCellValue(row, TYPE_COL, str(i.datatype.name))
                self.SetCellValue(row, SIZE1_COL, str(i.datatype.size1))
                self.SetCellValue(row, SIZE2_COL, str(i.datatype.size2))
                self.SetCellValue(row, LOCALNAME_COL, str(i.name))
                break


class PhysicalEntityDialog(wx.wxDialog):
    def __init__(self, parent, id, title, entity, model):
        wx.wxDialog.__init__(self, parent, id, title)
        self.entity = entity
        self.SetSize([850,380])
        self.grid = MyGrid(self, model)
        self.grid.CreateGrid(len(self.entity.propertylinks), NUM_COLS)
        self.grid.SetColFormatNumber(SIZE1_COL)
        self.grid.SetColFormatNumber(SIZE2_COL)
        self.grid.SetColLabelValue(NAME_COL, "Name")
        self.grid.SetColLabelValue(LOCALNAME_COL, "Local Name")
        self.grid.SetColLabelValue(TYPE_COL, "Type")
        self.grid.SetColLabelValue(SIZE1_COL, "Size1")
        self.grid.SetColLabelValue(SIZE2_COL, "Size2")
        self.grid.SetColLabelValue(PRIMARY_COL, "Primary")
	self.grid.SetColSize(PRIMARY_COL, 50)
        self.grid.SetColLabelValue(UNIQUE_COL, "Unique")
	self.grid.SetColSize(UNIQUE_COL, 50)
        self.grid.SetColLabelValue(NOTNULL_COL, "Not null")
	self.grid.SetColSize(NOTNULL_COL, 50)
        self.grid.SetColLabelValue(EDITABLE_COL, "Editable")
	self.grid.SetColSize(EDITABLE_COL, 50)
	self.grid.SetColLabelValue(SEQUENCE, "Sequence")
	self.grid.SetColSize(SEQUENCE, 62)
        self.rows = 0
        self.typelist = []
        self.model = model
        self.namelist = []

        for i in PhysicalPropertyTypes.types:
            self.typelist.append(i.DefaultName)

        for i in self.model.properties:
            self.namelist.append(i.name)

        for i in self.entity.propertylinks:
            self.AddRow(self.rows, i)
            self.rows = self.rows + 1

        wx.wxStaticText(self, -1, "Name:", [10, 270])
        self.namectrl = wx.wxTextCtrl(self, ID_NAME, entity.name, [100, 270])
        wx.wxButton(self, wx.wxID_OK, "OK", [10, 310])
        wx.wxButton(self, wx.wxID_CANCEL, "Cancel", [100, 310])
        wx.wxButton(self, ID_ADD, "Add", [190, 310])
        wx.wxButton(self, ID_REMOVE, "Remove", [280, 310])
        wx.wxButton(self, ID_UP, "Up", [370, 310])
        wx.wxButton(self, ID_DOWN, "Down", [460, 310])
        wx.EVT_BUTTON(self, ID_ADD, self.DoAdd)
        wx.EVT_BUTTON(self, ID_REMOVE, self.DoRemove)
        wx.EVT_BUTTON(self, wx.wxID_OK, self.OnOk)

    def SetRowParams(self, n):
        self.grid.SetCellEditor(n, NAME_COL, grid.wxGridCellChoiceEditor(self.namelist, wx.true))
        #self.grid.SetCellEditor(n, TYPE_COL, grid.wxGridCellChoiceEditor(self.typelist, wx.true))
        self.grid.SetReadOnly(n, TYPE_COL, wx.true)
        self.grid.SetReadOnly(n, SIZE1_COL, wx.true)
        self.grid.SetReadOnly(n, SIZE2_COL, wx.true)
        self.grid.SetCellEditor(n, PRIMARY_COL, grid.wxGridCellBoolEditor())
        self.grid.SetCellRenderer(n, PRIMARY_COL, grid.wxGridCellBoolRenderer())
        self.grid.SetCellEditor(n, UNIQUE_COL, grid.wxGridCellBoolEditor())
        self.grid.SetCellRenderer(n, UNIQUE_COL, grid.wxGridCellBoolRenderer())
        self.grid.SetCellEditor(n, NOTNULL_COL, grid.wxGridCellBoolEditor())
        self.grid.SetCellRenderer(n, NOTNULL_COL, grid.wxGridCellBoolRenderer())
        self.grid.SetCellEditor(n, EDITABLE_COL, grid.wxGridCellBoolEditor())
        self.grid.SetCellRenderer(n, EDITABLE_COL, grid.wxGridCellBoolRenderer())
	self.grid.SetCellEditor(n, SEQUENCE, grid.wxGridCellBoolEditor())
	self.grid.SetCellRenderer(n, SEQUENCE, grid.wxGridCellBoolRenderer())
    def AddRow(self, n, propertylink):
        self.SetRowParams(n)
        self.grid.SetCellValue(n, NAME_COL, str(propertylink.property.name))
        self.grid.SetCellValue(n, LOCALNAME_COL, str(propertylink.localname))
        self.grid.SetCellValue(n, TYPE_COL, str(propertylink.property.datatype.name))
        self.grid.SetCellValue(n, SIZE1_COL, str(propertylink.property.datatype.size1))
        self.grid.SetCellValue(n, SIZE2_COL, str(propertylink.property.datatype.size2))
        self.grid.SetCellValue(n, PRIMARY_COL, str(propertylink.primarykey))
        self.grid.SetCellValue(n, UNIQUE_COL, str(propertylink.unique))
        self.grid.SetCellValue(n, NOTNULL_COL, str(propertylink.notnull))
        self.grid.SetCellValue(n, EDITABLE_COL, str(propertylink.editable))
	self.grid.SetCellValue(n, SEQUENCE, str(propertylink.sequence))

    def DoAdd(self, e):
        self.grid.AppendRows()
        self.SetRowParams(self.rows)
        self.grid.SetGridCursor(self.rows, 0)
        self.grid.MakeCellVisible(self.rows, 0)
        self.rows = self.rows + 1

    def DoRemove(self, e):
        n = self.grid.GetGridCursorRow()
        if(n >= 0):
            self.grid.DeleteRows(n)
        self.rows = self.rows - 1
    def getBool(self, b):
        if((b != 1) and (b != "1")):
            b = 0
        else:
            b = 1
        return b
    def OnOk(self, e):
        self.entity.ClearPropertyLinks()
        self.entity.name = self.namectrl.GetValue()
        for i in range(0,self.rows):
            prop = self.model.FindProperty(self.grid.GetCellValue(i, NAME_COL))
            pk = self.getBool(self.grid.GetCellValue(i, PRIMARY_COL))
            uniq = self.getBool(self.grid.GetCellValue(i, UNIQUE_COL))
            nn = self.getBool(self.grid.GetCellValue(i, NOTNULL_COL))
            edit = self.getBool(self.grid.GetCellValue(i, EDITABLE_COL))
            locname = self.grid.GetCellValue(i, LOCALNAME_COL)
	    sequence = self.getBool(self.grid.GetCellValue(i, SEQUENCE))
            self.entity.AddPropertyLink(PhysicalPropertyLink(prop, pk, uniq, nn, edit, locname, sequence))

        self.EndModal(wx.wxID_OK)
