from wxPython import wx
from wxPython import grid
from Objects import PhysicalPropertyTypes 
from Objects.PhysicalProperty import PhysicalProperty
from Objects.PhysicalPropertyLink import PhysicalPropertyLink
from Objects.PhysicalPropertyTypes import FindType

ID_ADD = 10000
ID_REMOVE = 10001
ID_UP = 10002
ID_DOWN = 10003
ID_NAME = 10004

NAME_COL = 0
TYPE_COL = 1
SIZE1_COL = 2
SIZE2_COL = 3
ORIGNAME_COL = 4
NUM_COLS = 5

class MyGrid(grid.wxGrid):
    def __init__(self, parent):
        grid.wxGrid.__init__(self, parent, -1, [5,5],[490, 250])
        grid.EVT_GRID_CELL_LEFT_DCLICK(self, self.OnLeftDclick)
    def OnLeftDclick(self, e):
        if(self.CanEnableCellControl()):
            self.EnableCellEditControl()
class PhysicalPropertiesDialog(wx.wxDialog):
    def __init__(self, parent, id, title, model):
        wx.wxDialog.__init__(self, parent, id, title)
        self.SetSize([500,340])
        self.model = model
        self.grid = MyGrid(self)
        self.grid.CreateGrid(len(self.model.properties), NUM_COLS)
        self.grid.SetColFormatNumber(SIZE1_COL)
        self.grid.SetColFormatNumber(SIZE2_COL)
        self.grid.SetColLabelValue(NAME_COL, "Name")
        self.grid.SetColLabelValue(TYPE_COL, "Type")
        self.grid.SetColLabelValue(SIZE1_COL, "Size1")
        self.grid.SetColLabelValue(SIZE2_COL, "Size2")
        self.grid.SetColLabelValue(ORIGNAME_COL, "")
        self.grid.SetColSize(ORIGNAME_COL, 0)
        self.grid.ForceRefresh()
        self.rows = 0
        self.typelist = []

        for i in PhysicalPropertyTypes.types:
            self.typelist.append(i.DefaultName)

        self.typelist.sort()
	
        for i in self.model.properties:
            self.AddRow(self.rows, i)
            self.rows = self.rows + 1

        wx.wxButton(self, wx.wxID_OK, "OK", [10, 270])
        wx.wxButton(self, wx.wxID_CANCEL, "Cancel", [100, 270])
        wx.wxButton(self, ID_ADD, "Add", [190, 270])
        wx.wxButton(self, ID_REMOVE, "Remove", [280, 270])
        wx.EVT_BUTTON(self, ID_ADD, self.DoAdd)
        wx.EVT_BUTTON(self, ID_REMOVE, self.DoRemove)
        wx.EVT_BUTTON(self, wx.wxID_OK, self.OnOK)

    def SetRowParams(self, n):
        self.grid.SetCellEditor(n, TYPE_COL, grid.wxGridCellChoiceEditor(self.typelist, wx.false))

    def AddRow(self, n, property):
        self.SetRowParams(n)
        self.grid.SetCellValue(n, NAME_COL, str(property.name))
        self.grid.SetCellValue(n, ORIGNAME_COL, str(property.name))
        self.grid.SetCellValue(n, TYPE_COL, str(property.datatype.name))
        self.grid.SetCellValue(n, SIZE1_COL, str(property.datatype.size1))
        self.grid.SetCellValue(n, SIZE2_COL, str(property.datatype.size2))

    def DoAdd(self, e):
        self.grid.AppendRows()
        self.SetRowParams(self.rows)
        self.grid.SetGridCursor(self.rows, 0)
        self.grid.MakeCellVisible(self.rows, 0)
        self.rows = self.rows + 1
        self.grid.ForceRefresh()

    def DoRemove(self, e):
        n = self.grid.GetGridCursorRow()
        if(n >= 0):
            self.grid.DeleteRows(n)
        self.rows = self.rows - 1
    def OnOK(self, e):
        for i in range(0,self.rows):
            origname = self.grid.GetCellValue(i, ORIGNAME_COL)
            name = self.grid.GetCellValue(i, NAME_COL)
            type = self.grid.GetCellValue(i, TYPE_COL)
            size1 = self.grid.GetCellValue(i, SIZE1_COL)
            if((size1 != "") and (size1 != "None")):
                size1 = int(size1)
            else:
                size1=None
            size2 = self.grid.GetCellValue(i, SIZE2_COL)
            if((size2 != "") and (size2 != "None")):
                size2 = int(size2)
            else:
                size2 = None
            prop = self.model.FindProperty(origname)
            if(prop == None):
                ftype = FindType(type)
                prop = PhysicalProperty(name, ftype, size1, size2)
                self.model.AddProperty(prop)
            else:
                prop.name = name
                if(prop.datatype.name == type):
                    prop.datatype.size1 = size1
                    prop.datatype.size2 = size2
                else:
                    ftype = FindType(type)
                    prop.datatype = ftype(size1, size2)
        self.EndModal(wx.wxID_OK)
