from wxPython import wx
from wxPython import ogl

# class for Entity View
class EntityView(ogl.wxDividedShape):
    def __init__(self, modelview, entity, x, y, w, h):
        #creating device context
        self.dc = ogl.wxClientDC(modelview)
        self.modelview = modelview
        self.modelview.PrepareDC(self.dc)
        self.entity = entity
        ogl.wxDividedShape.__init__(self, w, h)

        #building
        self.BuildFromScratch(self.dc, entity, x, y, w, h)

        #drawing
        self.Recompute()
        self.modelview.GetDiagram().AddShape(self)
        self.Show(wx.true)
        self.modelview.Redraw(self.dc)
        self.modelview.SetCurrentEntityView(self)
        self.model = None

    def SetModel(self, model):
        self.model = model

    def BuildFromScratch(self, modelview, entity, x, y, w, h):
        pass

    def OnLeftClick(self, x, y, keys, attachment):
        self.base_OnLeftClick(x, y, keys, attachment)
        self.modelview.SetCurrentEntityView(self)

    def OnEndDragLeft(self, x, y, keys, attachment):
        self.base_OnEndDragLeft(x, y, keys, attachment)
        self.modelview.SetCurrentEntityView(self)

    def SetSelected(self):
        self.Select(wx.true, self.dc)
        self.modelview.Redraw(self.dc)

    def SetUnselected(self):
        self.Select(wx.false, self.dc)
        self.modelview.Redraw(self.dc)

    def GetWidth(self):
        i = self.GetBoundingBoxMin()
        return i[0]

    def GetHeight(self):
        i = self.GetBoundingBoxMin()
        return i[1]
