#importing objects
from Objects import Entity
from PrintFramework import MyPrintout

#importing GUI elements
from EntityView import EntityView

#importing wxPython
from wxPython import wx
from wxPython import ogl

#importing utils
from Utils import FindInList

class ModelView(ogl.wxShapeCanvas):
    def __init__(self, frame, model):
        #running default constructor
        ogl.wxShapeCanvas.__init__(self, frame)

        self.frame = frame
        self.entityViews = []
        self.relationViews = []
        self.diagram = ogl.wxDiagram()
        self.SetDiagram(self.diagram)
        self.diagram.SetCanvas(self)
        self.currentEntityView = None
        self.currentRelationView = None
        self.SetScrollbars(20, 20, 300, 300)

        self.printData = wx.wxPrintData()
        self.printData.SetPaperId(wx.wxPAPER_LETTER)
        self.model = model
        self.showlabels = 1

    def OnPrintSetup(self, event):
        printerDialog = wx.wxPrintDialog(self)
        printerDialog.GetPrintDialogData().SetPrintData(self.printData)
        printerDialog.GetPrintDialogData().SetSetupDialog(wx.true)
        printerDialog.ShowModal();
        self.printData = printerDialog.GetPrintDialogData().GetPrintData()
        printerDialog.Destroy()


    def OnPrintPreview(self, event):
        printout = MyPrintout(self)
        printout2 = MyPrintout(self)
        self.preview = wx.wxPrintPreview(printout, printout2, self.printData)
        if not self.preview.Ok():
            return

        frame = wx.wxPreviewFrame(self.preview, self.frame, "This is a print preview")

        frame.Initialize()
        frame.SetPosition(self.frame.GetPosition())
        frame.SetSize(self.frame.GetSize())
        frame.Show(wx.true)



    def OnDoPrint(self, event):
        pdd = wx.wxPrintDialogData()
        pdd.SetPrintData(self.printData)
        printer = wx.wxPrinter(pdd)
        printout = MyPrintout(self)
        if not printer.Print(self.frame, printout):
            wx.wxMessageBox("There was a problem printing.\nPerhaps your current printer is not set correctly?", "Printing", wx.wxOK)
        else:
            self.printData = printer.GetPrintDialogData().GetPrintData()
            printout.Destroy()

    def CreateEntityView(self, entity, x, y, w, h):
        return EntityView(self, entity, x, y, w, h)

    def AddEntityView(self, entityview):
        self.entityViews.append(entityview)

    def AddEntity(self, entity, x, y, w, h):
        self.AddEntityView(self.CreateEntityView(entity, x, y, w, h))

    def UnsetCurrentView(self):
        self.UnsetCurrentEntityView()
        self.UnsetCurrentRelationView()

    def UnsetCurrentRelationView(self):
        if(self.currentRelationView <> None):
            self.currentRelationView.SetUnselected()
            self.currentRelationView=None

    def UnsetCurrentEntityView(self):
        if(self.currentEntityView <> None):
            self.currentEntityView.SetUnselected()
            self.currentEntityView=None

    def SetCurrentEntityView(self, entityview):
        self.UnsetCurrentView()
        self.currentEntityView = entityview
        self.currentEntityView.SetSelected()

    def SetCurrentRelationView(self, relationview):
        self.UnsetCurrentView()
        self.currentRelationView = relationview
        self.currentRelationView.SetSelected()
    
    def GetCurrentEntityView(self):
        return self.currentEntityView

    def GetCurrentRelationView(self):
        return self.currentRelationView

    def DeleteAll(self):
        self.UnsetCurrentView()
        for i in self.relationViews:
            i.Unlink()
            self.remove(i)
        for i in self.entityViews:
            self.remove(i)
        self.entityViews=[]
        self.relationViews=[]

    def DeleteCurrentEntityView(self):
        self.DeleteView(self.entityViews, self.currentEntityView)

    def DeleteCurrentRelationView(self):
        if(self.currentRelationView == None):
            return
        self.currentRelationView.Unlink()
        self.DeleteView(self.relationViews, self.currentRelationView)

    def removeEntityView(self, e):
        e.SetUnselected()
        self.remove(e)

    def remove(self, e):
        dc = e.dc
        e.Erase(dc)
        self.RemoveShape(e)
        self.Redraw(dc)

    def getWidth(self):
        w = 0
        for i in self.entityViews:
            tw = i.GetWidth()+i.GetX()
            if(tw > w):
                w = tw
        return w

    def getHeight(self):
        h = 0
        for i in self.entityViews:
            th = i.GetHeight()+i.GetY()
            if(th > h):
                h = th
        return h

    def DoDrawing(self, dc):
        self.diagram.Redraw(dc)

    def DeleteView(self, views, view):
        view.Unlink()
        if(view == None):
            return
        toDel = FindInList(views, view)
        self.UnsetCurrentView()
        self.remove(view)
        del views[toDel]

    def OnLeftClick(self, x, y, keys):
#        self.base_OnLeftClick(x, y, keys, attachment)
        self.UnsetCurrentView()
