#importing GUI
from wxPython import wx
from wxPython import ogl

#importing parent
from EntityView import EntityView
#importing dialogs
from Dialogs import PhysicalEntityDialog

class PhysicalEntityView(EntityView):
    def BuildFromScratch(self, dc, entity, x, y, w, h):
        #declaring consts and vars
        HEADER_REGION = 0
        PK_REGION = 1
        PROPS_REGION = 2
        HEADER_HEIGHT = 30.0
        LINE_HEIGHT = 12.0

        regions = [None, None, None]
        
        # Primary keys
        pk = []
        for i in entity.propertylinks:
            if i.primarykey == 1:
                pk.append(str(i.localname).replace("\'", ""))

        #calculating height
        pk_lines = len(pk)
        pkLinesH = (pk_lines + 1) * LINE_HEIGHT
        
        prop_lines = len(entity.propertylinks)
        propLinesH = (prop_lines + 1) * LINE_HEIGHT #chars like "y" grow under
                                                    #the bottom of the latest line,
                                                    #therefore we need to add 1
                                                    #more line than really required
        full_height = HEADER_HEIGHT + pkLinesH + propLinesH
      
        #setting size
        if h == 0:
            h = full_height
            self.SetSize(w, h)
        
        #adding regions
        if len(self.GetRegions()) == 0:
            regions[HEADER_REGION] = ogl.wxShapeRegion()
            self.AddRegion(regions[HEADER_REGION])
            regions[PK_REGION] = ogl.wxShapeRegion()
            self.AddRegion(regions[PK_REGION])
            regions[PROPS_REGION] = ogl.wxShapeRegion()
            self.AddRegion(regions[PROPS_REGION])
        else:
            regions[HEADER_REGION] = self.GetRegions()[HEADER_REGION]
            regions[PK_REGION] = self.GetRegions()[PK_REGION]
            regions[PROPS_REGION] = self.GetRegions()[PROPS_REGION]

        
        # Setting header region
        regions[HEADER_REGION].SetProportions(1.0, HEADER_HEIGHT/full_height)
        self.SetFont(wx.wxFont(12, wx.wxDEFAULT, wx.wxNORMAL, wx.wxBOLD), HEADER_REGION)
        self.SetFormatMode(ogl.FORMAT_CENTRE_VERT|ogl.FORMAT_CENTRE_HORIZ, HEADER_REGION)
        self.FormatText(dc, str(entity.name), HEADER_REGION)
        
        self.SetX(x)
        self.SetY(y)

        # Set PrimaryKeys region
        regions[PK_REGION].SetProportions(1.0, pkLinesH/full_height)
        self.SetFont(wx.wxFont(11, wx.wxDEFAULT, wx.wxNORMAL, wx.wxBOLD), PK_REGION)
        self.SetFormatMode(ogl.FORMAT_NONE, PK_REGION)
        self.FormatText(dc, '\n'.join(pk), PK_REGION)

        # Adding properties region
        regions[PROPS_REGION].SetProportions(1.0, propLinesH/full_height)
        self.SetFormatMode(ogl.FORMAT_SIZE_TO_CONTENTS, PROPS_REGION)
        s = ""
        for i in entity.propertylinks:
            flg = 0
            s += i.localname + ":" + i.property.datatype.name 
            if i.property.datatype.size1:
                s += "("+str(i.property.datatype.size1)
                flg = 1
            if i.property.datatype.size2:
                s += ","+str(i.property.datatype.size2)
            if flg == 1:
                s += ")"
            if i.notnull == 1:
                s += " NOT NULL"
            s += "\n"
            
        self.SetFormatMode(ogl.FORMAT_SIZE_TO_CONTENTS, PROPS_REGION)
        self.FormatText(dc, s, PROPS_REGION)
        
        # Recentre Header_region (entity.name)
        self.Recentre(dc)

    def Edit(self):
        a = PhysicalEntityDialog(self.modelview, -1, "Edit entity", self.entity, self.GetCanvas().model)
        a.ShowModal()
        a.Destroy()
        self.BuildFromScratch(self.dc, self.entity, self.GetX(), self.GetY(), self.GetWidth(), 0)
        self.Recompute()
        self.modelview.Redraw(self.dc)
