#define parent
from ModelView import ModelView

#importing GUI elements
from wxPython import ogl
from wxPython import wx
from PhysicalEntityView import PhysicalEntityView
from PhysicalRelationView import PhysicalRelationView
from Objects.PhysicalRelation import PhysicalRelation

class PhysicalModelView(ModelView):
    def CreateEntityView(self, entity, x, y, w, h):
        return PhysicalEntityView(self, entity, x, y, w, h)

    def GetEntityView(self, entity):
        for i in self.entityViews:
            if(i.entity == entity):
                return i
        return None

    def AddRelationView(self, e1, e2, prop):
        r = PhysicalRelation(e1, e2, prop)
        rw = PhysicalRelationView(self, r)
        self.relationViews.append(rw)

    def AddRelationView(self, relation):
        rw = PhysicalRelationView(self, relation)
        self.relationViews.append(rw)
    
    def DeleteCurrentEntityView(self):
        name = self.currentEntityView.entity.name
        self.DeleteView(self.entityViews, self.currentEntityView)
        for i in self.relationViews:
            if((i.entityview0.entity.name == name ) or \
            (i.entityview1.entity.name  == name )):
                self.remove(i)

    def ToggleLabels(self, e):
        if(self.showlabels == 1):
            for i in self.relationViews:
                i.Unlink()
                self.remove(i)
            self.relationViews=[]
            self.showlabels = 0
            for i in self.model.relations:
                self.AddRelationView(i)
        else:
            for i in self.relationViews:
                i.ShowLabel()
                i.Recompute()
                self.GetDiagram().Redraw(i.dc)
            self.showlabels = 1
