#importing GUI
from wxPython import wx
from wxPython import ogl
from wxPython import gdi

#importing parent
from RelationView import RelationView

class PhysicalRelationView(RelationView):
    def BuildFromScratch(self):
        self.AddArrow(ogl.ARROW_ARROW, ogl.ARROW_POSITION_END, 8.0)
        self.entityview0 = self.modelview.GetEntityView(self.relation.entities[0])
        self.entityview1 = self.modelview.GetEntityView(self.relation.entities[1])
        if(self.modelview.showlabels == 1):
            self.ShowLabel()
        self.entityview0.AddLine(self, self.entityview1)
        self.SetPen(wx.wxBLACK_PEN)
        self.SetBrush(wx.wxBLACK_BRUSH)
        self.MakeLineControlPoints(2)

    def Refresh(self):
        #the next line is a bug in OGL...
        self.entityview0.Move(self.dc, self.entityview0.GetX(), self.entityview0.GetY())
    def ShowLabel(self):
        label = ""
        for i in self.relation.properties:
            label = label+i.name + ' '
            r  = self.GetRegions()[0]
            r.SetSize(len(label)*6, 12)
            self.FormatText(self.dc, label)
    def HideLabel(self):
        r  = self.GetRegions()[0]
        r.SetSize(1,1)
        self.FormatText(self.dc, "")
        self.Recompute()
        self.modelview.Redraw(self.dc)