from wxPython.wx         import *
#----------------------------------------------------------------------

class MyPrintout(wxPrintout):
    def __init__(self, canvas):
        wxPrintout.__init__(self)
        self.canvas = canvas
        self.pages = 99

    def HasPage(self, page):
        if page < self.pages:
            return true
        #else:
        #    return false

    def GetPageInfo(self):
        return (1, self.pages, 1, self.pages)

    def OnPrintPage(self, page):
        dc = self.GetDC()

        #-------------------------------------------
        #set the real zooming factor
        zoomfactorw = 1.0
        zoomfactorh = 1.0
        #getting printer resolution
        (printerppiw, printerppih)=self.GetPPIPrinter()
        #getting screen resolution
        (screenppiw, screenppih)=self.GetPPIScreen()
        #getting paper size
        (pagesizew, pagesizeh)=self.GetPageSizePixels()
        #get physical width and height
        (dcw,dch)=dc.GetSizeTuple()
        dcw1 = dcw
        dch1 = dch
        dcw=dcw*(pagesizew - printerppiw/2)/pagesizew
        dch=dch*(pagesizeh - printerppih/2)/pagesizeh
        marginw = dcw1-dcw
        marginh = dch1-dch
        #pagesizew = pagesizew - printerppiw
        #pagesizeh = pagesizeh - printerppih
        #determining zoom factor: scale image to printer resolution, then to physical resolution

        zoomfactorw=zoomfactorw*dcw/pagesizew*printerppiw/screenppiw
        zoomfactorh=zoomfactorh*dch/pagesizeh*printerppih/screenppih
        maxX = self.canvas.getWidth()*zoomfactorw
        maxY = self.canvas.getHeight()*zoomfactorh

        rows = int(maxX/dcw)
        cols = int(maxY/dch)
        if(rows == 0):
            rows = 1
        if(cols == 0):
            cols = 1
        # calculate page
        pg = page - 1
        row = pg/rows
        col = pg-int(row*rows)
        xoffset = row*dcw
        yoffset = col*dch
        dc.SetUserScale(zoomfactorw, zoomfactorh)
        dc.SetDeviceOrigin(-xoffset+marginw/2, -yoffset+marginh/2)

        #-------------------------------------------

        self.canvas.DoDrawing(dc)
#        dc.DrawText("Page: %d" % page, marginX/2, maxY-marginY)

        return true
