from wxPython import wx
from wxPython import ogl

# class for Entity View
class RelationView(ogl.wxLineShape):
    def __init__(self, modelview, relation):
        #creating device context
        self.dc = ogl.wxClientDC(modelview)
        self.model = None
        self.modelview = modelview
        self.modelview.PrepareDC(self.dc)
        self.relation = relation
        ogl.wxLineShape.__init__(self)

        #building
        self.BuildFromScratch()
        self.modelview.GetDiagram().AddShape(self)
        self.SetCanvas(self.modelview)

        #drawing
        self.Show(wx.true)
        self.Refresh()

    def SetModel(self, model):
        self.model = model

    def BuildFromScratch(self, modelview, relation):
        pass

    def Refresh(self):
        pass

    def OnLeftClick(self, x, y, keys, attachment):
        self.base_OnLeftClick(x, y, keys, attachment)
        self.modelview.SetCurrentRelationView(self)

    def SetSelected(self):
        self.Select(wx.true, self.dc)
        self.modelview.Redraw(self.dc)

    def SetUnselected(self):
        self.Select(wx.false, self.dc)
        self.modelview.Redraw(self.dc)
