#importing gui
from wxPython import wx
from wxPython import ogl
from Gui.Dialogs import PhysicalPropertiesDialog
from PhysicalModelView import PhysicalModelView

#importing objects
from Objects import PhysicalModel
from Objects import PhysicalRelation

#importing workers
from Workers import ReadModel
from Workers import SaveModel
from Workers import SaveSqlModel
from Workers import SaveMySQLModel
from os.path import *
#declaring menu ids
FILE_OPEN=1000
FILE_NEW=1010
FILE_SAVE=1020
FILE_SAVEAS=1030
FILE_EXIT=1040
FILE_PRINTSETUP=1050
FILE_PRINT=1060
FILE_PRINTPREVIEW=1070
FILE_SAVESQL=1080
FILE_SAVESQL_MYSQL = 10801
FILE_SAVESQL_SQL92 = 10802
EDIT_UNDO=2000
EDIT_REDO=2010
EDIT_CUT=2020
EDIT_COPY=2030
EDIT_PASTE=2040
EDIT_CLEAR=2050
EDIT_ALL=2060

TOOLS_ADDENTITY=3000
TOOLS_EDITPROPS=3001
TOOLS_EDITCURRENT=3002
TOOLS_GENERATERELS=3003
TOOLS_GENERATERELSALL=3004
TOOLS_TOGGLELABELS=3005

class SaveAsSQLSubMenu(wx.wxMenu):
    def __init__(self):
        wx.wxMenu.__init__(self, "", 0)
        self.Append(FILE_SAVESQL_MYSQL, "&MySQL", "Generate Schema for MySQL", wx.TRUE)
        self.Append(FILE_SAVESQL_SQL92, "&SQL92", "Generate Schema Compliant to SQL92", wx.TRUE)      

class FileMenu(wx.wxMenu):
    def __init__(self):
        wx.wxMenu.__init__(self, "", 0)
        self.Append(FILE_OPEN, "&Open\tCTRL-O", "Open model", wx.FALSE)
        self.Append(FILE_NEW, "&New\tCTRL-N", "New model", wx.FALSE)
        self.Append(FILE_SAVE, "&Save\tCTRL-S", "Save model", wx.FALSE)
        self.Append(FILE_SAVEAS, "Save &as...", "Save model under a new name", wx.FALSE)
        self.Append(FILE_PRINTSETUP, "Printer setup...", "Setup printer", wx.FALSE)
        self.Append(FILE_PRINT, "&Print...", "Print model", wx.FALSE)
        self.Append(FILE_PRINTPREVIEW, "Print previe&w\tCTRL-W", "Show print preview of model", wx.FALSE)
        self.AppendMenu(FILE_SAVESQL, "Save as SQ&L", SaveAsSQLSubMenu())
        self.AppendSeparator()
        self.Append(FILE_EXIT, "E&xit\tCTRL-Q", "Exit application", wx.FALSE)

class EditMenu(wx.wxMenu):
    def __init__(self):
        wx.wxMenu.__init__(self, "", 0)
        self.Append(EDIT_UNDO, "&Undo\tCTRL-Z", "Undo", wx.FALSE)
        self.Append(EDIT_REDO, "&Redo\tCTRL-Y", "Redo", wx.FALSE)
        self.AppendSeparator()
        self.Append(EDIT_CUT, "&Cut\tCTRL-X", "Cut selection", wx.FALSE)
        self.Append(EDIT_COPY, "C&opy\tCTRL-C", "Copy selection", wx.FALSE)
        self.Append(EDIT_PASTE, "&Paste\tCTRL-V", "Paste", wx.FALSE)
        self.Append(EDIT_CLEAR, "C&lear\tCtrl-D", "Clear selection", wx.FALSE)
        self.AppendSeparator()
        self.Append(EDIT_ALL, "Select &All\tCTRL-A", "Clear selection", wx.FALSE)

class ToolsMenu(wx.wxMenu):
    def __init__(self):
        wx.wxMenu.__init__(self, "", 0)
        self.Append(TOOLS_ADDENTITY, "&Add entity\tCTRL+E", "Add new entity", wx.FALSE)
        self.Append(TOOLS_EDITPROPS, "&Edit property list\tCTRL+P", "Edit property list", wx.FALSE)
        self.Append(TOOLS_EDITCURRENT, "&Edit entity\tCTRL+U", "Edit entity parameters", wx.FALSE)
        self.Append(TOOLS_GENERATERELS, "&Generate relations\tCTRL+R", "Generate relations of selected entity", wx.FALSE)
        self.Append(TOOLS_GENERATERELSALL, "Generate all relations", "Generate all relations", wx.FALSE)
        self.Append(TOOLS_TOGGLELABELS, "&Toggle labels on properties\tCTRL+T", "Toggle labels on properties", wx.FALSE)

class MainMenuBar(wx.wxMenuBar):
    def __init__(self):
        wx.wxMenuBar.__init__(self, 0)
        self.Append(FileMenu(), "&File")
        self.Append(EditMenu(), "&Edit")
        self.Append(ToolsMenu(), "&Tools")

class pydbMainFrame(wx.wxFrame):
    def __init__(self, model):
        wx.wxFrame.__init__(self, wx.NULL, 0, "Python Database Designer")
        self.model = model
        self.SetMenuBar(MainMenuBar())
        self.SetEvents()
        self.SetSize(wx.wxSize(800,600))
        self.modelview = PhysicalModelView(self, self.model)
        self.rebuild()
        self.filename = None
        self.sqlfilename = None

    def doSave(self):
        wait = wx.wxBusyCursor()
        saver = SaveModel(self.filename)
        saver.save(self.model, self.modelview)
        wait = None

    def doSaveSql92(self):
        wait = wx.wxBusyCursor()
        saver = SaveSqlModel(self.sqlfilename)
        saver.save(self.model, self.modelview)
        wait = None

    def doSaveMySQL(self):
        wait = wx.wxBusyCursor()
        saver = SaveMySQLModel(self.sqlfilename)
        saver.save(self.model, self.modelview)
        wait = None

    def doOpen(self):
        wait = wx.wxBusyCursor()
        reader = ReadModel(self.filename)
        self.model = reader.read(self, self.modelview)
        self.modelview.model = self.model
        wait = None
        self.modelview.UnsetCurrentView()

    def rebuild(self):
        for i in self.model.entities:
            self.modelview.AddEntity(i, 100, 100, 120, 0)

    def SetEvents(self):
        wx.EVT_MENU(self, FILE_OPEN, self.Open)
        wx.EVT_MENU(self, FILE_NEW, self.New)
        wx.EVT_MENU(self, FILE_SAVE, self.Save)
        wx.EVT_MENU(self, FILE_SAVEAS, self.SaveAs)
        wx.EVT_MENU(self, FILE_PRINT, self.Print)
        wx.EVT_MENU(self, FILE_PRINTSETUP, self.PrintSetup)
        wx.EVT_MENU(self, FILE_PRINTPREVIEW, self.PrintPreview)
        wx.EVT_MENU(self, FILE_SAVESQL_SQL92, self.SaveAsSql92)      
        wx.EVT_MENU(self, FILE_SAVESQL_MYSQL, self.SaveAsMySQL)
        wx.EVT_MENU(self, FILE_EXIT, self.Exit)
        wx.EVT_MENU(self, TOOLS_ADDENTITY, self.AddEntity)
        wx.EVT_MENU(self, TOOLS_EDITPROPS, self.EditProperties)
        wx.EVT_MENU(self, TOOLS_EDITCURRENT, self.EditCurrentEntity)
        wx.EVT_MENU(self, TOOLS_GENERATERELS, self.GenerateRelationsCurrent)
        wx.EVT_MENU(self, TOOLS_GENERATERELSALL, self.GenerateRelationsAll)
        wx.EVT_MENU(self, TOOLS_TOGGLELABELS, self.ToggleLabels)
        wx.EVT_MENU(self, EDIT_CLEAR, self.Delete)

    def AddEntity(self, e):
        entity = self.model.CreateEntity("Entity 1")
        self.model.AddEntity(entity)
        self.modelview.AddEntity(entity, 100, 100, 120, 0)

    def EditProperties(self, e):
        a = PhysicalPropertiesDialog(self.modelview, -1, "Edit property list", self.model)
        a.ShowModal()
        a.Destroy()

    def EditCurrentEntity(self, e):
        a = self.modelview.GetCurrentEntityView()
        if a != None:
            a.Edit()

    def GenerateRelations(self, e1, e2):
        if self.model.HasRelation(e1, e2):
            return
        key = self.model.GetKey(e1, e2)
        if key != None:
            r = PhysicalRelation(e1, e2, key)
            self.model.AddRelation(r)
            self.modelview.AddRelationView(r)
            
    def GenerateRelationsAll(self, e):
       for i in self.model.entities:
           for j in self.model.entities:
               self.GenerateRelations(i, j)
    
    def GenerateRelationsCurrent(self, e):
        entity = self.modelview.GetCurrentEntityView().entity
        for j in self.model.entities:
            self.GenerateRelations(entity, j)

    def GenerateRelationsAll(self, e):
        for i in self.model.entities:
            for j in self.model.entities:
                if i != j:
                    self.GenerateRelations(i, j)
    
    def Delete(self, e):
        a = self.modelview.GetCurrentEntityView()
        if(a != None):
            entity = a.entity
            self.modelview.DeleteCurrentEntityView()
            self.model.DeleteEntity(entity)
        a = self.modelview.GetCurrentRelationView()
        if(a != None):
            relation = a.relation
            self.modelview.DeleteCurrentRelationView()
            self.model.DeleteRelation(relation)
            self.modelview.DeleteCurrentRelationView()

    def Exit(self, e):
        self.Destroy()

    def New(self, e):
        self.model.DeleteAll()
        self.modelview.DeleteAll()
        self.filename = None
        self.sqlfilename = None
    def Save(self, e):
        if(self.filename == None):
            self.SaveAs(e)
        else:
            self.doSave()
    def checkFile(self, fn):
        r=wx.wxYES
        if exists(fn):
            r = wx.wxMessageBox("File exists. Do you want to overwrite?", "File exists", wx.wxYES_NO|wx.wxCENTRE)
        if(r==wx.wxNO):
            return None
        else:
            return fn

    def SaveAs(self, e):
        dialog = wx.wxFileDialog(self, wildcard="XML files (*.xml)|*.xml|Model files (*.ppd)|*.ppd")
        n = dialog.ShowModal()
        if (n == wx.wxID_OK):
            fn = self.checkFile(dialog.GetPath())
            if(fn == None):
                return
            self.filename = fn
            self.doSave()

    def SaveAsSql92(self, e):
        dialog = wx.wxFileDialog(self, wildcard="SQL files (*.sql)|*.sql")
        n = dialog.ShowModal()
        if (n == wx.wxID_OK):
            fn = self.checkFile(dialog.GetPath())
            if(fn == None):
                return
            self.sqlfilename = fn
            self.doSaveSql92()
          
    def SaveAsMySQL(self, e):
        dialog = wx.wxFileDialog(self, wildcard="SQL files (*.sql)|*.sql")
        n = dialog.ShowModal()
        if (n == wx.wxID_OK):
            fn = self.checkFile(dialog.GetPath())
            if(fn == None):
                return
            self.sqlfilename = fn
            self.doSaveMySQL()

    def Open(self, e):
        dialog = wx.wxFileDialog(self, wildcard="XML files (*.xml)|*.xml|Model files (*.ppd)|*.ppd")
        n = dialog.ShowModal()
        if (n == wx.wxID_OK):
            self.model.DeleteAll()
            self.modelview.DeleteAll()
            self.filename = dialog.GetPath()
            self.doOpen()

    def Print(self, e):
        self.modelview.OnDoPrint(e)

    def PrintPreview(self, e):
        self.modelview.OnPrintPreview(e)

    def PrintSetup(self, e):
        self.modelview.OnPrintSetup(e)

    def ToggleLabels(self, e):
        self.modelview.ToggleLabels(e)
