from Entity import Entity
from Utils import FindInList

_name = ""
class Model(object):
    __slots__ = ('name', 'entities', 'relationships')
    def __init__(self, _name):
        self.name = _name
        self.entities = []
        self.relations = []
        self.properties = []

    def AddEntity(self, entity):
        self.entities.append(entity)

    def DeleteEntity(self, entity):
        toDel = FindInList(self.entities, entity)
        if(toDel != None):
            del self.entities[toDel]

    def DeleteAll(self):
        self.entities = []
        self.properties = []
        self.relations = []

    def AddProperty(self, property):
        self.properties.append(property)

    def FindProperty(self, name):
        for i in self.properties:
            if(i.name == name):
                return i
        return None

    def FindEntity(self, name):
        for i in self.entities:
            if(i.name == name):
                return i
        return None

    def CreateEntity(self, name):
        return Entity(name)

    def AddRelation(self, relation):
        self.relations.append(relation)

    def DeleteRelation(self, relation):
        toDel = FindInList(self.relations, relation)
        if(toDel != None):
            del self.relations[toDel]
