from PropertyType import PropertyType

class PhysicalPropertyType (PropertyType) :
    __slots__ = ('name', 'size1', 'size2')
   
class IntType (PhysicalPropertyType) :
    DefaultName = "int"
    def __init__(self, _size1, _size2):
        if (_size1 == None):
            raise AssertionError, "Invalid size"
        self.name = "int"
        self.size1 = _size1
        self.size2 = None

class VarcharType (PhysicalPropertyType) :
    DefaultName = "varchar"
    def __init__(self, _size1, _size2):
        if (_size1 == None):
            raise AssertionError, "Invalid size"
        self.name = "varchar"
        self.size1 = _size1
        self.size2 = None

class CharType (PhysicalPropertyType) :
    DefaultName = "char"
    def __init__(self, _size1, _size2):
        if (_size1 == None):
            raise AssertionError, "Invalid size"
        self.name = "char"
        self.size1 = _size1
        self.size2 = None

class TimestampType (PhysicalPropertyType) :
    DefaultName = "timestamp"
    def __init__(self, _size1, _size2):
        self.name = "timestamp"
        self.size1 = None
        self.size2 = None

class DecimalType (PhysicalPropertyType) :
    DefaultName = "decimal"
    def __init__(self, _size1, _size2):
        if (_size1 == None):
            raise AssertionError, "Invalid size"
        self.name = "decimal"
        self.size1 = _size1
        self.size2 = _size2

class FloatType (PhysicalPropertyType) :
    DefaultName = "float"
    def __init__(self, _size1, _size2):
        if (_size1 == None):
            raise AssertionError, "Invalid size"
        self.name = "float"
        self.size1 = _size1
        self.size2 = _size2

class BlobType (PhysicalPropertyType) :
    DefaultName = "blob"
    def __init__(self, _size1, _size2):
        self.name = "blob"
        self.size1 = None
        self.size2 = None


# Postgresql 7.4 types:
class BooleanType (PhysicalPropertyType) :
   DefaultName = "boolean"
   def __init__(self, _size1, _size2):
      self.name = "boolean"
      self.size1 = None
      self.size2 = None

class SerialType (PhysicalPropertyType) :
   DefaultName = "serial"
   def __init__(self, _size1, _size2):
      self.name = "serial"
      self.size1 = _size1
      self.size2 = None
	
class TimestampWithTimeZoneType (PhysicalPropertyType) :
   DefaultName = "timestamp with time zone"
   def __init__(self, _size1, _size2):
      self.name = "timestamp with time zone"
      self.size1 = _size1
      self.size2 = None

class TimestampWithoutTimeZoneType (PhysicalPropertyType) :
   DefaultName = "timestamp without time zone"
   def __init__(self, _size1, _size2):
      self.name = "timestamp without time zone"
      self.size1 = _size1
      self.size2 = None
  
class TextType (PhysicalPropertyType) :
   DefaultName = "text"
   def __init__(self, _size1, _size2):
      self.name = "text"
      self.size1 = _size1
      self.size2 = None

types = [IntType, VarcharType, CharType, TimestampType, DecimalType, FloatType, BlobType, BooleanType, SerialType, TimestampWithoutTimeZoneType, TimestampWithTimeZoneType, TextType]

def FindType(name):
    for i in types:
        if(i.DefaultName == name):
            return i
    return None
