from xml.dom import minidom, Node
from Objects import PhysicalModel
from Objects import PhysicalEntity
from Objects import PhysicalProperty
from Objects import PhysicalPropertyLink
from Objects import types
from Objects import FindType
from Objects import PhysicalRelation
import Objects
from Gui.PhysicalModelView import PhysicalModelView
from Gui.PhysicalEntityView import PhysicalEntityView
from Gui.PhysicalRelationView import PhysicalRelationView

class ReadModel (object) :
    __slots__ = ('filename', 'model')
    def __init__(self, fname) :
        self.filename = fname
        self.model = None
      
    def read(self, frame, view) :
        dom = minidom.parse(self.filename)
        for  i in dom.childNodes:
            if i.nodeName == "PhysicalModel":
                self.model = self.ReadPhysicalModel(i)
        dom = minidom.parse(self.filename+".view")
        for  i in dom.childNodes:
            if i.nodeName == "PhysicalModelView":
                self.ReadPhysicalModelView(i, frame, view)
        for i in self.model.relations:
            view.AddRelationView(i)
        return self.model

    def ReadPhysicalModel(self, domobj):
        self.model = PhysicalModel(domobj.getAttribute("Name"))
        for i in domobj.childNodes:
            if i.nodeName == "PhysicalEntity":
                entity = self.ReadPhysicalEntity(i)
                self.model.AddEntity(entity)
            if i.nodeName == "PhysicalProperty":
                property = self.ReadPhysicalProperty(i)
                self.model.AddProperty(property)
            if i.nodeName == "PhysicalRelation":
                property = self.ReadPhysicalRelation(i)
                self.model.AddRelation(property)
        return self.model

    def ReadPhysicalEntity(self, domobj):
        entity = PhysicalEntity(domobj.getAttribute("Name"))
        for i in domobj.childNodes:
            if i.nodeName == "PhysicalPropertyLink":
                proplink = self.ReadPhysicalPropertyLink(i)
                entity.AddPropertyLink(proplink)
        return entity

    def ReadPhysicalProperty(self, domobj):
        prop = None
        for i in domobj.childNodes:
            if i.nodeType == Node.ELEMENT_NODE:
                type_ = Objects.__dict__[i.nodeName]
                if type_ != None:
                    try:
                        size1 = int(i.getAttribute("size1"))
                    except:
                        size1 = None
                    try:
                        size2 = int(i.getAttribute("size2"))
                    except:
                        size2 = None
                    prop = PhysicalProperty(domobj.getAttribute("Name"), type_, size1, size2)
        return prop

    def ReadPhysicalRelation(self, domobj):
        n1 = domobj.getAttribute("Parent")
        n2 = domobj.getAttribute("Child")
        e1 = self.model.FindEntity(n1)
        e2 = self.model.FindEntity(n2)
        props = []
        for i in domobj.childNodes:
            if i.nodeName == "Key":
                prop=self.model.FindProperty(i.getAttribute("Property"))
                props.append(prop)
        rel = PhysicalRelation(e1, e2, props)
        return rel

    def ReadPhysicalPropertyLink(self, domobj):
        primarykey = int(domobj.getAttribute("PrimaryKey"))
        unique = int(domobj.getAttribute("Unique"))
        try:
            notnull = int(domobj.getAttribute("NotNull"))
        except:
            notnull = 0
        try:
            editable = int(domobj.getAttribute("Editable"))
        except:
            editable = 0
        localname = domobj.getAttribute("LocalName")
        name = domobj.getAttribute("Name")
	try:
		sequence = domobj.getAttribute("Sequence")
	except:
		sequence = 0
        property = None
        for i in self.model.properties:
            if i.name == name:
                property = i
                break
        if property == None:
            print str(name)+" not found"
            return None
        proplink = PhysicalPropertyLink(property, primarykey, unique, notnull, editable, localname, sequence)
        return proplink

    def ReadPhysicalModelView(self, domobj, frame, view):
        n = 0
        for i in domobj.childNodes:
            if i.nodeName == "PhysicalEntityView":
                x = int(i.getAttribute("x"))
                y = int(i.getAttribute("y"))
                w = int(i.getAttribute("w"))
                h = int(i.getAttribute("h"))
                view.AddEntity(self.model.entities[n], x, y, w, h)
                n = n + 1
