# Save Model to XML format

from xml.dom import minidom

from Objects import PhysicalModel
from Objects import PhysicalEntity
from Objects import PhysicalProperty
from Objects import PhysicalPropertyLink
from Objects import PhysicalRelation

class SaveModel (object) :
    __slots__ = ('filename')
    def __init__(self, fname):
        self.filename = fname

    def save(self, model, view) :
        #saving model
        f = file(self.filename, 'w+')
        dom = self.SavePhysicalModel(model)
        f.write(dom.toprettyxml())
        f.close()
        
        #saving view
        f = file(self.filename+".view", 'w+')
        dom = self.SavePhysicalModelView(view)
        f.write(dom.toprettyxml())
        f.close()

    def SavePhysicalModel(self, model):
        doc = minidom.Document()
        element = minidom.Element("PhysicalModel")
        element.setAttribute("Name", model.name)
        for i in model.properties:
            element.appendChild(self.SavePhysicalProperty(i))
        for i in model.entities:
            element.appendChild(self.SavePhysicalEntity(i))
        for i in model.relations:
            element.appendChild(self.SavePhysicalRelation(i))
        doc.appendChild(element)
        return doc

    def SavePhysicalEntity(self, entity):
        element = minidom.Element("PhysicalEntity")
        element.setAttribute("Name", entity.name)
        for i in entity.propertylinks:
            element.appendChild(self.SavePhysicalPropertyLink(i))
        return element

    def SavePhysicalPropertyLink(self, proplink):
        element = minidom.Element("PhysicalPropertyLink")
        element.setAttribute("Name", proplink.property.name)
        element.setAttribute("LocalName", proplink.localname)
        element.setAttribute("PrimaryKey", str(proplink.primarykey))
        element.setAttribute("Unique", str(proplink.unique))
        element.setAttribute("NotNull", str(proplink.notnull))
        element.setAttribute("Editable", str(proplink.editable))
	element.setAttribute("Sequence", str(proplink.sequence))
        return element

    def SavePhysicalProperty(self, property):
        element = minidom.Element("PhysicalProperty")
        element.setAttribute("Name", property.name)
        element.appendChild(self.SavePhysicalPropertyType(property.datatype))
        return element

    def SavePhysicalPropertyType(self, type):
        element = minidom.Element(type.__class__.__name__)
        element.setAttribute("Name", type.name)
        if(type.size1 <> None):
            element.setAttribute("size1", `type.size1`)
        if(type.size2 <> None):
            element.setAttribute("size2", `type.size2`)
        return element

    def SavePhysicalRelation(self, r):
        element = minidom.Element("PhysicalRelation")
        element.setAttribute("Name", r.entities[0].name+"_"+r.entities[1].name)
        element.setAttribute("Parent",r.entities[0].name)
        element.setAttribute("Child",r.entities[1].name)
        try:
            for i in r.properties:
                e2 = minidom.Element("Key")
                e2.setAttribute("Property",i.name)
                element.appendChild(e2)
            return element
        except TypeError:
            print "type error ", r, r.properties, r.entities[0].name, r.entities[1].name
        return element

    def SavePhysicalModelView(self, view):
        doc = minidom.Document()
        element = minidom.Element("PhysicalModelView")
        for i in view.entityViews:
            element.appendChild(self.SavePhysicalEntityView(i))
        doc.appendChild(element)
        return doc

    def SavePhysicalEntityView(self, entityview):
        element = minidom.Element("PhysicalEntityView")
        element.setAttribute("x", str(int(entityview.GetX())))
        element.setAttribute("y", str(int(entityview.GetY())))
        element.setAttribute("w", str(int(entityview.GetWidth())))
        element.setAttribute("h", str(int(entityview.GetHeight())))
        return element
