/*
 * Decompiled with CFR 0.152.
 */
package org.scrollingArray;

import java.lang.reflect.Array;
import org.scrollingArray.ScrollingArray;

public class CombinatorialArray<T> {
    private final T[] originalArray;
    private final int maxCombinations;
    private ScrollingArray scrollingArray;
    private int currentCombinationSize;

    public CombinatorialArray(T[] originalArray, int combinationSize) {
        this.validateCombinationSize(combinationSize, originalArray.length);
        this.originalArray = originalArray;
        this.currentCombinationSize = combinationSize;
        this.maxCombinations = combinationSize;
        this.scrollingArray = new ScrollingArray(combinationSize, originalArray.length);
    }

    public CombinatorialArray(T[] originalArray, int combinationSize, int maxCombinations) {
        this.validateCombinationSize(combinationSize, originalArray.length);
        if (combinationSize > maxCombinations) {
            throw new IllegalArgumentException("maxCombinations must be at least combinationSize: " + maxCombinations);
        }
        if (maxCombinations > originalArray.length) {
            throw new IllegalArgumentException("maxCombinations cannot exceed array length: " + maxCombinations);
        }
        this.originalArray = originalArray;
        this.currentCombinationSize = combinationSize;
        this.maxCombinations = maxCombinations;
        this.scrollingArray = new ScrollingArray(combinationSize, originalArray.length);
    }

    public T[] getNewArray() {
        int[] indices = this.scrollingArray.getArray();
        Object[] newArray = (Object[])Array.newInstance(this.originalArray.getClass().getComponentType(), indices.length);
        int i = 0;
        while (i < indices.length) {
            newArray[i] = this.originalArray[indices[i]];
            ++i;
        }
        return newArray;
    }

    public boolean scroll() {
        if (this.scrollingArray.scroll()) {
            return true;
        }
        if (this.currentCombinationSize < this.maxCombinations) {
            ++this.currentCombinationSize;
            this.scrollingArray = new ScrollingArray(this.currentCombinationSize, this.originalArray.length);
            return true;
        }
        return false;
    }

    private void validateCombinationSize(int combinationSize, int arrayLength) {
        if (combinationSize < 1 || combinationSize > arrayLength) {
            throw new IllegalArgumentException("Invalid combination size: " + combinationSize);
        }
    }
}

