/*
 * Decompiled with CFR 0.152.
 */
package org.scrollingArray;

import java.util.ArrayList;
import java.util.List;
import org.scrollingArray.ScrollingArray;

public class CombinatorialArrayList<T> {
    private final List<T> originalList;
    private final int maxCombinations;
    private ScrollingArray scrollingArray;
    private int currentCombinationSize;

    public CombinatorialArrayList(List<T> originalList, int combinationSize) {
        this.validateCombinationSize(combinationSize, originalList.size());
        this.originalList = originalList;
        this.currentCombinationSize = combinationSize;
        this.maxCombinations = combinationSize;
        this.scrollingArray = new ScrollingArray(combinationSize, originalList.size());
    }

    public CombinatorialArrayList(List<T> originalList, int combinationSize, int maxCombinations) {
        this.validateCombinationSize(combinationSize, originalList.size());
        if (combinationSize > maxCombinations) {
            throw new IllegalArgumentException("maxCombinations must be at least combinationSize: " + maxCombinations);
        }
        if (maxCombinations > originalList.size()) {
            throw new IllegalArgumentException("maxCombinations cannot exceed list size: " + maxCombinations);
        }
        this.originalList = originalList;
        this.currentCombinationSize = combinationSize;
        this.maxCombinations = maxCombinations;
        this.scrollingArray = new ScrollingArray(combinationSize, originalList.size());
    }

    public List<T> getNewList() {
        ArrayList<T> newList = new ArrayList<T>();
        int[] nArray = this.scrollingArray.getArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int pos = nArray[n2];
            newList.add(this.originalList.get(pos));
            ++n2;
        }
        return newList;
    }

    public boolean scroll() {
        if (this.scrollingArray.scroll()) {
            return true;
        }
        if (this.currentCombinationSize < this.maxCombinations) {
            ++this.currentCombinationSize;
            this.scrollingArray = new ScrollingArray(this.currentCombinationSize, this.originalList.size());
            return true;
        }
        return false;
    }

    private void validateCombinationSize(int combinationSize, int listSize) {
        if (combinationSize < 1 || combinationSize > listSize) {
            throw new IllegalArgumentException("Invalid combination size: " + combinationSize);
        }
    }
}

