/*
 * Decompiled with CFR 0.152.
 */
package org.scrollingArray;

public class ScrollingArray {
    private final int combinationCount;
    private final int originalSize;
    private final int[] array;
    private final boolean repeatAllPositions;

    public ScrollingArray(int combinationCount, int originalSize) {
        this(combinationCount, originalSize, false);
    }

    public ScrollingArray(int combinationCount, int originalSize, boolean repeatAllPositions) {
        this.combinationCount = combinationCount;
        this.originalSize = originalSize;
        this.repeatAllPositions = repeatAllPositions;
        this.array = new int[combinationCount];
        int i = 0;
        while (i < combinationCount) {
            this.array[i] = repeatAllPositions ? 0 : i;
            ++i;
        }
    }

    public int[] getArray() {
        return this.array;
    }

    public boolean scroll() {
        return this.scroll(this.combinationCount - 1);
    }

    private boolean scroll(int level) {
        if (level < 0) {
            return false;
        }
        int n = level;
        this.array[n] = this.array[n] + 1;
        if (this.array[level] <= this.originalSize - (this.combinationCount - level)) {
            return true;
        }
        if (this.scroll(level - 1)) {
            this.array[level] = this.repeatAllPositions ? 0 : this.array[level - 1] + 1;
            return true;
        }
        return false;
    }
}

